/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TVBlockEntity
extends ItemDisplayTile {
    @Nullable
    private UUID linkedFeedUuid = null;
    @Nullable
    private Holder<CassetteTape> tape = null;
    private int connectedTvsSize = 1;
    private int soundLoopTicks = 0;
    private int animationTicks = 0;

    public TVBlockEntity(BlockPos pos, BlockState state) {
        super(VistaMod.TV_TILE.get(), pos, state);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ConnectedTVsSize", this.connectedTvsSize);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.connectedTvsSize = tag.getInt("ConnectedTVsSize");
    }

    @Nullable
    public UUID getLinkedFeedUUID() {
        return this.linkedFeedUuid;
    }

    @Nullable
    public Holder<CassetteTape> getTape() {
        return this.tape;
    }

    public int getScreenPixelSize() {
        return 12;
    }

    public SoundEvent getAddItemSound() {
        return VistaMod.CASSETTE_INSERT_SOUND.get();
    }

    protected Component getDefaultName() {
        return Component.literal((String)"tv");
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return true;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.is((Item)VistaMod.CASSETTE.get()) || stack.is((Item)VistaMod.HOLLOW_CASSETTE.get()) || VistaMod.EXPOSURE_ON && ExposureCompat.isPictureItem(stack);
    }

    private void cacheClientState() {
        ItemStack displayedItem = this.getDisplayedItem();
        this.linkedFeedUuid = (UUID)displayedItem.get(VistaMod.LINKED_FEED_COMPONENT.get());
        this.tape = (Holder)displayedItem.get(VistaMod.CASSETTE_TAPE_COMPONENT.get());
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.cacheClientState();
    }

    public ItemInteractionResult interactWithPlayerItem(Player player, InteractionHand handIn, ItemStack stack, int slot) {
        ItemStack current = this.getDisplayedItem();
        if (!current.isEmpty()) {
            this.level.playSound(player, this.worldPosition, VistaMod.CASSETTE_EJECT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            Vec3 vec3 = this.level.getBlockState(this.worldPosition.above()).isSolid() ? this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)TVBlock.FACING)).getCenter() : Vec3.atLowerCornerWithOffset((Vec3i)this.worldPosition, (double)0.5, (double)1.05, (double)0.5);
            vec3 = vec3.offsetRandom(this.level.random, 0.7f);
            ItemStack itemStack2 = current.copy();
            ItemEntity itemEntity = new ItemEntity(this.level, vec3.x(), vec3.y(), vec3.z(), itemStack2);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
            this.clearContent();
            this.setChanged();
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return super.interactWithPlayerItem(player, handIn, stack, slot);
    }

    public boolean hasVideo() {
        return this.linkedFeedUuid != null;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TVBlockEntity tile) {
        if (((Boolean)state.getValue((Property)TVBlock.POWERED)).booleanValue()) {
            int n;
            float duration = tile.getPlayDuration();
            ++tile.soundLoopTicks;
            if ((float)n >= duration) {
                tile.soundLoopTicks = 0;
                SoundEvent sound = tile.getPlaySound();
                level.playLocalSound(pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            ++tile.animationTicks;
        } else {
            tile.soundLoopTicks = 0;
            tile.animationTicks = 0;
        }
    }

    private SoundEvent getPlaySound() {
        Optional<Holder<SoundEvent>> s;
        if (this.tape != null && (s = ((CassetteTape)this.tape.value()).soundEvent()).isPresent()) {
            return (SoundEvent)s.get().value();
        }
        return (SoundEvent)VistaMod.TV_STATIC_SOUND.get();
    }

    private int getPlayDuration() {
        if (this.tape != null) {
            return ((CassetteTape)this.tape.value()).soundDuration().orElse(80);
        }
        return 80;
    }

    public int getAnimationTick() {
        return this.animationTicks;
    }
}

