/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ViewFinderConnection
extends WorldSavedData {
    public static final Codec<ViewFinderConnection> CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)GlobalPos.CODEC).xmap(map -> {
        ViewFinderConnection storage = new ViewFinderConnection();
        storage.linkedFeeds.putAll((Map<UUID, GlobalPos>)map);
        return storage;
    }, storage -> storage.linkedFeeds);
    public static final StreamCodec<RegistryFriendlyByteBuf, ViewFinderConnection> STREAM_CODEC = ByteBufCodecs.map(i -> new HashMap(), (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)GlobalPos.STREAM_CODEC).map(map -> {
        ViewFinderConnection storage = new ViewFinderConnection();
        storage.linkedFeeds.putAll((Map<UUID, GlobalPos>)map);
        return storage;
    }, storage -> storage.linkedFeeds);
    private final HashMap<UUID, GlobalPos> linkedFeeds = new HashMap();

    private ViewFinderConnection() {
    }

    public static ViewFinderConnection create(ServerLevel serverLevel) {
        return new ViewFinderConnection();
    }

    public void linkFeed(UUID viewFinderUUID, GlobalPos projectorPos) {
        GlobalPos old = this.linkedFeeds.get(viewFinderUUID);
        if (projectorPos.equals((Object)old)) {
            return;
        }
        this.linkedFeeds.put(viewFinderUUID, projectorPos);
        this.setDirty();
        this.sync();
    }

    public void unlinkFeed(UUID viewFinderUUID) {
        if (this.linkedFeeds.remove(viewFinderUUID) != null) {
            this.setDirty();
            this.sync();
        }
    }

    @Nullable
    public GlobalPos getLinkedFeedLocation(UUID viewFinderUUID) {
        return this.linkedFeeds.get(viewFinderUUID);
    }

    @Nullable
    public ViewFinderBlockEntity getLinkedViewFinder(Level level, UUID viewFinderUUID) {
        BlockEntity blockEntity;
        BlockPos pos;
        GlobalPos gp = this.linkedFeeds.get(viewFinderUUID);
        if (gp != null && gp.dimension() == level.dimension() && level.isLoaded(pos = gp.pos()) && (blockEntity = level.getBlockEntity(pos)) instanceof ViewFinderBlockEntity) {
            ViewFinderBlockEntity be = (ViewFinderBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public WorldSavedDataType<ViewFinderConnection> getType() {
        return VistaMod.VIEWFINDER_CONNECTION;
    }

    public static ViewFinderConnection get(Level level) {
        ViewFinderConnection connection = (ViewFinderConnection)VistaMod.VIEWFINDER_CONNECTION.getData(level);
        return connection;
    }

    public void validateAll(ServerLevel level) {
        if (!level.isClientSide) {
            AtomicBoolean changed = new AtomicBoolean(false);
            this.linkedFeeds.entrySet().removeIf(e -> {
                GlobalPos pos = (GlobalPos)e.getValue();
                if (pos.dimension() != level.dimension()) {
                    return false;
                }
                if (level.getBlockEntity(pos.pos()) instanceof ViewFinderBlockEntity) {
                    return false;
                }
                changed.set(true);
                this.setDirty();
                return true;
            });
            if (changed.get()) {
                this.sync();
            }
        }
    }
}

