/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.network;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.ViewFinderAccess;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ServerBoundSyncViewFinderPacket(float yaw, float pitch, int zoomLevel, boolean locked, boolean stopControlling, TileOrEntityTarget target) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSyncViewFinderPacket> CODEC = Message.makeType((ResourceLocation)VistaMod.res("c2s_sync_viewfinder"), ServerBoundSyncViewFinderPacket::new);

    public ServerBoundSyncViewFinderPacket(FriendlyByteBuf buf) {
        this(buf.readFloat(), buf.readFloat(), buf.readVarInt(), buf.readBoolean(), buf.readBoolean(), TileOrEntityTarget.read((FriendlyByteBuf)buf));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeVarInt(this.zoomLevel);
        buf.writeBoolean(this.locked);
        buf.writeBoolean(this.stopControlling);
        this.target.write((FriendlyByteBuf)buf);
    }

    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ViewFinderAccess access = ViewFinderAccess.find(player2.level(), this.target);
            if (access != null) {
                ViewFinderBlockEntity cannon = access.getInternalTile();
                if (cannon.isEditingPlayer(BlockPos.containing((Position)access.getCannonGlobalPosition(1.0f)), (Player)player2)) {
                    cannon.setAttributes(this.yaw, this.pitch, this.zoomLevel, this.locked, (Player)player2, access);
                    cannon.setChanged();
                    if (this.stopControlling) {
                        cannon.setPlayerWhoMayEdit(null);
                    }
                    access.updateClients();
                } else {
                    VistaMod.LOGGER.warn("Player tried to control cannon {} without permission: {}", (Object)player2.getName().getString(), (Object)this.target);
                }
            } else {
                VistaMod.LOGGER.warn("Cannon not found for player {}: {}", (Object)player2.getName().getString(), (Object)this.target);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

