/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.LiveFeedRendererManager;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.client.TapeTextureManager;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.configs.ClientConfigs;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompatClient;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class TvBlockEntityRenderer
implements class_827<TVBlockEntity> {
    public TvBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public int method_33893() {
        return 96;
    }

    public void render(TVBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int light, int overlay) {
        class_2960 texture;
        if (!((Boolean)blockEntity.method_11010().method_11654((class_2769)TVBlock.POWERED)).booleanValue()) {
            return;
        }
        class_2350 dir = (class_2350)blockEntity.method_11010().method_11654((class_2769)TVBlock.field_11177);
        LOD lod = LOD.at((class_2586)blockEntity);
        if (lod.isPlaneCulled(dir, 0.5f, 0.0f)) {
            return;
        }
        float yaw = dir.method_10144();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        poseStack.method_22904(-0.5, -0.5, -0.5);
        boolean drawingCamera = LiveFeedRendererManager.LIVE_FEED_BEING_RENDERED != null;
        class_4588 vc = null;
        int screenPixelSize = blockEntity.getScreenPixelSize();
        UUID liveFeedId = blockEntity.getLinkedFeedUUID();
        class_6880<CassetteTape> tape = blockEntity.getTape();
        class_1799 stack = blockEntity.getDisplayedItem();
        if (liveFeedId != null) {
            boolean shouldUpdate = lod.within(ClientConfigs.UPDATE_DISTANCE.get().doubleValue());
            class_2960 tex = LiveFeedRendererManager.requestLiveFeedTexture(blockEntity.method_10997(), liveFeedId, screenPixelSize, shouldUpdate);
            if (tex != null) {
                this.maybeRenderDebug(tex, poseStack, buffer, partialTick);
                vc = TapeTextureManager.getFullSpriteVC(tex, buffer, drawingCamera);
            } else {
                vc = TapeTextureManager.getDefaultTapeVC(buffer, drawingCamera);
            }
        } else if (tape != null) {
            if (drawingCamera) {
                class_4730 mat = TapeTextureManager.getMaterialFlat(tape);
                vc = mat.method_24145(buffer, class_1921::method_23028);
            } else {
                class_4730 mat = TapeTextureManager.getMaterial(tape);
                vc = mat.method_24145(buffer, t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((class_2960)t, mat));
            }
        } else if (VistaMod.EXPOSURE_ON && (texture = ExposureCompatClient.getPictureTextureForRenderer(stack, blockEntity.getAnimationTick())) != null) {
            vc = TapeTextureManager.getFullSpriteVC(texture, buffer, drawingCamera);
        }
        if (vc == null) {
            vc = buffer.getBuffer(ModRenderTypes.NOISE);
        }
        light = 0xF000F0;
        float s = (float)screenPixelSize / 32.0f;
        poseStack.method_22904(0.5, 0.5, -0.001);
        int lightU = light & 0xFFFF;
        int lightV = light >> 16 & 0xFFFF;
        VertexUtil.addQuad((class_4588)vc, (class_4587)poseStack, (float)(-s), (float)(-s), (float)s, (float)s, (int)lightU, (int)lightV);
    }

    private void maybeRenderDebug(class_2960 tex, class_4587 poseStack, class_4597 buffer, float partialTick) {
        if (!ClientConfigs.isDebugOn()) {
            return;
        }
        poseStack.method_22903();
        try {
            class_327 font = class_310.method_1551().field_1772;
            poseStack.method_22904(1.0, 1.5, 0.0);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-180.0f));
            poseStack.method_22905(0.0625f, -0.0625f, 0.0625f);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            RollingBuffer<Long> lastUpdateTimes = LiveFeedRendererManager.UPDATE_TIMES.get(tex);
            double averageUpdateinterval = TvBlockEntityRenderer.calculateAverageUpdateTime(lastUpdateTimes);
            font.method_27521(String.format("up rate %.2f", averageUpdateinterval), 0.0f, 0.0f, -1, false, poseStack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, class_4608.field_21444, 0xF000F0);
            double updateMs = LiveFeedRendererManager.SCHEDULER.getAverageUpdateTimeMs();
            font.method_27521(String.format("up ms %.2f", updateMs), 0.0f, -9.0f, -1, false, poseStack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, class_4608.field_21444, 0xF000F0);
        }
        catch (Exception ignored) {
            boolean bl = true;
        }
        poseStack.method_22909();
    }

    static double calculateAverageUpdateTime(RollingBuffer<Long> lastUpdateTimes) {
        int size = lastUpdateTimes.size();
        if (size < 2) {
            return 0.0;
        }
        long totalDiff = 0L;
        for (int i = 1; i < size; ++i) {
            totalDiff += (Long)lastUpdateTimes.get(i) - (Long)lastUpdateTimes.get(i - 1);
        }
        return (double)totalDiff / ((double)size - 1.0);
    }
}

