/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.common.TvConnection;
import net.mehvahdjukaar.vista.common.TvHelper;
import net.mehvahdjukaar.vista.configs.CommonConfigs;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5151;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class TVBlock
extends class_2383
implements class_2343,
class_5151 {
    public static final MapCodec<TVBlock> CODEC = TVBlock.method_54094(TVBlock::new);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<TvConnection> CONNECTION = class_2754.method_11850((String)"connection", TvConnection.class);

    public TVBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(state -> (Boolean)state.method_11654((class_2769)POWERED) != false ? 3 : 0));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(CONNECTION, (Comparable)((Object)TvConnection.NONE))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177});
        builder.method_11667(new class_2769[]{POWERED});
        builder.method_11667(new class_2769[]{CONNECTION});
    }

    public class_1304 method_7685() {
        return class_1304.field_6169;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return !level.field_9236 ? null : Utils.getTicker(blockEntityType, VistaMod.TV_TILE.get(), TVBlockEntity::clientTick);
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        class_2680 neighborState;
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        boolean powered = level.method_49803(pos);
        if (neighborBlock == this && TVBlock.facingSameDir(neighborState = level.method_8320(neighborPos), state) && ((TvConnection)((Object)state.method_11654(CONNECTION))).isConnected((TvConnection)((Object)neighborState.method_11654(CONNECTION)))) {
            powered |= ((Boolean)neighborState.method_11654((class_2769)POWERED)).booleanValue();
        }
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            if (powered) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)));
            } else {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private static boolean facingSameDir(class_2680 neighborState, class_2680 state) {
        return neighborState.method_11654((class_2769)field_11177) == state.method_11654((class_2769)field_11177);
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);
        if (!state.method_27852(oldState.method_26204())) {
            this.updateAllConnections(state, level, pos);
        }
    }

    @Nullable
    private TVBlockEntity getMasterBlockEntity(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof TVBlockEntity) {
            TVBlockEntity tv = (TVBlockEntity)be;
            return tv;
        }
        return null;
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        boolean powered = context.method_8045().method_49803(context.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TVBlockEntity(pos, state);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TVBlockEntity) {
            TVBlockEntity tile = (TVBlockEntity)class_25862;
            return tile.interactWithPlayerItem(player, hand, stack);
        }
        return class_9062.field_47731;
    }

    private void updateAllConnections(class_2680 state, class_1937 level, class_2338 pos) {
        if (!CommonConfigs.CONNECTED_TVS.get().booleanValue()) {
            return;
        }
        TVGridAccess gridAccess = new TVGridAccess(level, pos, state);
        TvHelper.updateConnections(gridAccess);
        gridAccess.applyChanges();
    }

    @Deprecated(forRemoval=true)
    public static class_2338 relativePos(class_2338 pos, class_2350 normal, int left, int top, int forward) {
        Preconditions.checkArgument((normal.method_10166() != class_2350.class_2351.field_11052 ? 1 : 0) != 0, (Object)"Normal direction cannot be vertical");
        if (forward != 0) {
            pos = pos.method_10079(normal, forward);
        }
        if (left != 0) {
            class_2350 leftDir = normal.method_10160();
            pos = pos.method_10079(leftDir, left);
        }
        if (top != 0) {
            pos = pos.method_10086(top);
        }
        return pos;
    }

    public static class TVGridAccess
    implements TvHelper.GridAccess {
        private final class_2338 pos;
        private final class_2350 facing;
        private final class_1937 level;
        private final Map<Vec2i, TvConnection> statesCache = new HashMap<Vec2i, TvConnection>();
        private final Map<Vec2i, TvConnection> statesChanged = new HashMap<Vec2i, TvConnection>();

        public TVGridAccess(class_1937 level, class_2338 pos, class_2680 state) {
            this.pos = pos;
            this.facing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
            this.level = level;
        }

        @Override
        @Nullable
        public TvConnection get(int left, int top) {
            Vec2i key = new Vec2i(left, top);
            if (this.statesChanged.containsKey(key)) {
                return this.statesChanged.get(key);
            }
            class_2338 target = TVBlock.relativePos(this.pos, this.facing, left, top, 0);
            class_2680 bs = this.level.method_8320(target);
            TvConnection value = null;
            if (bs.method_26204() instanceof TVBlock && bs.method_11654((class_2769)class_2383.field_11177) == this.facing) {
                value = (TvConnection)((Object)bs.method_11654(CONNECTION));
            }
            this.statesCache.put(key, value);
            return value;
        }

        @Override
        public void set(int left, int top, @Nullable TvConnection state) {
            Vec2i key = new Vec2i(left, top);
            TvConnection old = this.statesCache.get(key);
            if (old != state) {
                this.statesChanged.put(key, state);
            }
        }

        public void applyChanges() {
            for (Map.Entry<Vec2i, TvConnection> e : this.statesChanged.entrySet()) {
                Vec2i key = e.getKey();
                TvConnection conn = e.getValue();
                class_2338 target = TVBlock.relativePos(this.pos, this.facing, key.x, key.y, 0);
                class_2680 bs = this.level.method_8320(target);
                if (!(bs.method_26204() instanceof TVBlock) || conn == null) continue;
                this.level.method_8501(target, (class_2680)bs.method_11657(CONNECTION, (Comparable)((Object)conn)));
            }
        }
    }

    private record Vec2i(int x, int y) {
    }
}

