/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.animations;

import com.hm.efn.EFN;
import com.hm.efn.EFNConfig;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.mixin.ArmaturesAccessor;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class YamatoPhase
extends AvalonAttackAnimation.AvalonPhase {
    private final Supplier<? extends StaticAnimation> groundHitAnimation;
    private final Supplier<? extends StaticAnimation> airHitAnimation;
    private final Set<String> hitEntityIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> blacklistLoggedEntities = Collections.newSetFromMap(new ConcurrentHashMap());

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, Joint joint, Collider collider, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, joint, collider);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float impactDamageMulti, Joint joint, Collider collider, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, impactDamageMulti, joint, collider);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float impactDamageMulti, float phaseArmorNegationMulti, Joint joint, Collider collider, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, impactDamageMulti, phaseArmorNegationMulti, joint, collider);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, AttackAnimation.JointColliderPair[] colliders, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, colliders);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, AttackAnimation.JointColliderPair[] colliders, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, colliders);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float impactDamageMulti, AttackAnimation.JointColliderPair[] colliders, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, impactDamageMulti, colliders);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float impactDamageMulti, float phaseArmorNegationMulti, AttackAnimation.JointColliderPair[] colliders, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(start, antic, preDelay, contact, recovery, end, hand, damageMulti, impactDamageMulti, phaseArmorNegationMulti, colliders);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public YamatoPhase(InteractionHand hand, Joint joint, Collider collider, Supplier<? extends StaticAnimation> groundHitAnimation, Supplier<? extends StaticAnimation> airHitAnimation) {
        super(hand, joint, collider);
        this.groundHitAnimation = groundHitAnimation;
        this.airHitAnimation = airHitAnimation;
    }

    public void resetAttackRecord(LivingEntityPatch<?> entitypatch) {
        super.resetAttackRecord(entitypatch);
        this.hitEntityIds.clear();
        this.blacklistLoggedEntities.clear();
    }

    public void playHitAnimation(LivingEntityPatch<?> targetPatch, LivingEntityPatch<?> attackerPatch, AttackResult attackResult) {
        EFN.LOGGER.debug("YamatoPhase.playHitAnimation - Attempting to play hit animation");
        if (attackResult.resultType != AttackResult.ResultType.SUCCESS) {
            EFN.LOGGER.debug("YamatoPhase.playHitAnimation - Skipping: AttackResult is not SUCCESS (was: {})", (Object)attackResult.resultType);
            return;
        }
        if (this.shouldSkipHit(targetPatch, attackerPatch)) {
            return;
        }
        LivingEntity target = (LivingEntity)targetPatch.getOriginal();
        LivingEntity attacker = (LivingEntity)attackerPatch.getOriginal();
        String uniqueHitKey = attacker.m_19879_() + "_" + target.m_19879_();
        EFN.LOGGER.debug("YamatoPhase.playHitAnimation - Unique hit key: {}", (Object)uniqueHitKey);
        if (!this.hitEntityIds.contains(uniqueHitKey)) {
            try {
                Supplier<? extends StaticAnimation> animationSupplier;
                boolean isGrounded = target.m_20096_();
                Supplier<? extends StaticAnimation> supplier = animationSupplier = isGrounded ? this.groundHitAnimation : this.airHitAnimation;
                if (animationSupplier == null) {
                    return;
                }
                StaticAnimation animation = animationSupplier.get();
                EFN.LOGGER.debug("YamatoPhase.playHitAnimation - Playing animation");
                targetPatch.playAnimationSynchronized((AssetAccessor)animation.getAccessor(), 0.0f);
                this.hitEntityIds.add(uniqueHitKey);
                EFN.LOGGER.debug("YamatoPhase.playHitAnimation - Animation played successfully");
            }
            catch (Exception e) {
                EFN.LOGGER.error("YamatoPhase.playHitAnimation - Error playing animation", (Throwable)e);
            }
        } else {
            EFN.LOGGER.debug("YamatoPhase.playHitAnimation - This attacker already hit this target in this phase");
        }
    }

    private boolean shouldSkipHit(LivingEntityPatch<?> targetPatch, LivingEntityPatch<?> attackerPatch) {
        Player player;
        boolean canPlayAnimation;
        DoppelgangerEntity doppelganger;
        LivingEntity owner;
        LivingEntity attacker;
        EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Checking if should skip");
        if (targetPatch == null || targetPatch.getOriginal() == null || attackerPatch == null) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping due to null parameters");
            return true;
        }
        LivingEntity target = (LivingEntity)targetPatch.getOriginal();
        if (target == (attacker = (LivingEntity)attackerPatch.getOriginal())) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: target is attacker");
            return true;
        }
        if (target == attacker.m_20202_()) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: target is attacker's vehicle");
            return true;
        }
        if (attacker.m_20197_().contains(target)) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: target is attacker's passenger");
            return true;
        }
        if (attacker instanceof DoppelgangerEntity && target == (owner = (doppelganger = (DoppelgangerEntity)attacker).m_269323_())) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: doppelganger attacking owner");
            return true;
        }
        if (target instanceof DoppelgangerEntity && attacker == (owner = (doppelganger = (DoppelgangerEntity)target).m_269323_())) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: owner attacking own doppelganger");
            return true;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (entityId != null) {
            String entityIdString = entityId.toString();
            if (((List)EFNConfig.ANIMATION_BLACKLIST.get()).contains(entityIdString)) {
                EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: Entity {} is in blacklist", (Object)entityIdString);
                this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
                return true;
            }
        }
        boolean isInWhitelist = entityId != null && ((List)EFNConfig.ANIMATION_WHITELIST.get()).contains(entityId.toString());
        Armature armature = targetPatch.getArmature();
        Map<EntityType<?>, AssetAccessor<Armature>> map = ArmaturesAccessor.getEntityTypeArmatureMapper();
        AssetAccessor<? extends Armature> armatureAccessor = map.get(((LivingEntity)targetPatch.getOriginal()).m_6095_());
        boolean isHumanoidSkeleton = armature instanceof HumanoidArmature;
        boolean isBipedSkeleton = armatureAccessor == Armatures.BIPED;
        boolean isHoglinSkeleton = armatureAccessor == Armatures.HOGLIN;
        boolean isRavagerSkeleton = armatureAccessor == Armatures.RAVAGER;
        boolean bl = canPlayAnimation = isInWhitelist || isHumanoidSkeleton || isBipedSkeleton;
        if (!canPlayAnimation) {
            return true;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: player");
            return true;
        }
        if (target instanceof DoppelgangerEntity) {
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: DoppelgangerEntity");
            return true;
        }
        if (target instanceof VFXEntity) {
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: VFXEntity");
            return true;
        }
        if (target.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: STUN_IMMUNITY");
            return true;
        }
        if (target.m_21023_((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get())) {
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: SIN_STUN_IMMUNITY");
            return true;
        }
        if (target.m_21023_((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get())) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: INVINCIBILITY_EFFECT");
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            return true;
        }
        if (target.m_20147_()) {
            EFN.LOGGER.debug("YamatoPhase.shouldSkipHit - Skipping: isInvulnerable");
            this.blacklistLoggedEntities.add(String.valueOf(target.m_19879_()));
            return true;
        }
        return false;
    }
}

