/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.particle;

import com.hm.efn.api.TexturedSkinModelParticle;
import com.hm.efn.client.model.EFNMeshes;
import com.hm.efn.client.particle.efnparticletype.EfnParticleRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class YamatoLastSphere
extends TexturedSkinModelParticle {
    private LivingEntityPatch<?> caster;

    public YamatoLastSphere(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, AssetAccessor<SkinnedMesh> particleMesh, ResourceLocation texture) {
        super(level, x, y, z, xd, yd, zd, particleMesh, texture);
        this.f_107225_ = 44;
        this.f_107219_ = false;
        this.f_107231_ = (float)xd;
        this.pitch = (float)zd;
        this.scale = 12.0f;
        this.f_107230_ = 0.36f;
        Entity entity = level.m_6815_((int)Double.doubleToLongBits(yd));
        if (entity != null) {
            this.caster = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        }
    }

    public boolean shouldCull() {
        return false;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return EfnParticleRenderTypes.EFN_PARTICLE_MODEL_NO_NORMAL;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer vertexBuffer, Camera camera, float pt) {
        super.m_5744_(vertexBuffer, camera, pt);
        this.yaw += 0.05f;
        if (this.scale <= 85.0f) {
            this.scale += (float)Math.max(30 - this.f_107224_, 0) * 0.12f;
        }
        float a = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_;
        this.f_107230_ = Math.min(a, 0.36f);
        if (this.caster != null && this.caster.getStunShield() <= 0.0f) {
            this.m_107274_();
        }
    }

    @Override
    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        float yaw = Mth.m_14179_((float)partialTicks, (float)this.yawO, (float)this.yaw);
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float scale = Mth.m_14179_((float)partialTicks, (float)this.scaleO, (float)this.scale);
        poseStack.m_252880_(x, y, z);
        poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(this.pitch));
        poseStack.m_252781_(QuaternionUtils.ZP.rotationDegrees(this.f_107231_));
        poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(yaw));
        float time = ((float)this.f_107224_ + partialTicks) * 0.1f;
        float intensity = 0.05f;
        float distortX = 1.0f + Mth.m_14031_((float)(time * 1.3f + 0.5f)) * intensity;
        float distortY = 1.0f + Mth.m_14031_((float)(time * 0.9f)) * intensity;
        float distortZ = 1.0f + Mth.m_14089_((float)(time * 1.1f + 1.0f)) * intensity;
        poseStack.m_85841_(scale * distortX, scale * distortY, scale * distortZ);
    }

    public int m_6355_(float p_107086_) {
        int i = super.m_6355_(p_107086_);
        int k = i >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new YamatoLastSphere(level, x, y, z, xSpeed, ySpeed, zSpeed, (AssetAccessor<SkinnedMesh>)EFNMeshes.YAMATO_SPHERE, new ResourceLocation("efn", "textures/models/particle/yamato_particle.png"));
        }
    }
}

