/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.pipeline;

import com.google.common.collect.Queues;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.util.OjangUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class PostEffectPipelines {
    public static final Queue<Pipeline> PostEffectQueue = Queues.newConcurrentLinkedQueue();
    public static final PriorityQueue<Pipeline> PostEffectQueueInternal = Queues.newPriorityQueue();
    public static RenderTarget depth;
    public static Matrix4f shaderOrthoMatrix;
    static ResourceLocation depth_target;
    private static boolean Active;

    public static void RenderPost() {
        if (!PostEffectQueue.isEmpty()) {
            RenderSystem.enableBlend();
            depth = TargetManager.getTarget(depth_target);
            depth.m_83945_(Minecraft.m_91087_().m_91385_());
            depth.m_83970_();
            PostEffectQueue.removeIf(ppl -> {
                PostEffectQueueInternal.add((Pipeline)ppl);
                return true;
            });
            PostEffectPipelines.updateOrthoMatrix();
            while (!PostEffectQueueInternal.isEmpty()) {
                Pipeline renderType = PostEffectQueueInternal.poll();
                renderType.HandlePostEffect();
            }
            Minecraft.m_91087_().m_91385_().m_83945_(depth);
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
        PostEffectPipelines.close();
        TargetManager.ReleaseAll();
    }

    static void updateOrthoMatrix() {
        RenderTarget mainTarget = Minecraft.m_91087_().m_91385_();
        shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)mainTarget.f_83915_, 0.0f, (float)mainTarget.f_83916_, 0.1f, 1000.0f);
    }

    public static boolean isActive() {
        return Active;
    }

    public static void active() {
        Active = true;
    }

    public static void close() {
        Active = false;
    }

    public static RenderTarget getSource() {
        if (Minecraft.m_91087_().f_91060_.f_109418_ == null) {
            return Minecraft.m_91087_().m_91385_();
        }
        return Minecraft.m_91087_().f_91060_.m_109830_();
    }

    static {
        depth_target = OjangUtils.newRL("efn:depth_target");
        Active = false;
    }

    public static abstract class Pipeline
    implements Comparable<Pipeline> {
        public final ResourceLocation name;
        public int priority = 0;
        protected boolean called = false;
        protected boolean started = false;
        protected RenderTarget bufferTarget;

        public Pipeline(ResourceLocation name) {
            this.name = name;
        }

        @Override
        public int compareTo(Pipeline o) {
            if (this.priority > o.priority) {
                return 1;
            }
            if (this.priority == o.priority) {
                return 0;
            }
            return -1;
        }

        public void start() {
            if (this.started) {
                if (Active) {
                    this.bufferTarget.m_83945_(PostEffectPipelines.getSource());
                    this.bufferTarget.m_83947_(false);
                }
            } else {
                if (this.bufferTarget == null) {
                    this.bufferTarget = TargetManager.getTarget(this.name);
                    this.bufferTarget.m_83954_(Minecraft.f_91002_);
                }
                RenderTarget main = PostEffectPipelines.getSource();
                if (Active) {
                    this.bufferTarget.m_83945_(main);
                    PostEffectQueue.add(this);
                    this.bufferTarget.m_83947_(false);
                    this.started = true;
                }
            }
        }

        public void call() {
            if (Active) {
                this.called = true;
            }
        }

        public void suspend() {
            if (Active) {
                this.bufferTarget.m_83970_();
                this.bufferTarget.m_83963_();
                RenderTarget rt = PostEffectPipelines.getSource();
                rt.m_83945_(this.bufferTarget);
                rt.m_83947_(false);
            } else {
                PostEffectPipelines.getSource().m_83947_(false);
            }
        }

        public abstract void PostEffectHandler();

        public void HandlePostEffect() {
            if (this.called) {
                this.PostEffectHandler();
            }
            this.bufferTarget = null;
            this.started = false;
            this.called = false;
        }
    }
}

