/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class EFNSprintingCondition
implements Condition<ServerPlayerPatch> {
    private final boolean requireOnGround;
    private final boolean allowInWater;

    public EFNSprintingCondition() {
        this(true, true);
    }

    public EFNSprintingCondition(boolean requireOnGround, boolean allowInWater) {
        this.requireOnGround = requireOnGround;
        this.allowInWater = allowInWater;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        boolean requireOnGround = !compoundTag.m_128441_("requireOnGround") || compoundTag.m_128471_("requireOnGround");
        boolean allowInWater = !compoundTag.m_128441_("allowInWater") || compoundTag.m_128471_("allowInWater");
        return new EFNSprintingCondition(requireOnGround, allowInWater);
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("requireOnGround", this.requireOnGround);
        tag.m_128379_("allowInWater", this.allowInWater);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
        if (!player.m_20142_()) {
            return false;
        }
        return !this.requireOnGround || this.checkGroundCondition((Player)player);
    }

    private boolean checkGroundCondition(Player player) {
        if (this.allowInWater && player.m_20069_()) {
            return true;
        }
        return player.m_20096_();
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

