/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.doppelganger;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hm.efn.EFN;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.gameasset.EFNWeaponCategories;
import com.hm.efn.gameasset.animations.EFNYamatoAnimations;
import com.hm.efn.registries.EFNDataKey;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class DoppelgangerPatch
extends HumanoidMobPatch<DoppelgangerEntity> {
    @Nullable
    private PlayerPatch<?> ownerPatch;

    public DoppelgangerPatch() {
        super((Faction)Factions.UNDEAD);
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        super.commonAggresiveMobAnimatorInit(animator);
    }

    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(EFNWeaponCategories.EFN_YAMATO, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.WALK, EFNYamatoAnimations.YAMATO_WALK), Pair.of((Object)LivingMotions.CHASE, EFNYamatoAnimations.YAMATO_RUN), Pair.of((Object)LivingMotions.IDLE, EFNYamatoAnimations.YAMATO_IDLE), Pair.of((Object)LivingMotions.RUN, EFNYamatoAnimations.YAMATO_RUN))));
    }

    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult attackResult;
        if (target == ((DoppelgangerEntity)this.getOriginal()).m_269323_()) {
            return AttackResult.missed((float)0.0f);
        }
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            EpicFightDamageSource modifiedSource = damageSource.addRuntimeTag(this.createUniqueAttackIdentifier(true));
            attackResult = this.getOwnerPatch().attack(modifiedSource, target, hand);
        } else {
            damageSource.addRuntimeTag(this.createUniqueAttackIdentifier(false));
            attackResult = super.attack(damageSource, target, hand);
        }
        this.setDoppelgangerAttackResult(attackResult);
        return attackResult;
    }

    private void setDoppelgangerAttackResult(AttackResult attackResult) {
        try {
            Field resultTypeField = LivingEntityPatch.class.getDeclaredField("lastAttackResultType");
            Field damageField = LivingEntityPatch.class.getDeclaredField("lastDealDamage");
            resultTypeField.setAccessible(true);
            damageField.setAccessible(true);
            resultTypeField.set((Object)this, attackResult.resultType);
            damageField.set((Object)this, Float.valueOf(attackResult.damage));
            EFN.LOGGER.info("DoppelgangerPatch - Set attack result: type={}, damage={}", (Object)attackResult.resultType, (Object)Float.valueOf(attackResult.damage));
        }
        catch (Exception e) {
            EFN.LOGGER.error("Failed to set doppelganger attack result", (Throwable)e);
        }
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            EpicFightDamageSource ownerSource = this.getOwnerPatch().getDamageSource(animation, hand);
            return ownerSource.addRuntimeTag(this.createUniqueAttackIdentifier(true));
        }
        return super.getDamageSource(animation, hand).addRuntimeTag(this.createUniqueAttackIdentifier(false));
    }

    private TagKey<DamageType> createUniqueAttackIdentifier(boolean isOwnerAttack) {
        UUID attackerUUID = isOwnerAttack ? ((Player)this.getOwnerPatch().getOriginal()).m_20148_() : ((DoppelgangerEntity)this.getOriginal()).m_20148_();
        String identifier = String.format("attack_%s_%d_%d", attackerUUID, System.nanoTime(), ThreadLocalRandom.current().nextInt(1000));
        return TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("epicfight", identifier));
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (this.getOwnerPatch() == null) {
            return;
        }
        if (this.getOwnerPatch().getTarget() != null) {
            this.setAttakTargetSync(this.getOwnerPatch().getTarget());
        }
        this.currentLivingMotion = this.getOwnerPatch().currentLivingMotion;
        SkillContainer innate = this.getOwnerPatch().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        if (innate.getDataManager().hasData(EFNDataKey.DOPPELGANGER_DELAY.get()) && innate.getDataManager().getDataValue(EFNDataKey.DOPPELGANGER_DELAY.get()) != null && !((Boolean)innate.getDataManager().getDataValue(EFNDataKey.DOPPELGANGER_DELAY.get())).booleanValue()) {
            if (!this.getOwnerPatch().getEntityState().inaction() && this.state.inaction()) {
                this.animator.stopPlaying(((DynamicAnimation)this.getAnimator().getPlayerFor(null).getAnimation().get()).getRealAnimation());
            } else {
                EFN.queueServerWork(20, () -> {
                    if (!this.getOwnerPatch().getEntityState().inaction() && this.state.inaction()) {
                        this.animator.stopPlaying(((DynamicAnimation)this.getAnimator().getPlayerFor(null).getAnimation().get()).getRealAnimation());
                    }
                });
            }
        }
        ((DoppelgangerEntity)this.getOriginal()).m_20242_(this.getEntityState().inaction() || ((Player)this.getOwnerPatch().getOriginal()).m_7500_());
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    @Nullable
    public PlayerPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((DoppelgangerEntity)this.getOriginal()).m_269323_() != null) {
            this.ownerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)((DoppelgangerEntity)this.getOriginal()).m_269323_(), PlayerPatch.class);
            return this.ownerPatch;
        }
        return null;
    }
}

