/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.doppelganger;

import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class DoppelgangerRender
extends HumanoidMobRenderer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>> {
    private static final ResourceLocation DARK_AURA_TEXTURE = new ResourceLocation("efn:textures/entity/dark.png");
    private static final ResourceLocation RUNES_TEXTURE = new ResourceLocation("efn:textures/entity/dark.png");
    private static final Random RANDOM = new Random(31100L);

    public DoppelgangerRender(EntityRendererProvider.Context pContext) {
        super(pContext, new HumanoidModel(pContext.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(pContext.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(pContext.m_174023_(ModelLayers.f_171165_)), pContext.m_266367_()));
        this.m_115326_(new DarkAuraLayer(this, pContext));
        this.m_115326_(new GlowingRunesLayer(this, pContext));
        this.m_115326_(new ParticleEffectLayer(this));
    }

    protected RenderType getRenderType(DoppelgangerEntity entity, boolean visible, boolean invisibleToPlayer, boolean glowing) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
    }

    public void render(DoppelgangerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.m_6084_()) {
            float swing = (float)entity.f_19797_ + partialTicks;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, (float)Math.sin(swing * 0.1f) * 0.05f, 0.0f);
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        } else {
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull DoppelgangerEntity doppelgangerEntity) {
        return new ResourceLocation("efn:textures/entity/doppelganger.png");
    }

    static class DarkAuraLayer
    extends RenderLayer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>> {
        private final HumanoidModel<DoppelgangerEntity> model;

        public DarkAuraLayer(DoppelgangerRender renderer, EntityRendererProvider.Context context) {
            super((RenderLayerParent)renderer);
            this.model = new HumanoidModel(context.m_174023_(ModelLayers.f_171162_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DoppelgangerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_()) {
                float intensity = (float)Math.sin((float)entity.f_19797_ * 0.1f) * 0.1f + 0.9f;
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110436_((ResourceLocation)DARK_AURA_TEXTURE, (float)(ageInTicks * 0.01f), (float)(ageInTicks * 0.01f)));
                ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
                this.model.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 0.2f, 0.0f, 0.2f, intensity * 0.7f);
            }
        }
    }

    static class GlowingRunesLayer
    extends RenderLayer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>> {
        private final HumanoidModel<DoppelgangerEntity> model;

        public GlowingRunesLayer(DoppelgangerRender renderer, EntityRendererProvider.Context context) {
            super((RenderLayerParent)renderer);
            this.model = new HumanoidModel(context.m_174023_(ModelLayers.f_171162_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DoppelgangerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float pulse = (float)Math.sin((float)entity.f_19797_ * 0.2f) * 0.05f + 0.95f;
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)RUNES_TEXTURE));
            ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
            this.model.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, pulse);
        }
    }

    static class ParticleEffectLayer
    extends RenderLayer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>> {
        public ParticleEffectLayer(DoppelgangerRender renderer) {
            super((RenderLayerParent)renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DoppelgangerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.f_19797_ % 3 == 0) {
                poseStack.m_85836_();
                float offsetX = (RANDOM.nextFloat() - 0.5f) * 1.2f;
                float offsetY = RANDOM.nextFloat() * 1.8f;
                float offsetZ = (RANDOM.nextFloat() - 0.5f) * 1.2f;
                poseStack.m_252880_(offsetX, offsetY, offsetZ);
                poseStack.m_85841_(0.1f, 0.1f, 0.1f);
                poseStack.m_85849_();
            }
        }
    }
}

