/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.EFNEntity;
import com.hm.efn.entity.effect.FireWindPatch;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.util.CullableUtil;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class FireWindEntity
extends VFXEntity {
    private LivingEntity owner;
    private Vec3 offset;
    private boolean shouldRemove = false;

    public FireWindEntity(LivingEntity owner, float scale, Vec3 offset) {
        super((EntityType)EFNEntity.FIREWIND.get(), owner, scale);
        this.owner = owner;
        this.f_19811_ = true;
        this.offset = offset;
        this.f_19794_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public FireWindEntity(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public void markForRemoval() {
        this.shouldRemove = true;
    }

    public void m_8119_() {
        super.m_8119_();
        CullableUtil.setAlwaysVisible((Entity)this);
        if (this.shouldRemove) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && this.owner != null) {
            Vec3 targetPos = this.owner.m_20182_().m_82520_(this.offset.f_82479_, this.offset.f_82480_, this.offset.f_82481_);
            Vec3 currentPos = this.m_20182_();
            Vec3 newPos = currentPos.m_82549_(targetPos.m_82546_(currentPos).m_82490_(1.0));
            this.m_146884_(newPos);
            if (!this.owner.m_6084_()) {
                this.m_146870_();
            }
        }
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82400_(100.0);
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return EFNAnimations.FIREWIND_TWO;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return EFNAnimations.FIREWIND_ONE;
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"efn", (String)"entity/effect/firewind", Armature::new).get();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"efn", (String)"entity/effect/firewind", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/firewind.png");
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/firewind.png");
    }

    @Nullable
    public FireWindPatch getEntityPatch() {
        return this.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).filter(cap -> cap instanceof FireWindPatch).orElse(null);
    }
}

