/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.renderer;

import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedElytraLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedHeadLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedItemInHandLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class DoppelgangerDarkRenderer
extends PatchedLivingEntityRenderer<DoppelgangerEntity, LivingEntityPatch<DoppelgangerEntity>, HumanoidModel<DoppelgangerEntity>, LivingEntityRenderer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>>, HumanoidMesh> {
    private static final ResourceLocation DARK_AURA_TEXTURE = new ResourceLocation("efn:textures/entity/dark.png");
    private static final ResourceLocation RUNES_TEXTURE = new ResourceLocation("efn:textures/entity/dark.png");
    private final AssetAccessor<HumanoidMesh> mesh;

    public DoppelgangerDarkRenderer(AssetAccessor<HumanoidMesh> mesh, EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
        this.mesh = mesh;
        this.addPatchedLayer(ElytraLayer.class, (PatchedLayer)new PatchedElytraLayer());
        this.addPatchedLayer(ItemInHandLayer.class, (PatchedLayer)new PatchedItemInHandLayer());
        this.addPatchedLayer(HumanoidArmorLayer.class, (PatchedLayer)new WearableItemLayer(mesh, false, context.m_266367_()));
        this.addPatchedLayer(CustomHeadLayer.class, (PatchedLayer)new PatchedHeadLayer());
    }

    public void render(DoppelgangerEntity entity, LivingEntityPatch<DoppelgangerEntity> entitypatch, LivingEntityRenderer<DoppelgangerEntity, HumanoidModel<DoppelgangerEntity>> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Armature armature = entitypatch.getArmature();
        if (armature == null) {
            return;
        }
        HumanoidMesh mesh = (HumanoidMesh)this.mesh.get();
        if (mesh == null) {
            return;
        }
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, (LivingEntity)entity, entitypatch, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        ResourceLocation baseTexture = new ResourceLocation("efn:textures/entity/doppelganger.png");
        mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)baseTexture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        float darkIntensity = (float)Math.sin(((float)entity.f_19797_ + partialTicks) * 0.1f) * 0.1f + 0.9f;
        mesh.draw(poseStack, buffer, RenderType.m_110436_((ResourceLocation)DARK_AURA_TEXTURE, (float)(((float)entity.f_19797_ + partialTicks) * 0.01f), (float)(((float)entity.f_19797_ + partialTicks) * 0.01f)), packedLight, 0.2f, 0.0f, 0.2f, darkIntensity * 0.7f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        float runePulse = (float)Math.sin(((float)entity.f_19797_ + partialTicks) * 0.2f) * 0.05f + 0.95f;
        mesh.draw(poseStack, buffer, RenderType.m_110488_((ResourceLocation)RUNES_TEXTURE), 0xF00000, 1.0f, 1.0f, 1.0f, runePulse, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        this.renderLayer(renderer, entitypatch, (LivingEntity)entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    public AssetAccessor<HumanoidMesh> getDefaultMesh() {
        return this.mesh;
    }

    public void setJointTransforms(LivingEntityPatch<DoppelgangerEntity> entitypatch, Armature armature, Pose pose, float partialTicks) {
        if (((DoppelgangerEntity)entitypatch.getOriginal()).m_6162_()) {
            pose.orElseEmpty("Head").frontResult(JointTransform.scale((Vec3f)new Vec3f(1.25f, 1.25f, 1.25f)), OpenMatrix4f::mul);
        }
    }

    protected float getDefaultLayerHeightCorrection() {
        return 0.75f;
    }
}

