/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mixin;

import com.hm.efn.client.pipeline.ParticleEngineHelper;
import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.pipeline.PostParticleRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public abstract class MixinParticleEngine {
    @Unique
    private final PriorityQueue<ParticleEngineHelper.PostParticles> efn$renderQueue = ParticleEngineHelper.createQueue();
    @Shadow
    @Final
    private Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    @Final
    private TextureManager f_107291_;

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;)V"}, at={@At(value="TAIL")}, remap=false)
    private void injectRenderPost(PoseStack posestack_, MultiBufferSource.BufferSource bufferSource, LightTexture lightTexture, Camera camera, float p_107341_, Frustum clippingHelper, CallbackInfo ci) {
        if (!PostEffectPipelines.isActive()) {
            return;
        }
        lightTexture.m_109896_();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252931_(posestack_.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        this.efn$renderQueue.clear();
        for (ParticleRenderType particleRenderType : this.f_107289_.keySet()) {
            if (!(particleRenderType instanceof PostParticleRenderType)) continue;
            PostParticleRenderType pprt = (PostParticleRenderType)particleRenderType;
            this.efn$renderQueue.add(new ParticleEngineHelper.PostParticles(pprt, this.f_107289_.get(pprt)));
        }
        while (!this.efn$renderQueue.isEmpty()) {
            ParticleEngineHelper.PostParticles queueItem = this.efn$renderQueue.poll();
            PostParticleRenderType particlerendertype = queueItem.rt();
            RenderSystem.setShader(GameRenderer::m_172829_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            particlerendertype.m_6505_(bufferbuilder, this.f_107291_);
            for (Particle particle : queueItem.particles()) {
                if (clippingHelper != null && particle.shouldCull() && !clippingHelper.m_113029_(particle.m_107277_())) continue;
                try {
                    particlerendertype.callPipeline();
                    particle.m_5744_((VertexConsumer)bufferbuilder, camera, p_107341_);
                }
                catch (Throwable var18) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)var18, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being rendered");
                    Objects.requireNonNull(particle);
                    crashreportcategory.m_128165_("Particle", () -> ((Particle)particle).toString());
                    Objects.requireNonNull(particlerendertype);
                    crashreportcategory.m_128165_("Particle Type", particlerendertype::toString);
                    throw new ReportedException(crashreport);
                }
            }
            particlerendertype.m_6294_(tesselator);
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.m_109891_();
    }
}

