/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.gameasset.combos.Bloodlust;
import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="efn")
public class BloodlustEnhance {
    private static final UUID ARMOR_NEGATION_UUID = UUID.fromString("b0a7436e-5734-11eb-ae93-0242ac130013");
    private static final UUID IMPACT_UUID = UUID.fromString("b0a745b2-5734-11eb-ae93-0242ac130013");
    private static final UUID STUN_ARMOR_UUID = UUID.fromString("b0a746ac-5734-11eb-ae93-0242ac130013");
    private static final UUID STAMINA_REGEN_UUID = UUID.fromString("1c224694-19f3-11ec-9621-0242ac130103");
    private static final UUID DAMAGE_UUID = UUID.fromString("1c2249f0-19f3-11ec-9621-0242ac130103");
    private static final double MULTIPLIER = 1.2;
    private static final double MULTIPLIER_MINUS_ONE = 0.19999999999999996;

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof BloodlustEffect) {
            LivingEntity entity = event.getEntity();
            if (!BloodlustEffect.hasBloodlustSkill(entity)) {
                entity.m_21195_(event.getEffectInstance().m_19544_());
                return;
            }
            float maxHealth = entity.m_21233_();
            float initialCost = Math.max(maxHealth * 0.08f, 2.0f);
            if (entity.m_21223_() > initialCost) {
                entity.m_6469_(entity.m_269291_().m_269425_(), initialCost);
            } else if (entity.m_21223_() > 1.0f) {
                entity.m_6469_(entity.m_269291_().m_269425_(), entity.m_21223_() - 1.0f);
            }
            ((BloodlustEffect)event.getEffectInstance().m_19544_()).applyModifiers(entity);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof BloodlustEffect) {
            ((BloodlustEffect)event.getEffect()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() instanceof BloodlustEffect) {
            ((BloodlustEffect)event.getEffectInstance().m_19544_()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player && event.getSlot() == EquipmentSlot.MAINHAND && event.getEntity().m_21023_((MobEffect)EFNMobEffectRegistry.BLODDLUST.get())) {
            event.getEntity().m_21195_((MobEffect)EFNMobEffectRegistry.BLODDLUST.get());
        }
    }

    public static class BloodlustEffect
    extends MobEffect {
        public BloodlustEffect() {
            super(MobEffectCategory.NEUTRAL, 0xFF0000);
        }

        public static boolean hasBloodlustSkill(LivingEntity entity) {
            if (!(entity instanceof Player)) {
                return false;
            }
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, PlayerPatch.class);
            return playerPatch != null && playerPatch.getSkill(Bloodlust.Bloodlust) != null;
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (!entity.m_9236_().m_5776_()) {
                if (!BloodlustEffect.hasBloodlustSkill(entity)) {
                    entity.m_21195_((MobEffect)this);
                    return;
                }
                this.applyModifiers(entity);
                if (entity.f_19797_ % 20 == 0) {
                    float maxHealth = entity.m_21233_();
                    float damage = Math.max(maxHealth * 0.02f, 1.0f);
                    if (entity.m_21223_() > damage) {
                        entity.m_6469_(entity.m_269291_().m_269425_(), damage);
                    } else if (entity.m_21223_() > 1.0f) {
                        entity.m_6469_(entity.m_269291_().m_269425_(), entity.m_21223_() - 1.0f);
                    }
                }
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        private void applyModifiers(LivingEntity entity) {
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID, "Bloodlust Armor Negation");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID, "Bloodlust Impact");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID, "Bloodlust Stun Armor");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID, "Bloodlust Stamina Regen");
            this.safeAddModifier(entity, Attributes.f_22281_, DAMAGE_UUID, "Bloodlust Damage");
        }

        private void removeModifiers(LivingEntity entity) {
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22281_, DAMAGE_UUID);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name) {
            if (entity.m_21051_(attribute) != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, 0.19999999999999996, AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
                }
            }
        }

        private void safeRemoveModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
            if (entity.m_21051_(attribute) != null) {
                Objects.requireNonNull(entity.m_21051_(attribute)).m_22120_(uuid);
            }
        }
    }
}

