/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.EFN;
import com.hm.efn.registries.EFNMobEffectRegistry;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

@Mod.EventBusSubscriber(modid="efn")
public class InvincibilityEffect {
    private static volatile boolean isProcessingRemoval = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        if (isProcessingRemoval) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        if (InvincibilityEffect.hasInvincibilityEffect(target)) {
            EFN.LOGGER.debug("InvincibilityEffect: Blocking attack from {} to {}", (Object)source.m_19385_(), (Object)target.m_7755_().getString());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (isProcessingRemoval) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (InvincibilityEffect.hasInvincibilityEffect(target)) {
            EFN.LOGGER.debug("InvincibilityEffect: Nullifying damage to {}", (Object)target.m_7755_().getString());
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        if (isProcessingRemoval) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (InvincibilityEffect.hasInvincibilityEffect(target)) {
            EFN.LOGGER.debug("InvincibilityEffect: Preventing knockback to {}", (Object)target.m_7755_().getString());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPotionEffect(LivingEvent event) {
        DamageSource source;
        LivingDamageEvent damageEvent;
        LivingEntity target;
        if (isProcessingRemoval) {
            return;
        }
        if (event instanceof LivingDamageEvent && InvincibilityEffect.hasInvincibilityEffect(target = (damageEvent = (LivingDamageEvent)event).getEntity()) && ((source = damageEvent.getSource()).m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268565_) || source.m_269533_(DamageTypeTags.f_268490_) || source.m_269533_(DamageTypeTags.f_276146_) || source.m_269533_(DamageTypeTags.f_268630_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268524_) || source.m_269533_(DamageTypeTags.f_268725_) || source.m_269533_(DamageTypeTags.f_268581_) || source.m_269533_(DamageTypeTags.f_268738_))) {
            EFN.LOGGER.debug("InvincibilityEffect: Blocking magical damage to {}", (Object)target.m_7755_().getString());
            damageEvent.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEpicFightDamage(LivingAttackEvent event) {
        LivingEntity target;
        if (isProcessingRemoval) {
            return;
        }
        if (event.getSource() instanceof EpicFightDamageSource && InvincibilityEffect.hasInvincibilityEffect(target = event.getEntity())) {
            EFN.LOGGER.debug("InvincibilityEffect: Blocking EpicFight damage to {}", (Object)target.m_7755_().getString());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof InvincibilityMobEffect) {
            isProcessingRemoval = true;
            try {
                LivingEntity entity = event.getEntity();
                EFN.LOGGER.debug("InvincibilityEffect: Removed from {}", (Object)entity.m_7755_().getString());
            }
            finally {
                isProcessingRemoval = false;
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() instanceof InvincibilityMobEffect) {
            isProcessingRemoval = true;
            try {
                LivingEntity entity = event.getEntity();
                EFN.LOGGER.debug("InvincibilityEffect: Expired for {}", (Object)entity.m_7755_().getString());
            }
            finally {
                isProcessingRemoval = false;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (InvincibilityEffect.hasInvincibilityEffect(entity)) {
            isProcessingRemoval = true;
            try {
                EFN.LOGGER.debug("InvincibilityEffect: Entity died with invincibility effect - {}", (Object)entity.m_7755_().getString());
            }
            finally {
                isProcessingRemoval = false;
            }
        }
    }

    private static boolean hasInvincibilityEffect(LivingEntity entity) {
        if (isProcessingRemoval) {
            return false;
        }
        if (entity == null || !entity.m_6084_()) {
            return false;
        }
        try {
            return entity.m_21023_((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get());
        }
        catch (Exception e) {
            EFN.LOGGER.warn("InvincibilityEffect: Error checking effect status for {}", (Object)entity.m_7755_().getString(), (Object)e);
            return false;
        }
    }

    public static class InvincibilityMobEffect
    extends MobEffect {
        public InvincibilityMobEffect() {
            super(MobEffectCategory.NEUTRAL, 0xFFFFFF);
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }
    }
}

