/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.comboevents.events.TickChange;
import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="efn", value={Dist.CLIENT})
public class TimeSlowEffect
extends MobEffect {
    private static final Map<UUID, Float> timeSlowedEntities = new HashMap<UUID, Float>();
    private static boolean globalTimeSlowActive = false;
    private static float globalTimeSlowStrength = 20.0f;

    public TimeSlowEffect() {
        super(MobEffectCategory.NEUTRAL, 3447003);
    }

    private static float getTickRateFromAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return 15.0f;
            }
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 5.0f;
            }
            case 3: {
                return 3.0f;
            }
            case 4: {
                return 1.0f;
            }
        }
        return 10.0f;
    }

    private static void applyGlobalTimeSlow(float tickRate) {
        globalTimeSlowActive = true;
        globalTimeSlowStrength = tickRate;
        TickChange.requestChange(tickRate);
    }

    private static void restoreGlobalTimeSlow(LivingEntity entity) {
        globalTimeSlowActive = false;
        boolean anyPlayerHasEffect = false;
        for (Player player : entity.m_9236_().m_6907_()) {
            if (!player.m_21023_((MobEffect)EFNMobEffectRegistry.TIME_SLOW.get()) || player == entity) continue;
            anyPlayerHasEffect = true;
            float strongestTickRate = TimeSlowEffect.getTickRateFromAmplifier(player.m_21124_((MobEffect)EFNMobEffectRegistry.TIME_SLOW.get()).m_19564_());
            if (!(strongestTickRate < globalTimeSlowStrength)) break;
            globalTimeSlowStrength = strongestTickRate;
            break;
        }
        if (anyPlayerHasEffect) {
            TickChange.requestChange(globalTimeSlowStrength);
        } else {
            TickChange.requestChange(20.0f);
        }
    }

    private static void updateTimeSlowState() {
        if (timeSlowedEntities.isEmpty()) {
            if (!globalTimeSlowActive) {
                TickChange.requestChange(20.0f);
            }
        } else {
            float weakestTickRate = 20.0f;
            for (float tickRate : timeSlowedEntities.values()) {
                if (!(tickRate < weakestTickRate)) continue;
                weakestTickRate = tickRate;
            }
            if (globalTimeSlowActive && globalTimeSlowStrength < weakestTickRate) {
                weakestTickRate = globalTimeSlowStrength;
            }
            TickChange.requestChange(weakestTickRate);
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof TimeSlowEffect) {
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            int amplifier = event.getEffectInstance().m_19564_();
            float tickRate = TimeSlowEffect.getTickRateFromAmplifier(amplifier);
            if (entity instanceof Player) {
                TimeSlowEffect.applyGlobalTimeSlow(tickRate);
            } else {
                timeSlowedEntities.put(entity.m_20148_(), Float.valueOf(tickRate));
                TimeSlowEffect.updateTimeSlowState();
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof TimeSlowEffect) {
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            if (entity instanceof Player) {
                TimeSlowEffect.restoreGlobalTimeSlow(entity);
            } else {
                timeSlowedEntities.remove(entity.m_20148_());
                TimeSlowEffect.updateTimeSlowState();
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() instanceof TimeSlowEffect) {
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            if (entity instanceof Player) {
                TimeSlowEffect.restoreGlobalTimeSlow(entity);
            } else {
                timeSlowedEntities.remove(entity.m_20148_());
                TimeSlowEffect.updateTimeSlowState();
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            timeSlowedEntities.entrySet().removeIf(entry -> {
                UUID entityId = (UUID)entry.getKey();
                for (ServerLevel level : event.getServer().m_129785_()) {
                    Entity entity = level.m_8791_(entityId);
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    return !livingEntity.m_21023_((MobEffect)EFNMobEffectRegistry.TIME_SLOW.get());
                }
                return true;
            });
            TimeSlowEffect.updateTimeSlowState();
        }
    }

    public static String getTimeSlowDescription(int amplifier) {
        return switch (amplifier) {
            case 0 -> "75% Speed";
            case 1 -> "50% Speed";
            case 2 -> "25% Speed";
            case 3 -> "15% Speed";
            case 4 -> "5% Speed";
            default -> "Time Slow";
        };
    }

    public static void clearAllTimeSlowEffects() {
        timeSlowedEntities.clear();
        globalTimeSlowActive = false;
        TickChange.requestChange(20.0f);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        float tickRate = TimeSlowEffect.getTickRateFromAmplifier(amplifier);
        if (entity instanceof Player) {
            TimeSlowEffect.applyGlobalTimeSlow(tickRate);
        } else {
            timeSlowedEntities.put(entity.m_20148_(), Float.valueOf(tickRate));
            TimeSlowEffect.updateTimeSlowState();
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

