/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.registries;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.utils.PacketBufferCodec;
import yesman.epicfight.skill.SkillDataKey;

public class EFNDataKey {
    public static final Supplier<SkillDataKey<Boolean>> IS_PRESSING = EFNDataKey.registerSupplier("is_pressing", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> IS_CHARGING = EFNDataKey.registerSupplier("is_charging", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> CHARGE_TICKS = EFNDataKey.registerSupplier("charge_ticks", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> CHARGE_STAGE = EFNDataKey.registerSupplier("charge_stage", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Float>> CHARGE_POWER = EFNDataKey.registerSupplier("charge_power", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), false);
    public static final Supplier<SkillDataKey<Integer>> CHARGE_MESSAGE = EFNDataKey.registerSupplier("charge_message", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Boolean>> FULL_CHARGE_MESSAGE = EFNDataKey.registerSupplier("full_charge_message", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> ENERGY_CHECK = EFNDataKey.registerSupplier("energy_check", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> FORCE_RELEASE = EFNDataKey.registerSupplier("force_release", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> DEFENSE_START_TICK = EFNDataKey.registerSupplier("defense_start_tick", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> BUFF_END_TICK = EFNDataKey.registerSupplier("buff_end_tick", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Boolean>> BUFF_ACTIVE = EFNDataKey.registerSupplier("buff_active", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Float>> DAMAGE_MULTIPLIER = EFNDataKey.registerSupplier("damage_multiplier", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> WINDOW_START = EFNDataKey.registerSupplier("window_start", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> WINDOW_END = EFNDataKey.registerSupplier("window_end", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> CURRENT_PUNCTURE_CHANCE = EFNDataKey.registerSupplier("current_puncture_chance", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> CHARGE_BONUS = EFNDataKey.registerSupplier("charge_bonus", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> BASE_PUNCTURE_CHANCE = EFNDataKey.registerSupplier("base_puncture_chance", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> PUNCTURE_INCREMENT = EFNDataKey.registerSupplier("puncture_increment", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> MAX_PUNCTURE_CHANCE = EFNDataKey.registerSupplier("max_puncture_chance", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> PUNCTURE_RESET_THRESHOLD = EFNDataKey.registerSupplier("puncture_reset_threshold", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Float>> COMBO_COUNTER = EFNDataKey.registerSupplier("combo_counter", PacketBufferCodec.FLOAT, Float.valueOf(0.0f), true);
    public static final Supplier<SkillDataKey<Boolean>> ANGEL_KEY = EFNDataKey.registerSupplier("angel_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> DEMON_KEY = EFNDataKey.registerSupplier("demon_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> UP_KEY = EFNDataKey.registerSupplier("up_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> DOWN_KEY = EFNDataKey.registerSupplier("down_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> JUMP_KEY = EFNDataKey.registerSupplier("jump_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> SNEAK_KEY = EFNDataKey.registerSupplier("sneak_key", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> SPECIFIC_ENTITY = EFNDataKey.registerSupplier("specific_entity", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> COOLDOWN = EFNDataKey.registerSupplier("cooldown", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> PARRY_COOLDOWN = EFNDataKey.registerSupplier("parry_cooldown", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> STUN_COOLDOWN = EFNDataKey.registerSupplier("stun_cooldown", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<List<DamageRecord>>> DAMAGE_HISTORY = EFNDataKey.registerSupplier("damage_history", new PacketBufferCodec<List<DamageRecord>>(){

        public List<DamageRecord> decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<DamageRecord> list = new ArrayList<DamageRecord>();
            for (int i = 0; i < size; ++i) {
                list.add(new DamageRecord(buf.readFloat(), buf.readInt()));
            }
            return list;
        }

        public void encode(List<DamageRecord> records, FriendlyByteBuf buf) {
            buf.writeInt(records.size());
            for (DamageRecord record : records) {
                buf.writeFloat(record.damage);
                buf.writeInt(record.timestamp);
            }
        }
    }, new ArrayList(), true);
    public static final Supplier<SkillDataKey<Boolean>> IS_REPLAY_DAMAGE = EFNDataKey.registerSupplier("is_replay_damage", PacketBufferCodec.BOOLEAN, false, false);
    public static final Supplier<SkillDataKey<Boolean>> REPLAY_ENHANCED = EFNDataKey.registerSupplier("replay_enhanced", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_LAST_ACTIVE = EFNDataKey.registerSupplier("efn_last_active", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_STARTING_PARRY = EFNDataKey.registerSupplier("efn_starting_parry", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_LAST_PARRY_TIME = EFNDataKey.registerSupplier("efn_last_parry_time", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_DELAY_PROTECTION_END = EFNDataKey.registerSupplier("efn_delay_protection_end", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_PARRY_MOTION_COUNTER = EFNDataKey.registerSupplier("efn_parry_motion_counter", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_SHAKE_PENALTY_COUNT = EFNDataKey.registerSupplier("efn_shake_penalty_count", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_LAST_GUARD_START_TICK = EFNDataKey.registerSupplier("efn_last_guard_start_tick", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> EFN_LAST_SUCCESSFUL_DEFENSE_TICK = EFNDataKey.registerSupplier("efn_last_successful_defense_tick", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Boolean>> EFN_SHAKE_DETECTED = EFNDataKey.registerSupplier("efn_shake_detected", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> EFN_FIRST_SHAKE = EFNDataKey.registerSupplier("efn_first_shake", PacketBufferCodec.BOOLEAN, true, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY1_PRESS = EFNDataKey.registerSupplier("press_key1", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY2_PRESS = EFNDataKey.registerSupplier("press_key2", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY3_PRESS = EFNDataKey.registerSupplier("press_key3", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY4_PRESS = EFNDataKey.registerSupplier("press_key4", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> INNATE_PRESS = EFNDataKey.registerSupplier("press_innate", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> DOPPELGANGER = EFNDataKey.registerSupplier("press_doppelganger", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> SUMMON_SWORD = EFNDataKey.registerSupplier("press_summon_sword", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY1_LONG_PRESS = EFNDataKey.registerSupplier("pressing_key1", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY2_LONG_PRESS = EFNDataKey.registerSupplier("pressing_key2", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY3_LONG_PRESS = EFNDataKey.registerSupplier("pressing_key3", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> KEY4_LONG_PRESS = EFNDataKey.registerSupplier("pressing_key4", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> INNATE_LONG_PRESS = EFNDataKey.registerSupplier("pressing_innate", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> KEY1_PRESS_TIMER = EFNDataKey.registerSupplier("key1_press_timer", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> KEY2_PRESS_TIMER = EFNDataKey.registerSupplier("key2_press_timer", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> KEY3_PRESS_TIMER = EFNDataKey.registerSupplier("key3_press_timer", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> KEY4_PRESS_TIMER = EFNDataKey.registerSupplier("key4_press_timer", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> INNATE_PRESS_TIMER = EFNDataKey.registerSupplier("innate_press_timer", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Boolean>> HAVE_DOPPELGANGER = EFNDataKey.registerSupplier("have_doppelganger", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Boolean>> DOPPELGANGER_DELAY = EFNDataKey.registerSupplier("doppelganger_delay", PacketBufferCodec.BOOLEAN, false, true);
    public static final Supplier<SkillDataKey<Integer>> DOPPELGANGER_STYLE = EFNDataKey.registerSupplier("doppelganger_style", PacketBufferCodec.INTEGER, 0, true);
    public static final Supplier<SkillDataKey<Integer>> DOPPELGANGER_TICK = EFNDataKey.registerSupplier("doppelganger_tick", PacketBufferCodec.INTEGER, 0, true);

    private static <T> Supplier<SkillDataKey<T>> registerSupplier(String name, PacketBufferCodec<T> codec, T defaultValue, boolean sync) {
        RegistryObject regObj = Holder.DATA_KEYS.register(name, () -> new SkillDataKey(codec, defaultValue, sync));
        return () -> (SkillDataKey)regObj.orElseThrow(() -> new IllegalStateException("SkillDataKey not registered: " + name));
    }

    public static SkillDataKey<Boolean> isPressing() {
        return IS_PRESSING.get();
    }

    public static SkillDataKey<Boolean> isCharging() {
        return IS_CHARGING.get();
    }

    public static SkillDataKey<Boolean> forceRelease() {
        return FORCE_RELEASE.get();
    }

    public static SkillDataKey<Integer> chargeTicks() {
        return CHARGE_TICKS.get();
    }

    public static SkillDataKey<Integer> buffEndTick() {
        return BUFF_END_TICK.get();
    }

    public static SkillDataKey<Boolean> buffActive() {
        return BUFF_ACTIVE.get();
    }

    public static SkillDataKey<Integer> chargeStage() {
        return CHARGE_STAGE.get();
    }

    public static SkillDataKey<Float> chargePower() {
        return CHARGE_POWER.get();
    }

    public static SkillDataKey<Integer> chargeMessage() {
        return CHARGE_MESSAGE.get();
    }

    public static SkillDataKey<Boolean> fullChargeMessage() {
        return FULL_CHARGE_MESSAGE.get();
    }

    public static SkillDataKey<Boolean> energyCheck() {
        return ENERGY_CHECK.get();
    }

    public static SkillDataKey<Boolean> getKeyPress(int keyNum) {
        return switch (keyNum) {
            case 1 -> KEY1_PRESS.get();
            case 2 -> KEY2_PRESS.get();
            case 3 -> KEY3_PRESS.get();
            case 4 -> KEY4_PRESS.get();
            case 5 -> INNATE_PRESS.get();
            default -> throw new IllegalArgumentException("Invalid key number: " + keyNum);
        };
    }

    public static SkillDataKey<Boolean> getKeyLongPress(int keyNum) {
        return switch (keyNum) {
            case 1 -> KEY1_LONG_PRESS.get();
            case 2 -> KEY2_LONG_PRESS.get();
            case 3 -> KEY3_LONG_PRESS.get();
            case 4 -> KEY4_LONG_PRESS.get();
            case 5 -> INNATE_LONG_PRESS.get();
            default -> throw new IllegalArgumentException("Invalid key number: " + keyNum);
        };
    }

    public static SkillDataKey<Integer> getKeyPressTimer(int keyNum) {
        return switch (keyNum) {
            case 1 -> KEY1_PRESS_TIMER.get();
            case 2 -> KEY2_PRESS_TIMER.get();
            case 3 -> KEY3_PRESS_TIMER.get();
            case 4 -> KEY4_PRESS_TIMER.get();
            case 5 -> INNATE_PRESS_TIMER.get();
            default -> throw new IllegalArgumentException("Invalid key number: " + keyNum);
        };
    }

    public static void registerToBus(IEventBus bus) {
        Holder.DATA_KEYS.register(bus);
    }

    private static class Holder {
        static final DeferredRegister<SkillDataKey<?>> DATA_KEYS = DeferredRegister.create((ResourceLocation)new ResourceLocation("epicfight", "skill_data_keys"), (String)"efn");

        private Holder() {
        }
    }

    public record DamageRecord(float damage, int timestamp) {
        public boolean isExpired(int currentTick) {
            return currentTick - this.timestamp > 70;
        }
    }
}

