/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.guard;

import com.google.common.collect.Maps;
import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.gameasset.animations.EFNSkillAnimations;
import com.hm.efn.particle.EFNParticles;
import com.hm.efn.registries.EFNDataKey;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class EFNParryingSkill
extends GuardSkill {
    private int PARRY_WINDOW;
    private int ORIGINAL_PARRYWINDOW;
    private int SHAKE_PARRYWINDOW_PUNISH;
    private int SHAKEPENALTYMINWINDOW;
    private float SHAKEPENALTYMULTIPLIER;
    private int PARRY_DELAY_PROTECTION;
    private int PARRY_DIRECTION_RESET_TIME;
    private int SHAKEDETECTIONTIME;
    private int SHAKEAUTORESETTIME;
    private float HIGH_IMPACT_THRESHOLD;
    private final Map<EntityType<?>, Float> entityHighImpactThresholds = Maps.newHashMap();
    private AttackDirection lastAttackDirection = AttackDirection.FRONT_ATTACK;
    private AttackType lastAttackType = AttackType.NONE;

    public AttackDirection getLastAttackDirection() {
        return this.lastAttackDirection;
    }

    public void setLastAttackDirection(AttackDirection lastAttackDirection) {
        this.lastAttackDirection = lastAttackDirection;
    }

    public AttackType getLastAttackType() {
        return this.lastAttackType;
    }

    public void setLastAttackType(AttackType lastAttackType) {
        this.lastAttackType = lastAttackType;
    }

    public static GuardSkill.Builder createActiveGuardBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> List.of(EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3)).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> List.of(EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3)).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> List.of(EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3)).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> List.of(EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2, EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3));
    }

    public EFNParryingSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    public void startHolding(SkillContainer container) {
        super.startHolding(container);
        if (container.getExecutor().isLogicalClient()) {
            return;
        }
        int currentTick = ((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_;
        container.getDataManager().setDataSync(EFNDataKey.EFN_LAST_ACTIVE.get(), (Object)currentTick);
        container.getDataManager().setDataSync(EFNDataKey.EFN_DELAY_PROTECTION_END.get(), (Object)0);
        SkillDataManager dataManager = container.getDataManager();
        int lastGuardStartTick = (Integer)dataManager.getDataValue(EFNDataKey.EFN_LAST_GUARD_START_TICK.get());
        int lastSuccessfulDefenseTick = (Integer)dataManager.getDataValue(EFNDataKey.EFN_LAST_SUCCESSFUL_DEFENSE_TICK.get());
        if (container.getExecutor().getTarget() != null && lastGuardStartTick > 0) {
            boolean lastDefenseFailed;
            int timeSinceLastGuard = currentTick - lastGuardStartTick;
            boolean isQuickRetry = timeSinceLastGuard < this.SHAKEDETECTIONTIME;
            boolean bl = lastDefenseFailed = lastSuccessfulDefenseTick == 0 || currentTick - lastSuccessfulDefenseTick > this.SHAKEDETECTIONTIME;
            if (isQuickRetry && lastDefenseFailed) {
                this.applyShakePenalty(container);
                dataManager.setDataSync(EFNDataKey.EFN_SHAKE_DETECTED.get(), (Object)true);
            }
        }
        container.getDataManager().setDataSync(EFNDataKey.EFN_LAST_GUARD_START_TICK.get(), (Object)currentTick);
        container.getDataManager().setDataSync(EFNDataKey.EFN_SHAKE_DETECTED.get(), (Object)false);
        this.checkAutoResetShakePenalty(container, currentTick);
    }

    public void resetHolding(SkillContainer container) {
        super.resetHolding(container);
        if (!container.getExecutor().isLogicalClient()) {
            int currentTick = ((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_;
            int delayProtectionEnd = currentTick + this.PARRY_DELAY_PROTECTION;
            container.getDataManager().setDataSync(EFNDataKey.EFN_DELAY_PROTECTION_END.get(), (Object)delayProtectionEnd);
            this.checkShakePenalty(container, currentTick);
        }
    }

    private void checkShakePenalty(SkillContainer container, int currentTick) {
        SkillDataManager dataManager = container.getDataManager();
        if (((Boolean)dataManager.getDataValue(EFNDataKey.EFN_SHAKE_DETECTED.get())).booleanValue()) {
            return;
        }
        if (container.getExecutor().getTarget() == null) {
            return;
        }
    }

    private void applyShakePenalty(SkillContainer container) {
        if (container.getExecutor().getTarget() == null) {
            return;
        }
        SkillDataManager dataManager = container.getDataManager();
        int shakePenaltyCount = (Integer)dataManager.getDataValue(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get()) + 1;
        dataManager.setDataSync(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get(), (Object)shakePenaltyCount);
        boolean isFirstShake = (Boolean)dataManager.getDataValue(EFNDataKey.EFN_FIRST_SHAKE.get());
        if (isFirstShake) {
            dataManager.setDataSync(EFNDataKey.EFN_FIRST_SHAKE.get(), (Object)false);
            return;
        }
        int newParryWindow = (int)Math.floor((double)this.ORIGINAL_PARRYWINDOW * Math.pow(this.SHAKEPENALTYMULTIPLIER, shakePenaltyCount - 1));
        this.PARRY_WINDOW = Math.max(newParryWindow, this.SHAKEPENALTYMINWINDOW);
    }

    private void resetShakePenalty(SkillContainer container) {
        SkillDataManager dataManager = container.getDataManager();
        this.PARRY_WINDOW = this.ORIGINAL_PARRYWINDOW;
        dataManager.setDataSync(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get(), (Object)0);
        dataManager.setDataSync(EFNDataKey.EFN_SHAKE_DETECTED.get(), (Object)false);
        dataManager.setDataSync(EFNDataKey.EFN_FIRST_SHAKE.get(), (Object)true);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        data.registerData(EFNDataKey.EFN_LAST_ACTIVE.get());
        data.registerData(EFNDataKey.EFN_PARRY_MOTION_COUNTER.get());
        data.registerData(EFNDataKey.EFN_DELAY_PROTECTION_END.get());
        data.registerData(EFNDataKey.EFN_STARTING_PARRY.get());
        data.registerData(EFNDataKey.EFN_LAST_PARRY_TIME.get());
        data.registerData(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get());
        data.registerData(EFNDataKey.EFN_LAST_GUARD_START_TICK.get());
        data.registerData(EFNDataKey.EFN_SHAKE_DETECTED.get());
        data.registerData(EFNDataKey.EFN_FIRST_SHAKE.get());
        data.registerData(EFNDataKey.EFN_LAST_SUCCESSFUL_DEFENSE_TICK.get());
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, 1);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            boolean shouldGuard;
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            int currentTick = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_;
            int delayProtectionEnd = (Integer)container.getDataManager().getDataValue(EFNDataKey.EFN_DELAY_PROTECTION_END.get());
            boolean inDelayProtection = currentTick <= delayProtectionEnd;
            boolean bl = shouldGuard = container.isActivated() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingSkill() == this || inDelayProtection;
            if (shouldGuard) {
                DamageSource damageSource = event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    viewVector = viewVector.m_82492_(0.0, viewVector.f_82480_, 0.0).m_82541_();
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    DamageSource patt10915$temp = event.getDamageSource();
                    if (patt10915$temp instanceof EpicFightDamageSource) {
                        EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)patt10915$temp;
                        if (epicfightDamageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE)) {
                            return;
                        }
                        impact = epicfightDamageSource.calculateImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (TakeDamageEvent.Attack)event, knockback, impact, false);
                }
            }
        }, 1);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Attack event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = event.getDamageSource(), true)) {
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation;
            Entity entity;
            boolean canGuardNormally;
            boolean successParrying;
            boolean inDelayProtection;
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            int currentTick = serverPlayer.f_19797_;
            int lastActiveTick = (Integer)container.getDataManager().getDataValue(EFNDataKey.EFN_LAST_ACTIVE.get());
            int delayProtectionEnd = (Integer)container.getDataManager().getDataValue(EFNDataKey.EFN_DELAY_PROTECTION_END.get());
            SkillDataManager dataManager = container.getDataManager();
            int shakePenaltyCount = (Integer)dataManager.getDataValue(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get());
            boolean isShakePeriod = this.PARRY_WINDOW != this.ORIGINAL_PARRYWINDOW;
            int timeSinceLastActive = currentTick - lastActiveTick;
            boolean inParryWindow = isShakePeriod ? timeSinceLastActive >= this.SHAKE_PARRYWINDOW_PUNISH && timeSinceLastActive < this.PARRY_WINDOW + this.SHAKE_PARRYWINDOW_PUNISH : timeSinceLastActive < this.PARRY_WINDOW;
            boolean bl = inDelayProtection = currentTick <= delayProtectionEnd;
            if (isShakePeriod) {
                successParrying = inParryWindow;
                canGuardNormally = false;
            } else {
                successParrying = inParryWindow || inDelayProtection;
                canGuardNormally = true;
            }
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            if (successParrying) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                event.setParried(true);
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EFNSounds.PARRY.get(), -0.05f, 0.1f);
                penalty = 0.1f;
                knockback *= 0.1f;
                container.getDataManager().setData(EFNDataKey.EFN_LAST_ACTIVE.get(), (Object)serverPlayer.f_19797_);
                container.getDataManager().setData(EFNDataKey.EFN_DELAY_PROTECTION_END.get(), (Object)0);
                dataManager.setDataSync(EFNDataKey.EFN_LAST_SUCCESSFUL_DEFENSE_TICK.get(), (Object)currentTick);
                this.resetShakePenalty(container);
                entity = damageSource.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity targetEntity = (LivingEntity)entity;
                    this.analyzeTargetColliderJoints(event.getPlayerPatch(), targetEntity);
                }
            } else if (canGuardNormally) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty += this.getPenalizer(itemCapability)));
                dataManager.setDataSync(EFNDataKey.EFN_LAST_SUCCESSFUL_DEFENSE_TICK.get(), (Object)currentTick);
                this.resetShakePenalty(container);
            } else {
                return;
            }
            entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingentity) * 0.1f;
            }
            if (damageSource.m_7640_() != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            } else {
                ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(serverPlayer.m_20182_(), knockback);
            }
            float consumeAmount = penalty * impact;
            boolean canAfford = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, consumeAmount);
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (canGuardNormally && canAfford ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            float currentHighImpactThreshold = this.HIGH_IMPACT_THRESHOLD;
            Entity entity2 = damageSource.m_7640_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                currentHighImpactThreshold = this.getHighImpactThresholdForEntity(livingEntity);
            }
            if ((animation = this.getGuardMotion(container, event.getPlayerPatch(), itemCapability, blockType, impact, currentHighImpactThreshold)) != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
                if (successParrying && damageSource.m_7640_() != null) {
                    this.spawnParryFlashParticle(serverPlayer, damageSource.m_7640_(), animation);
                }
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
            return;
        }
        super.guard(container, itemCapability, event, knockback, impact, false);
    }

    private void spawnParryFlashParticle(ServerPlayer serverPlayer, Entity target, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        Vector3d particleArgs = this.getParticleArgumentsForAnimation(animation);
        ((HitParticleType)EFNParticles.EFN_PARRY_FLASH_MAIN.get()).spawnParticleWithArgument(serverPlayer.m_284548_(), (player, entity) -> this.getParticlePositionForAnimation((Entity)player, (Entity)entity, animation), (player, entity) -> particleArgs, (Entity)serverPlayer, target);
        ((HitParticleType)EFNParticles.ALL_SPARK.get()).spawnParticleWithArgument(serverPlayer.m_284548_(), (player, entity) -> this.getParticlePositionForAnimation((Entity)player, (Entity)entity, animation), HitParticleType.ZERO, (Entity)serverPlayer, target);
    }

    private Vector3d getParticlePositionForAnimation(Entity player, Entity target, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.6, 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.6, 0.0);
        Vec3 middlePos = playerPos.m_82549_(targetPos.m_82546_(playerPos).m_82490_(0.5));
        Vector3d basePosition = new Vector3d(middlePos.f_82479_, middlePos.f_82480_, middlePos.f_82481_);
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1) {
            Vec3 leftOffset = player.m_20154_().m_82524_((float)Math.toRadians(-90.0)).m_82490_(0.2);
            return new Vector3d(basePosition.x + leftOffset.f_82479_, basePosition.y, basePosition.z + leftOffset.f_82481_);
        }
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2) {
            Vec3 rightOffset = player.m_20154_().m_82524_((float)Math.toRadians(90.0)).m_82490_(0.2);
            return new Vector3d(basePosition.x + rightOffset.f_82479_, basePosition.y, basePosition.z + rightOffset.f_82481_);
        }
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3) {
            return basePosition;
        }
        return basePosition;
    }

    private Vector3d getParticleArgumentsForAnimation(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT1) {
            return new Vector3d(1.0, -0.6, 0.0);
        }
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT2) {
            return new Vector3d(1.0, 0.6, 0.0);
        }
        if (animation.get() == EFNSkillAnimations.EFN_GUARD_ACTIVE_HIT3) {
            return new Vector3d(1.2, 0.7, 0.0);
        }
        return new Vector3d(1.0, 0.0, 0.0);
    }

    private void analyzeTargetColliderJoints(PlayerPatch<?> playerPatch, LivingEntity targetEntity) {
        try {
            DynamicAnimation currentAnimation;
            LivingEntityPatch livingTargetPatch;
            AnimationPlayer animPlayer;
            EntityPatch targetPatch = targetEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).resolve().orElse(null);
            if (targetPatch instanceof LivingEntityPatch && (animPlayer = (livingTargetPatch = (LivingEntityPatch)targetPatch).getAnimator().getPlayerFor(null)) != null && (currentAnimation = (DynamicAnimation)animPlayer.getAnimation().get()) instanceof AttackAnimation) {
                AttackAnimation.JointColliderPair[] colliderPairs;
                AttackAnimation attackAnimation = (AttackAnimation)currentAnimation;
                float elapsedTime = animPlayer.getElapsedTime();
                AttackAnimation.Phase currentPhase = attackAnimation.getPhaseByTime(elapsedTime);
                for (AttackAnimation.JointColliderPair pair : colliderPairs = currentPhase.getColliders()) {
                    Joint colliderJoint = (Joint)pair.getFirst();
                    AttackDirection attackSide = this.determineJointAttackSide(playerPatch, livingTargetPatch, attackAnimation, colliderJoint, elapsedTime, targetEntity);
                    this.setLastAttackDirection(attackSide);
                    Vec3 vec3 = AvalonAnimationUtils.getJointWorldPos((LivingEntityPatch)livingTargetPatch, (Joint)colliderJoint);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AttackDirection determineJointAttackSide(PlayerPatch<?> playerPatch, LivingEntityPatch<?> targetPatch, AttackAnimation attackAnimation, Joint colliderJoint, float elapsedTime, LivingEntity targetEntity) {
        Vec3 playerPos = ((Player)playerPatch.getOriginal()).m_20182_();
        Vec3 playerLookVec = ((Player)playerPatch.getOriginal()).m_20252_(1.0f);
        float totalTime = attackAnimation.getTotalTime();
        float startTime = Math.max(elapsedTime - 0.3f, 0.0f);
        float endTime = Math.min(elapsedTime + 0.2f, totalTime);
        float[] sampleTimes = new float[]{startTime, Math.max(elapsedTime - 0.2f, 0.0f), Math.max(elapsedTime - 0.1f, 0.0f), elapsedTime - 0.05f, elapsedTime, elapsedTime + 0.05f, elapsedTime + 0.1f, endTime};
        Vec3[] samplePositions = new Vec3[sampleTimes.length];
        for (int i = 0; i < sampleTimes.length; ++i) {
            samplePositions[i] = AvalonAnimationUtils.getJointWorldRawPos(targetPatch, (Joint)colliderJoint, (float)sampleTimes[i]);
        }
        Vec3 overallMovement = samplePositions[samplePositions.length - 1].m_82546_(samplePositions[0]);
        if (overallMovement.m_82553_() < 0.01) {
            Vec3 currentPos = samplePositions[4];
            Vec3 toJoint = currentPos.m_82546_(playerPos);
            return this.determineStaticPositionSide(playerLookVec, toJoint);
        }
        AttackType thrustResult = this.determineIfThrustAttackExtended(overallMovement, playerLookVec, samplePositions, sampleTimes, targetEntity);
        if (thrustResult != null) {
            this.setLastAttackType(thrustResult);
            return AttackDirection.FRONT_ATTACK;
        }
        return this.determineSideByCrossProduct(playerLookVec, samplePositions[0], samplePositions[samplePositions.length - 1]);
    }

    private AttackType determineIfThrustAttackExtended(Vec3 movement, Vec3 playerLookVec, Vec3[] samplePositions, float[] sampleTimes, LivingEntity targetEntity) {
        boolean hasReasonableDistance;
        double verticalThreshold;
        Vec3 movementDirection = movement.m_82541_();
        Vec3 playerLookHorizontal = new Vec3(playerLookVec.f_82479_, 0.0, playerLookVec.f_82481_).m_82541_();
        Vec3 movementHorizontal = new Vec3(movementDirection.f_82479_, 0.0, movementDirection.f_82481_).m_82541_();
        double dotProduct = movementHorizontal.m_82526_(playerLookHorizontal);
        double movementLength = movement.m_82553_();
        double stability = this.calculateMovementStability(samplePositions, playerLookHorizontal);
        double forwardDominance = this.calculateForwardDominance(samplePositions, playerLookHorizontal);
        double verticalRatio = this.calculateVerticalRatio(movement, samplePositions);
        boolean isTargetAirborne = this.isTargetAirborne(targetEntity, samplePositions);
        if (verticalRatio > 0.9) {
            return AttackType.VERTICAL_SLAM;
        }
        boolean isThrust = false;
        double d = verticalThreshold = isTargetAirborne ? 0.4 : 0.3;
        if (verticalRatio > verticalThreshold) {
            return null;
        }
        boolean hasGoodDirection = Math.abs(dotProduct) > 0.75;
        boolean hasGoodStability = stability > 0.8;
        boolean hasGoodForwardDominance = forwardDominance > 0.7;
        boolean bl = hasReasonableDistance = movementLength > 0.8;
        if (isTargetAirborne) {
            hasGoodForwardDominance = forwardDominance > 0.6;
            boolean bl2 = hasGoodStability = stability > 0.7;
        }
        if (hasGoodDirection && hasGoodStability && hasGoodForwardDominance && hasReasonableDistance) {
            double thrustScore = Math.abs(dotProduct) * 0.25 + stability * 0.35 + forwardDominance * 0.3;
            double scoreThreshold = isTargetAirborne ? 0.75 : 0.78;
            boolean bl3 = isThrust = thrustScore > scoreThreshold;
            if (stability > 0.95 && forwardDominance > 0.8) {
                isThrust = true;
            }
            if (Math.abs(dotProduct) > 0.99 && stability > 0.8) {
                isThrust = true;
            }
        }
        if (stability < 0.6 || forwardDominance < 0.5) {
            isThrust = false;
        }
        if (isThrust) {
            return dotProduct > 0.0 ? AttackType.THRUST_FRONT : AttackType.THRUST_BACK;
        }
        return null;
    }

    private boolean isTargetAirborne(LivingEntity targetEntity, Vec3[] samplePositions) {
        if (targetEntity == null) {
            return false;
        }
        boolean isOnGround = targetEntity.m_20096_();
        if (!isOnGround) {
            return true;
        }
        return this.analyzeAirborneFromTrajectory(samplePositions);
    }

    private boolean analyzeAirborneFromTrajectory(Vec3[] samplePositions) {
        if (samplePositions.length < 3) {
            return false;
        }
        int peakIndex = this.findPeakIndex(samplePositions);
        if (peakIndex > 0 && peakIndex < samplePositions.length - 1) {
            double riseHeight = samplePositions[peakIndex].f_82480_ - samplePositions[0].f_82480_;
            double fallHeight = samplePositions[peakIndex].f_82480_ - samplePositions[samplePositions.length - 1].f_82480_;
            if (riseHeight > 0.3 && fallHeight > 0.2) {
                return true;
            }
        }
        double minY = samplePositions[0].f_82480_;
        double maxY = samplePositions[0].f_82480_;
        for (Vec3 pos : samplePositions) {
            minY = Math.min(minY, pos.f_82480_);
            maxY = Math.max(maxY, pos.f_82480_);
        }
        double totalHeightChange = maxY - minY;
        return totalHeightChange > 1.0;
    }

    private int findPeakIndex(Vec3[] positions) {
        int peakIndex = 0;
        double maxHeight = positions[0].f_82480_;
        for (int i = 1; i < positions.length; ++i) {
            if (!(positions[i].f_82480_ > maxHeight)) continue;
            maxHeight = positions[i].f_82480_;
            peakIndex = i;
        }
        return peakIndex;
    }

    private double calculateVerticalRatio(Vec3 overallMovement, Vec3[] samplePositions) {
        if (samplePositions.length < 2) {
            return 0.0;
        }
        double maxVerticalMovement = 0.0;
        double totalVerticalVariation = 0.0;
        for (int i = 1; i < samplePositions.length; ++i) {
            double verticalChange = Math.abs(samplePositions[i].f_82480_ - samplePositions[i - 1].f_82480_);
            maxVerticalMovement = Math.max(maxVerticalMovement, verticalChange);
            totalVerticalVariation += verticalChange;
        }
        double totalHeightChange = Math.abs(samplePositions[samplePositions.length - 1].f_82480_ - samplePositions[0].f_82480_);
        double averageVerticalVariation = totalVerticalVariation / (double)(samplePositions.length - 1);
        double verticalScore = maxVerticalMovement * 0.4 + averageVerticalVariation * 0.3 + totalHeightChange * 0.3;
        return Math.min(verticalScore / 2.0, 1.0);
    }

    private double calculateMovementStability(Vec3[] positions, Vec3 referenceDirection) {
        if (positions.length < 3) {
            return 1.0;
        }
        double totalStability = 0.0;
        int validSegments = 0;
        for (int i = 1; i < positions.length; ++i) {
            Vec3 segmentMovement = positions[i].m_82546_(positions[i - 1]);
            if (!(segmentMovement.m_82553_() > 0.01)) continue;
            Vec3 segmentDirection = segmentMovement.m_82541_();
            Vec3 segmentDirectionHorizontal = new Vec3(segmentDirection.f_82479_, 0.0, segmentDirection.f_82481_).m_82541_();
            double consistency = Math.abs(segmentDirectionHorizontal.m_82526_(referenceDirection));
            totalStability += consistency;
            ++validSegments;
        }
        return validSegments > 0 ? totalStability / (double)validSegments : 1.0;
    }

    private double calculateForwardDominance(Vec3[] positions, Vec3 forwardDirection) {
        if (positions.length < 2) {
            return 1.0;
        }
        double totalForward = 0.0;
        double totalLateral = 0.0;
        for (int i = 1; i < positions.length; ++i) {
            Vec3 segment = positions[i].m_82546_(positions[i - 1]);
            if (!(segment.m_82553_() > 0.01)) continue;
            Vec3 segmentHorizontal = new Vec3(segment.f_82479_, 0.0, segment.f_82481_);
            double forwardComponent = segmentHorizontal.m_82526_(forwardDirection);
            totalForward += Math.abs(forwardComponent);
            Vec3 lateralComponent = segmentHorizontal.m_82546_(forwardDirection.m_82490_(forwardComponent));
            totalLateral += lateralComponent.m_82553_();
        }
        double totalMovement = totalForward + totalLateral;
        return totalMovement > 0.0 ? totalForward / totalMovement : 1.0;
    }

    private double calculateMovementLinearity(Vec3[] positions) {
        if (positions.length < 3) {
            return 1.0;
        }
        Vec3 totalDisplacement = positions[positions.length - 1].m_82546_(positions[0]);
        double totalLength = totalDisplacement.m_82553_();
        if (totalLength < 0.01) {
            return 1.0;
        }
        double actualPathLength = 0.0;
        for (int i = 1; i < positions.length; ++i) {
            actualPathLength += positions[i].m_82554_(positions[i - 1]);
        }
        return totalLength / actualPathLength;
    }

    private AttackDirection determineSideByCrossProduct(Vec3 playerLookVec, Vec3 startPos, Vec3 endPos) {
        double adjustedThreshold;
        Vec3 movement = endPos.m_82546_(startPos);
        Vec3 movementDirection = movement.m_82541_();
        Vec3 playerLookHorizontal = new Vec3(playerLookVec.f_82479_, 0.0, playerLookVec.f_82481_).m_82541_();
        Vec3 movementHorizontal = new Vec3(movementDirection.f_82479_, 0.0, movementDirection.f_82481_).m_82541_();
        double crossY = playerLookHorizontal.f_82479_ * movementHorizontal.f_82481_ - playerLookHorizontal.f_82481_ * movementHorizontal.f_82479_;
        double dotProduct = playerLookHorizontal.m_82526_(movementHorizontal);
        double d = adjustedThreshold = Math.abs(dotProduct) > 0.9 ? 0.1 : 0.15;
        AttackDirection attackSide = crossY > adjustedThreshold ? AttackDirection.LEFT_ATTACK : (crossY < -adjustedThreshold ? AttackDirection.RIGHT_ATTACK : (crossY > adjustedThreshold * 0.5 ? AttackDirection.LEFT_SLIGHT_ATTACK : (crossY < -adjustedThreshold * 0.5 ? AttackDirection.RIGHT_SLIGHT_ATTACK : AttackDirection.FRONT_ATTACK)));
        return attackSide;
    }

    private AttackDirection determineStaticPositionSide(Vec3 playerLookVec, Vec3 toJoint) {
        Vec3 playerLookHorizontal = new Vec3(playerLookVec.f_82479_, 0.0, playerLookVec.f_82481_).m_82541_();
        Vec3 toJointHorizontal = new Vec3(toJoint.f_82479_, 0.0, toJoint.f_82481_).m_82541_();
        double crossY = playerLookHorizontal.f_82479_ * toJointHorizontal.f_82481_ - playerLookHorizontal.f_82481_ * toJointHorizontal.f_82479_;
        AttackDirection positionSide = crossY > 0.05 ? AttackDirection.LEFT_SIDE : (crossY < -0.05 ? AttackDirection.RIGHT_SIDE : AttackDirection.FRONT_SIDE);
        return positionSide;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            int lastParryTime;
            int currentTick = ((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_;
            SkillDataManager dataManager = container.getDataManager();
            int delayProtectionEnd = (Integer)dataManager.getDataValue(EFNDataKey.EFN_DELAY_PROTECTION_END.get());
            if (delayProtectionEnd > 0 && currentTick > delayProtectionEnd) {
                dataManager.setData(EFNDataKey.EFN_DELAY_PROTECTION_END.get(), (Object)0);
            }
            if (currentTick - (lastParryTime = ((Integer)dataManager.getDataValue(EFNDataKey.EFN_LAST_PARRY_TIME.get())).intValue()) > this.PARRY_DIRECTION_RESET_TIME) {
                dataManager.setData(EFNDataKey.EFN_STARTING_PARRY.get(), (Object)-1);
                dataManager.setData(EFNDataKey.EFN_PARRY_MOTION_COUNTER.get(), (Object)0);
            }
            this.checkAutoResetShakePenalty(container, currentTick);
        }
    }

    private void checkAutoResetShakePenalty(SkillContainer container, int currentTick) {
        SkillDataManager dataManager = container.getDataManager();
        int shakePenaltyCount = (Integer)dataManager.getDataValue(EFNDataKey.EFN_SHAKE_PENALTY_COUNT.get());
        if (shakePenaltyCount <= 0) {
            return;
        }
        int lastGuardStartTick = (Integer)dataManager.getDataValue(EFNDataKey.EFN_LAST_GUARD_START_TICK.get());
        int timeSinceLastShake = currentTick - lastGuardStartTick;
        if (timeSinceLastShake >= this.SHAKEAUTORESETTIME) {
            this.resetShakePenalty(container);
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.isEpicFightMode() && executor.getEntityState().canUseSkill() && !executor.isHoldingAny();
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || super.isBlockableSource(damageSource, false);
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType, float impact, float highImpactThreshold) {
        List motions;
        AnimationManager.AnimationAccessor animation = itemCapability.getGuardMotion((GuardSkill)this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD && (motions = (List)this.getGuardMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch)) != null) {
            if (impact >= highImpactThreshold && motions.size() >= 3) {
                return (AnimationManager.AnimationAccessor)motions.get(2);
            }
            return this.selectGuardAnimationBasedOnNewLogic(container, motions);
        }
        return super.getGuardMotion(container, playerpatch, itemCapability, blockType);
    }

    private AnimationManager.AnimationAccessor<? extends StaticAnimation> selectGuardAnimationBasedOnNewLogic(SkillContainer container, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> motions) {
        if (motions.size() < 2) {
            return motions.get(0);
        }
        SkillDataManager dataManager = container.getDataManager();
        int currentTick = ((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_;
        dataManager.setData(EFNDataKey.EFN_LAST_PARRY_TIME.get(), (Object)currentTick);
        AnimationManager.AnimationAccessor<? extends StaticAnimation> leftGuard = motions.get(0);
        AnimationManager.AnimationAccessor<? extends StaticAnimation> rightGuard = motions.get(1);
        AttackDirection attackDirection = this.getLastAttackDirection();
        int startingParry = (Integer)dataManager.getDataValue(EFNDataKey.EFN_STARTING_PARRY.get());
        int parryCounter = (Integer)dataManager.getDataValue(EFNDataKey.EFN_PARRY_MOTION_COUNTER.get());
        if (startingParry == -1 || parryCounter == 0) {
            boolean useLeftGuard = this.shouldUseLeftGuardForAttack(attackDirection);
            startingParry = useLeftGuard ? 0 : 1;
            dataManager.setData(EFNDataKey.EFN_STARTING_PARRY.get(), (Object)startingParry);
            dataManager.setData(EFNDataKey.EFN_PARRY_MOTION_COUNTER.get(), (Object)1);
            return startingParry == 0 ? leftGuard : rightGuard;
        }
        boolean useLeftGuard = startingParry == 0 ? parryCounter % 2 == 0 : parryCounter % 2 != 0;
        dataManager.setDataF(EFNDataKey.EFN_PARRY_MOTION_COUNTER.get(), v -> v + 1);
        return useLeftGuard ? leftGuard : rightGuard;
    }

    private boolean shouldUseLeftGuardForAttack(AttackDirection attackDirection) {
        return switch (attackDirection) {
            case AttackDirection.LEFT_ATTACK, AttackDirection.LEFT_SLIGHT_ATTACK, AttackDirection.LEFT_SIDE -> true;
            case AttackDirection.RIGHT_ATTACK, AttackDirection.RIGHT_SLIGHT_ATTACK, AttackDirection.RIGHT_SIDE -> false;
            default -> Math.random() < 0.5;
        };
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType, float impact) {
        return this.getGuardMotion(container, playerpatch, itemCapability, blockType, impact, this.HIGH_IMPACT_THRESHOLD);
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        return this.getGuardMotion(container, playerpatch, itemCapability, blockType, 0.0f, this.HIGH_IMPACT_THRESHOLD);
    }

    private float getHighImpactThresholdForEntity(LivingEntity entity) {
        if (entity == null) {
            return this.HIGH_IMPACT_THRESHOLD;
        }
        return this.entityHighImpactThresholds.getOrDefault(entity.m_6095_(), Float.valueOf(this.HIGH_IMPACT_THRESHOLD)).floatValue();
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.entityHighImpactThresholds.clear();
        this.PARRY_WINDOW = parameters.m_128451_("parry_window");
        if (this.PARRY_WINDOW <= 0) {
            this.PARRY_WINDOW = 6;
        }
        this.SHAKE_PARRYWINDOW_PUNISH = parameters.m_128451_("shake_parrywindow_punish");
        if (this.PARRY_WINDOW <= 0) {
            this.PARRY_WINDOW = 2;
        }
        this.ORIGINAL_PARRYWINDOW = this.PARRY_WINDOW;
        this.HIGH_IMPACT_THRESHOLD = parameters.m_128457_("high_impact_threshold");
        if (this.HIGH_IMPACT_THRESHOLD <= 0.0f) {
            this.HIGH_IMPACT_THRESHOLD = 4.0f;
        }
        this.PARRY_DELAY_PROTECTION = parameters.m_128451_("parry_delay_protection");
        if (this.PARRY_DELAY_PROTECTION <= 0) {
            this.PARRY_DELAY_PROTECTION = 2;
        }
        this.PARRY_DIRECTION_RESET_TIME = parameters.m_128451_("parry_direction_reset_time");
        if (this.PARRY_DIRECTION_RESET_TIME <= 0) {
            this.PARRY_DIRECTION_RESET_TIME = 40;
        }
        this.SHAKEPENALTYMINWINDOW = parameters.m_128451_("shake_penalty_min_window");
        if (this.SHAKEPENALTYMINWINDOW <= 0) {
            this.SHAKEPENALTYMINWINDOW = 2;
        }
        this.SHAKEPENALTYMULTIPLIER = parameters.m_128457_("shake_penalty_multiplier");
        if (this.SHAKEPENALTYMULTIPLIER <= 0.0f) {
            this.SHAKEPENALTYMULTIPLIER = 0.5f;
        }
        this.SHAKEDETECTIONTIME = parameters.m_128451_("shake_detection_time");
        this.SHAKEAUTORESETTIME = parameters.m_128451_("shake_auto_reset_time");
        CompoundTag entityThresholds = parameters.m_128469_("entity_high_impact_thresholds");
        for (String registryName : entityThresholds.m_128431_()) {
            EntityType entityType = EntityType.m_20632_((String)registryName).orElse(null);
            if (entityType == null) continue;
            float threshold = entityThresholds.m_128457_(registryName);
            this.entityHighImpactThresholds.put(entityType, Float.valueOf(threshold));
        }
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    public Set<WeaponCategory> getAvailableWeaponCategories() {
        return this.advancedGuardMotions.keySet();
    }

    public static enum AttackDirection {
        LEFT_ATTACK("left_attack"),
        RIGHT_ATTACK("right_attack"),
        LEFT_SLIGHT_ATTACK("left_slight_attack"),
        RIGHT_SLIGHT_ATTACK("right_slight_attack"),
        FRONT_ATTACK("front_attack"),
        LEFT_SIDE("left_side"),
        RIGHT_SIDE("right_side"),
        FRONT_SIDE("front_side");

        private final String displayName;

        private AttackDirection(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum AttackType {
        THRUST_FRONT("thrust_front"),
        THRUST_BACK("thrust_back"),
        VERTICAL_SLAM("vertical_slam"),
        NONE("none");

        private final String displayName;

        private AttackType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

