/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.passive;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class IndestructiblePassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("4074c6de-0268-11ee-be56-0242ac120721");
    private static final UUID IMMUNITY_UUID = UUID.fromString("4074c6de-0721-11ee-be56-0242ac120003");
    private static final UUID STAMINA_UUID = UUID.fromString("0721c6de-4074-11ee-be56-0242ac120004");
    private static final UUID STAMINA_LOCK_UUID = UUID.fromString("0721c6de-4074-11ee-be56-0242ac120005");
    private static final AttributeModifier INFINITE_STAMINA = new AttributeModifier(STAMINA_LOCK_UUID, "indestructible.stamina_lock", 1.14514191981E12, AttributeModifier.Operation.ADDITION);

    public IndestructiblePassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, event -> {
            if (event.getSkillContainer().getSkill().getCategory() == SkillCategories.DODGE && !event.isStateExecutable()) {
                EntityState state = container.getExecutor().getEntityState();
                DynamicAnimation animation = (DynamicAnimation)Objects.requireNonNull(container.getExecutor().getAnimator().getPlayerFor(null)).getRealAnimation().get();
                if (!state.hurt() && !state.knockDown() && animation instanceof AttackAnimation) {
                    event.setStateExecutable(true);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, IMMUNITY_UUID, event -> {
            DamageSource patt2848$temp = event.getDamageSource();
            if (patt2848$temp instanceof EpicFightDamageSource) {
                EpicFightDamageSource epicSource = (EpicFightDamageSource)patt2848$temp;
                epicSource.setStunType(StunType.NONE);
            }
        }, -1);
        listener.addEventListener(PlayerEventListener.EventType.STAMINA_CONSUME_EVENT, STAMINA_UUID, event -> {
            event.setAmount(0.0f);
            event.setCanceled(true);
        });
        AttributeInstance staminaAttribute = ((Player)container.getExecutor().getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
        if (staminaAttribute != null && !staminaAttribute.m_22109_(INFINITE_STAMINA)) {
            staminaAttribute.m_22118_(INFINITE_STAMINA);
        }
        container.getExecutor().setStamina(container.getExecutor().getMaxStamina());
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.STAMINA_CONSUME_EVENT, STAMINA_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, IMMUNITY_UUID, -1);
        Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get())).m_22130_(INFINITE_STAMINA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        return list;
    }
}

