/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.registries.EFNDataKey;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class PioneerInnate
extends ComboBasicAttack {
    public PioneerInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        this.registerKeyData(data);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
    }

    private void registerKeyData(SkillDataManager data) {
        data.registerData(EFNDataKey.KEY1_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY2_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY3_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY4_LONG_PRESS.get());
        data.registerData(EFNDataKey.INNATE_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS.get());
        data.registerData(EFNDataKey.KEY2_PRESS.get());
        data.registerData(EFNDataKey.KEY3_PRESS.get());
        data.registerData(EFNDataKey.KEY4_PRESS.get());
        data.registerData(EFNDataKey.INNATE_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY2_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY3_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY4_PRESS_TIMER.get());
        data.registerData(EFNDataKey.INNATE_PRESS_TIMER.get());
        data.registerData(EFNDataKey.COMBO_COUNTER.get());
        data.registerData(EFNDataKey.ANGEL_KEY.get());
        data.registerData(EFNDataKey.DEMON_KEY.get());
        data.registerData(EFNDataKey.JUMP_KEY.get());
        data.registerData(EFNDataKey.SNEAK_KEY.get());
        data.registerData(EFNDataKey.UP_KEY.get());
        data.registerData(EFNDataKey.DOWN_KEY.get());
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            SkillDataManager manager = container.getDataManager();
            if (manager.hasData(EFNDataKey.COMBO_COUNTER.get())) {
                float current = ((Float)manager.getDataValue(EFNDataKey.COMBO_COUNTER.get())).floatValue();
                if (current < 1.0f) {
                    float newValue = current + 0.05f;
                    manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(newValue), (ServerPlayer)serverPlayerPatch.getOriginal());
                } else {
                    manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
                }
            }
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.pioneer.tooltip").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.pioneer.tooltip1").m_130940_(ChatFormatting.GRAY).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.pioneer.tooltip2"));
        return list;
    }
}

