/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.particle.EFNParticles;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.merlin204.avalon.util.AvalonEventUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;

public class ParticleEffectInvoker {
    public static AnimationEvent.InTimeEvent spawnExpParticle(int startFrame, double forwardOffset, double rightOffset, double upOffset) {
        return ParticleEffectInvoker.spawnCustomParticle(startFrame, forwardOffset, rightOffset, upOffset, (ParticleOptions)EFNParticles.EXP.get());
    }

    public static AnimationEvent.InTimeEvent spawnFlashParticle(int startFrame, double forwardOffset, double rightOffset, double upOffset) {
        return ParticleEffectInvoker.spawnCustomParticle(startFrame, forwardOffset, rightOffset, upOffset, (ParticleOptions)EFNParticles.FLASH.get());
    }

    public static AnimationEvent.InTimeEvent spawnSlashParticle(int startFrame, double forwardOffset, double rightOffset, double upOffset) {
        return ParticleEffectInvoker.spawnCustomParticle(startFrame, forwardOffset, rightOffset, upOffset, (ParticleOptions)EFNParticles.SLASH.get());
    }

    public static AnimationEvent.InTimeEvent spawnSlashParticleSmart(int startFrame) {
        return ParticleEffectInvoker.smartCustomParticle(startFrame, (ParticleOptions)EFNParticles.SLASH.get(), 1.5);
    }

    public static AnimationEvent.InTimeEvent spawnJudgementCutMiniSmart(int startFrame) {
        return ParticleEffectInvoker.smartCustomParticle(startFrame, (ParticleOptions)EFNParticles.JUDGEMENT_CUT_PARTICLE_MINI.get(), 0.0);
    }

    public static AnimationEvent.InTimeEvent spawnParticleAtJoint(int startFrame, Joint joint, ParticleOptions particleType, int count, double speed, Vec3 offset) {
        float time = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entityPatch, self, params) -> {
            if (entityPatch == null) {
                return;
            }
            Vec3f offsetVec3f = new Vec3f((float)offset.f_82479_, (float)offset.f_82480_, (float)offset.f_82481_);
            Vec3 worldPos = AvalonAnimationUtils.getJointWorldRawPos((LivingEntityPatch)entityPatch, (Joint)joint, (float)0.0f, (Vec3f)offsetVec3f);
            Level patt3591$temp = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            if (patt3591$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt3591$temp;
                serverLevel.m_8767_(particleType, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, count, 0.0, 0.0, 0.0, speed);
            } else if (((LivingEntity)entityPatch.getOriginal()).m_9236_().m_5776_()) {
                for (int i = 0; i < count; ++i) {
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleType, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent spawnParticleAtJoint(int startFrame, Joint joint, ParticleOptions particleType, int count) {
        return ParticleEffectInvoker.spawnParticleAtJoint(startFrame, joint, particleType, count, 0.0, Vec3.f_82478_);
    }

    public static AnimationEvent.InTimeEvent spawnParticleAtJoint(int startFrame, Joint joint, ParticleOptions particleType, int count, Vec3 offset) {
        return ParticleEffectInvoker.spawnParticleAtJoint(startFrame, joint, particleType, count, 0.0, offset);
    }

    public static AnimationEvent.InTimeEvent spawnParticleAtJoint(int startFrame, Joint joint, ParticleOptions particleType, int count, double speed) {
        return ParticleEffectInvoker.spawnParticleAtJoint(startFrame, joint, particleType, count, speed, Vec3.f_82478_);
    }

    public static AnimationEvent.InTimeEvent spawnCustomParticle(int startFrame, double forwardOffset, double rightOffset, double upOffset, ParticleOptions particleType) {
        float time = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entityPatch, self, params) -> {
            LivingEntityPatch patch = entityPatch;
            Entity patt5735$temp = patch.getOriginal();
            if (!(patt5735$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)patt5735$temp;
            Level patt5810$temp = living.m_9236_();
            if (!(patt5810$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt5810$temp;
            Vec3 spawnPos = ParticleEffectInvoker.calculateParticlePosition(living, forwardOffset, rightOffset, upOffset);
            level.m_8767_(particleType, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent smartCustomParticle(int startFrame, ParticleOptions particleType, double targetHeightAdjust) {
        float time = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt7132$temp = owner.m_9236_();
            if (!(patt7132$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt7132$temp;
            Vec3 spawnPos = ParticleEffectInvoker.calculateSmartParticlePosition(owner, targetHeightAdjust);
            level.m_8767_(particleType, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static Vec3 calculateSmartParticlePosition(LivingEntity owner, double targetHeightAdjust) {
        LivingEntity target = ((LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)owner, LivingEntityPatch.class)).getTarget();
        if (target != null && ParticleEffectInvoker.isTargetInRange(owner, (Entity)target, 5.5)) {
            return target.m_20182_().m_82520_(0.0, targetHeightAdjust, 0.0);
        }
        return ParticleEffectInvoker.calculateParticlePosition(owner, 4.0, 0.0, 0.0);
    }

    private static boolean isTargetInRange(LivingEntity owner, Entity target, double range) {
        double distanceSq = owner.m_20280_(target);
        return distanceSq <= range * range;
    }

    public static AnimationEvent.InTimeEvent spawnAdvancedParticle(int startFrame, double forwardOffset, double rightOffset, double upOffset, ParticleOptions particleType, int count, double randomSpread, double speed) {
        float time = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entityPatch, self, params) -> {
            LivingEntityPatch patch = entityPatch;
            Entity patt8879$temp = patch.getOriginal();
            if (!(patt8879$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)patt8879$temp;
            Level patt8954$temp = living.m_9236_();
            if (!(patt8954$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt8954$temp;
            Vec3 spawnPos = ParticleEffectInvoker.calculateParticlePosition(living, forwardOffset, rightOffset, upOffset);
            level.m_8767_(particleType, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, count, randomSpread, randomSpread, randomSpread, speed);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static Vec3 calculateParticlePosition(LivingEntity entity, double forward, double right, double up) {
        Vec3 horizontalLook = new Vec3(Math.sin((double)(-entity.m_146908_()) * (Math.PI / 180)), 0.0, Math.cos((double)entity.m_146908_() * (Math.PI / 180))).m_82541_();
        Vec3 rightVec = new Vec3(-horizontalLook.f_82481_, 0.0, horizontalLook.f_82479_).m_82541_();
        return entity.m_146892_().m_82549_(horizontalLook.m_82490_(forward)).m_82549_(rightVec.m_82490_(right)).m_82520_(0.0, up, 0.0);
    }

    public static void spawnFireballParticles(ServerLevel level, Vec3 position) {
        ParticleEffectInvoker.spawnFireballCore(level, position);
        ParticleEffectInvoker.spawnFireballInnerRing(level, position);
        ParticleEffectInvoker.spawnFireballOuterRing(level, position);
        ParticleEffectInvoker.spawnFireballVerticalEmission(level, position);
    }

    private static void spawnFireballCore(ServerLevel level, Vec3 position) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_, position.f_82480_ + 0.3, position.f_82481_, 20, 0.3, 0.2, 0.3, 0.08);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, position.f_82479_, position.f_82480_ + 0.4, position.f_82481_, 8, 0.1, 0.1, 0.1, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, position.f_82479_, position.f_82480_ + 0.2, position.f_82481_, 5, 0.15, 0.1, 0.15, 0.0);
    }

    private static void spawnFireballInnerRing(ServerLevel level, Vec3 center) {
        int particles = 24;
        float radius = 0.6f;
        for (int i = 0; i < particles; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)particles);
            float x = radius * Mth.m_14089_((float)angle);
            float z = radius * Mth.m_14031_((float)angle);
            Vec3 pos = center.m_82520_((double)x, 0.2, (double)z);
            Vec3 motion = new Vec3((double)(-z) * 0.15, 0.1, (double)x * 0.15);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, motion.f_82479_, motion.f_82480_, motion.f_82481_, 0.0);
        }
    }

    private static void spawnFireballOuterRing(ServerLevel level, Vec3 center) {
        int particles = 18;
        float radius = 1.2f;
        for (int i = 0; i < particles; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)particles);
            float x = radius * Mth.m_14089_((float)angle);
            float z = radius * Mth.m_14031_((float)angle);
            Vec3 pos = center.m_82520_((double)x, 0.1, (double)z);
            Vec3 motion = new Vec3((double)x * 0.08, 0.08, (double)z * 0.08);
            SimpleParticleType particleType = i % 3 == 0 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_;
            level.m_8767_((ParticleOptions)particleType, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, motion.f_82479_, motion.f_82480_, motion.f_82481_, 0.0);
        }
    }

    private static void spawnFireballVerticalEmission(ServerLevel level, Vec3 center) {
        int i;
        for (i = 0; i < 12; ++i) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_ + (Math.random() - 0.5) * 0.4, center.f_82480_ + 0.1, center.f_82481_ + (Math.random() - 0.5) * 0.4, 1, (Math.random() - 0.5) * 0.1, Math.random() * 0.3 + 0.2, (Math.random() - 0.5) * 0.1, 0.05);
        }
        for (i = 0; i < 8; ++i) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, center.f_82479_ + (Math.random() - 0.5) * 0.6, center.f_82480_ + 0.05, center.f_82481_ + (Math.random() - 0.5) * 0.6, 1, (Math.random() - 0.5) * 0.15, Math.random() * 0.25 + 0.15, (Math.random() - 0.5) * 0.15, 0.03);
        }
    }

    public static void spawnEnhancedFireballParticles(ServerLevel level, Vec3 position) {
        ParticleEffectInvoker.spawnConcentricFireRing(level, position, 1.5f, 12, 0.12f, (ParticleOptions)ParticleTypes.f_123744_);
        ParticleEffectInvoker.spawnConcentricFireRing(level, position, 2.0f, 15, 0.08f, (ParticleOptions)ParticleTypes.f_123810_);
        ParticleEffectInvoker.spawnConcentricFireRing(level, position, 2.5f, 20, 0.05f, (ParticleOptions)ParticleTypes.f_123756_);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, position.f_82479_, position.f_82480_ + 0.3, position.f_82481_, 8, 0.25, 0.2, 0.25, 0.02);
        for (int i = 0; i < 6; ++i) {
            double angle = Math.PI * 2 * (double)i / 6.0;
            double distance = 0.8;
            double x = position.f_82479_ + distance * Math.cos(angle);
            double z = position.f_82481_ + distance * Math.sin(angle);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, position.f_82480_, z, 3, 0.1, 0.4, 0.1, 0.07);
        }
    }

    private static void spawnConcentricFireRing(ServerLevel level, Vec3 center, float radius, int particles, float speed, ParticleOptions particleType) {
        for (int i = 0; i < particles; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)particles);
            float x = radius * Mth.m_14089_((float)angle);
            float z = radius * Mth.m_14031_((float)angle);
            Vec3 pos = center.m_82520_((double)x, 0.15, (double)z);
            Vec3 motion = new Vec3((double)(-z * speed), 0.06, (double)(x * speed));
            level.m_8767_(particleType, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, motion.f_82479_, motion.f_82480_, motion.f_82481_, 0.0);
        }
    }

    public static void spawnFireballTrail(ServerLevel level, Vec3 startPos, Vec3 endPos) {
        Vec3 direction = endPos.m_82546_(startPos).m_82541_();
        double distance = startPos.m_82554_(endPos);
        int particles = (int)(distance * 5.0);
        for (int i = 0; i < particles; ++i) {
            double progress = (double)i / (double)particles;
            Vec3 particlePos = startPos.m_82549_(direction.m_82490_(distance * progress));
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.1, 0.1, 0.1, 0.02);
        }
    }

    public static AnimationEvent.InTimeEvent createMagmaEruption(float startFrame) {
        float time = startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entitypatch, self, params) -> {
            if (((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                int i;
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ClientLevel level = (ClientLevel)entity.m_9236_();
                Vec3 center = entity.m_20182_().m_82520_(0.0, 0.1, 0.0);
                for (i = 0; i < 12; ++i) {
                    double spread = 0.7;
                    Vec3 spawnPos = new Vec3(center.f_82479_ + (Math.random() - 0.5) * spread, center.f_82480_ + (Math.random() - 0.5) * spread * 0.5, center.f_82481_ + (Math.random() - 0.5) * spread);
                    Vec3 velocity = new Vec3((Math.random() - 0.5) * 0.25, Math.random() * 0.4 + 0.3, (Math.random() - 0.5) * 0.25);
                    SimpleParticleType type = Math.random() < 0.8 ? ParticleTypes.f_123756_ : ParticleTypes.f_123744_;
                    level.m_7106_((ParticleOptions)type, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                }
                for (int spiral = 0; spiral < 8; ++spiral) {
                    float baseAngle = (float)((double)spiral * Math.PI * 0.25);
                    for (int layer = 0; layer < 5; ++layer) {
                        float progress = (float)layer / 4.0f;
                        double angle = (double)baseAngle + (double)progress * Math.PI * 2.0;
                        float radius = 0.3f + progress * 0.7f;
                        float yPos = (float)(center.f_82480_ + (double)(progress * 2.5f));
                        Vec3 pos = new Vec3(center.f_82479_ + (double)radius * Math.cos(angle), (double)yPos, center.f_82481_ + (double)radius * Math.sin(angle));
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, Math.cos(angle) * (double)0.1f, (double)0.2f, Math.sin(angle) * (double)0.1f);
                    }
                }
                for (i = 0; i < 24; ++i) {
                    double angle = Math.random() * 2.0 * Math.PI;
                    double radius = Math.random() * 1.8;
                    Vec3 pos = new Vec3(center.f_82479_ + radius * Math.cos(angle), center.f_82480_, center.f_82481_ + radius * Math.sin(angle));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, Math.cos(angle) * 0.05, 0.02, Math.sin(angle) * 0.05);
                    if (i % 3 != 0) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, pos.f_82479_, pos.f_82480_ + 0.1, pos.f_82481_, Math.cos(angle) * 0.1, 0.15, Math.sin(angle) * 0.1);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent createShockwave(float startFrame) {
        float time = startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entitypatch, self, params) -> {
            if (!((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                LivingEntity attacker = (LivingEntity)entitypatch.getOriginal();
                ServerLevel level = (ServerLevel)attacker.m_9236_();
                Vec3 center = new Vec3(attacker.m_20185_(), attacker.m_20186_() + 0.2, attacker.m_20189_());
                for (int wave = 0; wave < 3; ++wave) {
                    double progress = (double)wave / 2.0;
                    double radius = Mth.m_14139_((double)progress, (double)4.5, (double)9.0);
                    for (int i = 0; i < 80; ++i) {
                        double angle = Math.PI * 2 * (double)i / 80.0;
                        Vec3 pos = new Vec3(radius * Math.cos(angle + progress * 1.3 * Math.PI), Math.sin(angle * 2.2 + (double)wave * 0.6) * 0.9, radius * Math.sin(angle + progress * 1.3 * Math.PI)).m_82549_(center);
                        Vec3 motion = pos.m_82546_(center).m_82541_().m_82490_(0.4 * (0.6 + 0.4 * (1.0 - progress))).m_82520_(0.0, 0.18, 0.0);
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, motion.f_82479_ * 0.35, motion.f_82480_ * 0.7, motion.f_82481_ * 0.35, 0.9);
                    }
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, 25, 1.6, 0.7, 1.6, 0.8);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent createBeastRoarEffect(float startFrame) {
        float time = startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entitypatch, self, params) -> {
            if (((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                int i;
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ClientLevel level = (ClientLevel)entity.m_9236_();
                Vec3 origin = entity.m_20299_(1.0f).m_82549_(entity.m_20154_().m_82490_(0.5));
                for (int ring = 0; ring < 3; ++ring) {
                    float radius = 1.5f + (float)ring * 1.8f;
                    int particles = 18 + ring * 6;
                    for (int i2 = 0; i2 < particles; ++i2) {
                        float angle = (float)(Math.PI * 2 * (double)i2 / (double)particles);
                        Vec3 offset = new Vec3((double)(radius * Mth.m_14089_((float)angle)), 0.2 * (double)(ring - 1), (double)(radius * Mth.m_14031_((float)angle)));
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, origin.f_82479_ + offset.f_82479_, origin.f_82480_ + offset.f_82480_, origin.f_82481_ + offset.f_82481_, offset.f_82479_ * (double)0.15f, ring == 1 ? (double)0.05f : (double)-0.02f, offset.f_82481_ * (double)0.15f);
                    }
                }
                for (i = 0; i < 25; ++i) {
                    Vec3 randomOffset = new Vec3((Math.random() - 0.5) * 3.0, (Math.random() - 0.3) * 1.5, (Math.random() - 0.5) * 3.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, origin.f_82479_ + randomOffset.f_82479_, origin.f_82480_ + randomOffset.f_82480_, origin.f_82481_ + randomOffset.f_82481_, randomOffset.f_82479_ * (double)0.08f, randomOffset.f_82480_ * (double)0.05f + (double)0.1f, randomOffset.f_82481_ * (double)0.08f);
                }
                if (entity.m_20096_()) {
                    for (i = 0; i < 12; ++i) {
                        double angle = Math.random() * 2.0 * Math.PI;
                        double distance = 1.5 + Math.random() * 3.0;
                        Vec3 groundPos = new Vec3(origin.f_82479_ + distance * Math.cos(angle), origin.f_82480_ - 1.2, origin.f_82481_ + distance * Math.sin(angle));
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, groundPos.f_82479_, groundPos.f_82480_ + 0.05, groundPos.f_82481_, (Math.random() - 0.5) * 0.1, 0.15 + Math.random() * 0.2, (Math.random() - 0.5) * 0.1);
                    }
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent createRoarShockwave(float startFrame) {
        float time = startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entitypatch, self, params) -> {
            if (!((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ServerLevel level = (ServerLevel)entity.m_9236_();
                Vec3 direction = entity.m_20154_();
                Vec3 origin = entity.m_20299_(1.0f);
                for (LivingEntity target : level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(8.0), e -> e != entity)) {
                    Vec3 toTarget = target.m_20182_().m_82546_(origin).m_82541_();
                    if (!(direction.m_82526_(toTarget) > 0.7)) continue;
                    target.m_147240_((double)0.8f, direction.f_82479_ * -1.0, direction.f_82481_ * -1.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent createLavaRingEffect(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entitypatch, self, params) -> {
            if (((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ClientLevel level = (ClientLevel)entity.m_9236_();
                Vec3 center = entity.m_20182_().m_82520_(0.0, 0.1, 0.0);
                for (int i = 0; i < 36; ++i) {
                    float angle = (float)(Math.PI * 2 * (double)i / 36.0);
                    float radius = 3.5f;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_ + (double)(radius * Mth.m_14089_((float)angle)), center.f_82480_, center.f_82481_ + (double)(radius * Mth.m_14031_((float)angle)), 0.0, (double)0.05f, 0.0);
                    if (i % 3 != 0) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_ + (double)(radius * Mth.m_14089_((float)angle)), center.f_82480_ + (double)0.1f, center.f_82481_ + (double)(radius * Mth.m_14031_((float)angle)), 0.0, (double)0.1f, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent createSmokeRingEffect(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entitypatch, self, params) -> {
            if (((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                int i;
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ClientLevel level = (ClientLevel)entity.m_9236_();
                Vec3 center = entity.m_20182_().m_82520_(0.0, 0.1, 0.0);
                int particleCount = 72;
                float radius = 7.5f;
                for (i = 0; i < particleCount; ++i) {
                    float angle = (float)(Math.PI * 2 * (double)i / (double)particleCount);
                    double x = center.f_82479_ + (double)radius * Math.cos(angle);
                    double z = center.f_82481_ + (double)radius * Math.sin(angle);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, center.f_82480_, z, 0.0, (double)0.05f, 0.0);
                    if (i % 2 != 0) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, center.f_82480_ + (double)0.15f, z, 0.0, (double)0.08f, 0.0);
                }
                for (i = 0; i < 8; ++i) {
                    float randomAngle = level.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
                    double randomRadius = radius * (0.8f + level.f_46441_.m_188501_() * 0.4f);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, center.f_82479_ + randomRadius * Math.cos(randomAngle), center.f_82480_ + (double)0.2f, center.f_82481_ + randomRadius * Math.sin(randomAngle), (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f), (double)0.15f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f));
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent createSoulRingEffect(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entitypatch, self, params) -> {
            if (((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                int i;
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                ClientLevel level = (ClientLevel)entity.m_9236_();
                Vec3 entityPos = entity.m_20182_();
                Vec3 horizontalLook = entity.m_20154_();
                horizontalLook = new Vec3(horizontalLook.f_82479_, 0.0, horizontalLook.f_82481_).m_82541_();
                Vec3 center = entityPos.m_82549_(horizontalLook.m_82490_(2.0)).m_82520_(0.0, 0.1, 0.0);
                int particleCount = 36;
                float radius = 5.0f;
                for (i = 0; i < particleCount; ++i) {
                    float angle = (float)(Math.PI * 2 * (double)i / (double)particleCount);
                    double x = center.f_82479_ + (double)radius * Math.cos(angle);
                    double z = center.f_82481_ + (double)radius * Math.sin(angle);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_235898_, x, center.f_82480_, z, 0.0, (double)0.05f, 0.0);
                    if (i % 2 != 0) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, center.f_82480_ + (double)0.15f, z, 0.0, (double)0.08f, 0.0);
                }
                for (i = 0; i < 8; ++i) {
                    float randomAngle = level.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
                    double randomRadius = radius * (0.8f + level.f_46441_.m_188501_() * 0.4f);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, center.f_82479_ + randomRadius * Math.cos(randomAngle), center.f_82480_ + (double)0.2f, center.f_82481_ + randomRadius * Math.sin(randomAngle), (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f), (double)0.15f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f));
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, boolean teamProtect) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> ParticleEffectInvoker.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, teamProtect), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static void groundSplit(LivingEntityPatch<?> entityPatch, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, boolean teamProtect) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        float damage = AvalonEventUtils.getTotalAttackDamage(entityPatch) * 0.5f;
        Vec3 pos = entity.m_20182_();
        float yaw = entityPatch.getYRot();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        double worldX = xOffset * cosYaw + zOffset * sinYaw;
        double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw).m_82490_(viewOffset);
        Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
        Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0 + totalOffset.f_82480_, totalOffset.f_82481_);
        Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
        Level var30 = entity.m_9236_();
        if (var30 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)var30;
            if (target != null) {
                LevelUtil.circleSlamFracture((LivingEntity)entity, (Level)level, (Vec3)target, (double)radius, (boolean)false, (boolean)true, (boolean)false);
            }
        }
    }

    private static void dealAreaDamage(ServerLevel level, Vec3 center, LivingEntity source, float damage, float radius, StunType stunType, boolean teamProtect) {
        block5: {
            if (radius <= 0.0f) break block5;
            AABB area = new AABB(center.m_7096_() - (double)radius, center.m_7098_() - (double)radius, center.m_7094_() - (double)radius, center.m_7096_() + (double)radius, center.m_7098_() + (double)radius, center.m_7094_() + (double)radius);
            if (teamProtect) {
                List entities = level.m_6443_(LivingEntity.class, area, entityx -> entityx.m_6084_() && entityx.m_20238_(center) <= (double)(radius * radius) && entityx.m_6095_().m_20674_() != source.m_6095_().m_20674_() && entityx != source);
                for (LivingEntity entity : new ArrayList(entities)) {
                    if (entity.f_19802_ >= 0 && source != null) {
                        entity.f_19802_ = 0;
                        entity.m_6469_((DamageSource)EpicFightDamageSources.shockwave((LivingEntity)source).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setInitialPosition(center).setStunType(stunType).setBaseImpact(damage / 5.0f), damage);
                    }
                    entity.f_19802_ = 0;
                }
            } else {
                List entities = level.m_6443_(LivingEntity.class, area, entityx -> entityx.m_6084_() && entityx.m_20238_(center) <= (double)(radius * radius) && entityx.m_6095_() != source.m_6095_() && entityx != source);
                for (LivingEntity entity : new ArrayList(entities)) {
                    if (entity.f_19802_ < 0 || source == null) continue;
                    entity.f_19802_ = 0;
                    entity.m_6469_((DamageSource)EpicFightDamageSources.shockwave((LivingEntity)source).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setInitialPosition(center).setStunType(stunType).setBaseImpact(damage / 5.0f), damage);
                    entity.f_19802_ = 0;
                }
            }
        }
    }
}

