/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.block.testdoor;

import com.merlin204.avalon.block.MeshBlock;
import com.merlin204.avalon.epicfight.gameassets.animations.VFXAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Armatures;

public class TestDoor
extends MeshBlock {
    private ResourceLocation TEST = ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"textures/testdoor.png");
    private static final VoxelShape COLLISION_SHAPE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)48.0, (double)48.0, (double)10.0);
    private static final VoxelShape COLLISION_SHAPE_EAST_WEST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)48.0, (double)48.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public TestDoor(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"epic_fight_avalon", (String)"testdoor", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Override
    public AssetAccessor<? extends Armature> getArmature() {
        return Armatures.ArmatureAccessor.create((String)"epic_fight_avalon", (String)"testdoor", Armature::new);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return COLLISION_SHAPE_NORTH_SOUTH;
        }
        return COLLISION_SHAPE_EAST_WEST;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            boolean isPlayerFacingAway = this.isPlayerFacingAway(player, (Direction)state.m_61143_((Property)FACING));
            if (isPlayerFacingAway) {
                world.m_5594_(null, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                this.animator.playAnimation((AssetAccessor)VFXAnimations.OPEN_TEST_DOOR, 0.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u95e8\u65e0\u6cd5\u4ece\u8fd9\u4e00\u4fa7\u6253\u5f00"), true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isPlayerFacingAway(Player player, Direction doorFacing) {
        Direction playerFacing = player.m_6350_();
        return playerFacing == doorFacing;
    }

    @Override
    public void drawMesh(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        Pose pose = this.animator.getPose(partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        OpenMatrix4f[] poseMatrices = this.entitypatch.getArmature().getPoseAsTransformMatrix(pose, false);
        ((SkinnedMesh)this.getMesh().get()).draw(poseStack, bufferSource, RenderType.m_110473_((ResourceLocation)this.TEST), 0xF000F0, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, this.entitypatch.getArmature(), poseMatrices);
        poseStack.m_85849_();
    }

    private float getYRotationFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 90.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 270.0f;
            default -> 0.0f;
        };
    }
}

