/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.client.renderer.patch.entity;

import com.merlin204.avalon.entity.IAvalonMeshEntity;
import com.merlin204.avalon.entity.client.model.EmptyEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class AvalonRendererPatch
extends PatchedLivingEntityRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EmptyEntityModel<LivingEntity>, LivingEntityRenderer<LivingEntity, EmptyEntityModel<LivingEntity>>, SkinnedMesh> {
    private AssetAccessor<? extends SkinnedMesh> meshAssetAccessor = null;

    public AvalonRendererPatch(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
    }

    public void render(LivingEntity entity, LivingEntityPatch entitypatch, LivingEntityRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity instanceof IAvalonMeshEntity) {
            IAvalonMeshEntity avalonMeshEntity = (IAvalonMeshEntity)entity;
            Armature armature = entitypatch.getArmature();
            if (avalonMeshEntity.getMesh() == null) {
                return;
            }
            this.meshAssetAccessor = avalonMeshEntity.getMesh();
            SkinnedMesh mesh = (SkinnedMesh)avalonMeshEntity.getMesh().get();
            ResourceLocation texture = avalonMeshEntity.getTexture();
            if (armature == null || mesh == null || texture == null) {
                return;
            }
            RenderType renderType = RenderType.m_110473_((ResourceLocation)texture);
            ResourceLocation litTexture = avalonMeshEntity.getLitTexture();
            poseStack.m_85836_();
            this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
            this.setArmaturePose(entitypatch, armature, partialTicks);
            mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
            if (litTexture != null) {
                mesh.draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)litTexture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
            }
            this.renderLayer(renderer, entitypatch, entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
            if (Minecraft.m_91087_().m_91290_().m_114377_()) {
                entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
            }
            poseStack.m_85849_();
        }
    }

    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        if (this.meshAssetAccessor != null && this.meshAssetAccessor.get() instanceof SkinnedMesh) {
            return this.meshAssetAccessor;
        }
        return Meshes.BOOTS;
    }
}

