/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.condition;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HurtPredictCondition<T extends LivingEntityPatch<?>>
implements Condition<T> {
    private final int interpolation;

    public HurtPredictCondition(int interpolation) {
        this.interpolation = interpolation;
    }

    public boolean predicate(T livingEntityPatch) {
        LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)livingEntityPatch.getTarget(), LivingEntityPatch.class);
        if (targetPatch == null) {
            return false;
        }
        DynamicAnimation animation = (DynamicAnimation)targetPatch.getAnimator().getPlayerFor(null).getAnimation().get();
        if (animation instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)animation;
            for (AttackAnimation.Phase phase : attackAnimation.phases) {
                float atkTime = phase.contact - phase.preDelay;
                float timeStep = atkTime / (float)this.interpolation;
                for (int i = 0; i < this.interpolation; ++i) {
                    float start = phase.preDelay + (float)i * timeStep;
                    float end = phase.preDelay + (float)(i + 1) * timeStep;
                    List list = phase.getCollidingEntities(livingEntityPatch, attackAnimation, start, end, animation.getPlaySpeed(livingEntityPatch, animation));
                    HitEntityList hitEntities = new HitEntityList(livingEntityPatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
                    while (hitEntities.next()) {
                        Entity target = hitEntities.getEntity();
                        if (target != livingEntityPatch.getOriginal()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Condition<T> read(CompoundTag compoundTag) throws IllegalArgumentException {
        return null;
    }

    public CompoundTag serializePredicate() {
        return null;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

