/*
 * Decompiled with CFR 0.152.
 */
package net.lunakibby.byn.block;

import com.mojang.serialization.MapCodec;
import net.lunakibby.byn.procedures.WheatSandSlowFallProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class WheatSandBlock
extends FallingBlock {
    public static final MapCodec<WheatSandBlock> CODEC = WheatSandBlock.simpleCodec(properties -> new WheatSandBlock());

    public MapCodec<WheatSandBlock> codec() {
        return CODEC;
    }

    public WheatSandBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).sound(SoundType.SAND).strength(0.7f).noCollission().instrument(NoteBlockInstrument.SNARE));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        WheatSandSlowFallProcedure.execute((LevelAccessor)world, pos.getX(), pos.getZ(), entity);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        WheatSandSlowFallProcedure.execute((LevelAccessor)world, pos.getX(), pos.getZ(), entity);
    }
}

