/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.api;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class BestiaryRankChangedEvent
extends Event {
    private final ServerPlayer player;
    private final EntityType<?> entityType;
    private final String oldRank;
    private final String newRank;

    public BestiaryRankChangedEvent(ServerPlayer player, EntityType<?> entityType, String oldRank, String newRank) {
        this.player = player;
        this.entityType = entityType;
        this.oldRank = oldRank;
        this.newRank = newRank;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public String getOldRank() {
        return this.oldRank;
    }

    public String getNewRank() {
        return this.newRank;
    }

    public String getEntityId() {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(this.entityType);
        return key == null ? "" : key.toString();
    }

    public String getPlayerName() {
        return this.player.m_36316_().getName();
    }

    public UUID getPlayerUUID() {
        return this.player.m_20148_();
    }

    public int getOldRankCode() {
        return BestiaryRankChangedEvent.rankToCode(this.oldRank);
    }

    public int getNewRankCode() {
        return BestiaryRankChangedEvent.rankToCode(this.newRank);
    }

    public static void rankChanged(Consumer<BestiaryRankChangedEvent> handler) {
        if (handler == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, BestiaryRankChangedEvent.class, handler);
    }

    private static int rankToCode(String rank) {
        if (rank == null || rank.isEmpty()) {
            return 0;
        }
        switch (rank) {
            case "E": {
                return 1;
            }
            case "D": {
                return 2;
            }
            case "C": {
                return 3;
            }
            case "B": {
                return 4;
            }
            case "A": {
                return 5;
            }
            case "S": {
                return 6;
            }
            case "X": {
                return 7;
            }
        }
        return 0;
    }
}

