/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.item.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BestiaryToast
implements Toast {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/toasts.png");
    private final Component title;
    private final Component description;
    private final ItemStack icon;
    private final long displayTime;
    private long firstDrawTime;
    private boolean playedSound;
    private final boolean isRankToast;
    private final boolean isObservationToast;

    public BestiaryToast(EntityType<?> entityType, int threshold, long displayTime) {
        String entityName = entityType.m_20676_().getString();
        this.title = Component.m_237110_((String)"toast.araxers_bestiary.progression.title", (Object[])new Object[]{entityName});
        String descriptionKey = threshold == 1 ? "toast.araxers_bestiary.progression.discovery" : (threshold == Config.spawnLocationThreshold ? "toast.araxers_bestiary.progression.spawn_locations" : (threshold == Config.lootIconThreshold ? "toast.araxers_bestiary.progression.loot_icons" : (threshold == Config.lootChanceThreshold ? "toast.araxers_bestiary.progression.loot_chances" : (threshold == Config.advancedAttributesThreshold ? "toast.araxers_bestiary.progression.advanced_attributes" : (threshold == Config.descriptionThreshold ? "toast.araxers_bestiary.progression.description" : "toast.araxers_bestiary.progression.generic")))));
        this.description = Component.m_237115_((String)descriptionKey);
        this.icon = new ItemStack((ItemLike)ModItems.BESTIARY_BOOK.get());
        this.displayTime = displayTime;
        this.firstDrawTime = -1L;
        this.playedSound = false;
        this.isRankToast = false;
        this.isObservationToast = false;
    }

    public BestiaryToast(EntityType<?> entityType, String oldRank, String newRank, long displayTime) {
        String entityName = entityType.m_20676_().getString();
        this.title = Component.m_237110_((String)"toast.araxers_bestiary.rank.title", (Object[])new Object[]{entityName});
        this.description = Component.m_237110_((String)"toast.araxers_bestiary.rank.increase", (Object[])new Object[]{oldRank, newRank});
        this.icon = new ItemStack((ItemLike)ModItems.BESTIARY_BOOK.get());
        this.displayTime = displayTime;
        this.firstDrawTime = -1L;
        this.playedSound = false;
        this.isRankToast = true;
        this.isObservationToast = false;
    }

    public BestiaryToast(EntityType<?> entityType, boolean isObservation, long displayTime) {
        this.title = Component.m_237115_((String)"toast.araxers_bestiary.observation.title");
        this.description = Component.m_237115_((String)"toast.araxers_bestiary.observation.description");
        this.icon = new ItemStack((ItemLike)Items.f_151059_);
        this.displayTime = displayTime;
        this.firstDrawTime = -1L;
        this.playedSound = false;
        this.isRankToast = false;
        this.isObservationToast = true;
    }

    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastTick) {
        if (this.firstDrawTime == -1L) {
            this.firstDrawTime = timeSinceLastTick;
            if (!this.playedSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12497_, (float)1.0f, (float)1.0f));
                this.playedSound = true;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 0, 32, 160, 32);
        guiGraphics.m_280480_(this.icon, 8, 8);
        int titleColor = this.isRankToast ? -11163051 : (this.isObservationToast ? -5614166 : -11184658);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.title, 30, 7, titleColor, false);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.description, 30, 18, 0, false);
        return timeSinceLastTick - this.firstDrawTime < this.displayTime ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public static void show(EntityType<?> entityType, int threshold) {
        Minecraft minecraft = Minecraft.m_91087_();
        LogUtils.getLogger().info("Showing bestiary toast for entity {} with threshold {}", (Object)entityType.m_20676_().getString(), (Object)threshold);
        if (threshold == Config.descriptionThreshold) {
            LogUtils.getLogger().debug("This is a DESCRIPTION threshold toast (threshold={})", (Object)threshold);
        } else if (threshold == Config.spawnLocationThreshold) {
            LogUtils.getLogger().debug("This is a SPAWN LOCATION threshold toast (threshold={})", (Object)threshold);
        } else if (threshold == Config.lootIconThreshold) {
            LogUtils.getLogger().debug("This is a LOOT ICON threshold toast (threshold={})", (Object)threshold);
        } else if (threshold == Config.advancedAttributesThreshold) {
            LogUtils.getLogger().debug("This is an ADVANCED ATTRIBUTES threshold toast (threshold={})", (Object)threshold);
        } else if (threshold == Config.lootChanceThreshold) {
            LogUtils.getLogger().debug("This is a LOOT CHANCE threshold toast (threshold={})", (Object)threshold);
        } else if (threshold == 1) {
            LogUtils.getLogger().debug("This is a DISCOVERY toast (threshold={})", (Object)threshold);
        }
        minecraft.m_91300_().m_94922_((Toast)new BestiaryToast(entityType, threshold, 5000L));
    }

    public static void showRankIncrease(EntityType<?> entityType, String oldRank, String newRank) {
        Minecraft minecraft = Minecraft.m_91087_();
        LogUtils.getLogger().info("Showing rank increase toast for entity {} with rank change {} -> {}", new Object[]{entityType.m_20676_().getString(), oldRank, newRank});
        minecraft.m_91300_().m_94922_((Toast)new BestiaryToast(entityType, oldRank, newRank, 5000L));
    }

    public static void showObservation(EntityType<?> entityType) {
        Minecraft minecraft = Minecraft.m_91087_();
        LogUtils.getLogger().info("Showing observation toast for entity {}", (Object)entityType.m_20676_().getString());
        minecraft.m_91300_().m_94922_((Toast)new BestiaryToast(entityType, true, 5000L));
    }
}

