/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.client.ClientProgressionData;
import com.araxer.araxers_bestiary.client.PacketHandler;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary", value={Dist.CLIENT})
public class SpyglassParticleHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int particleTickCounter = 0;
    private static int heartbeatCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean discoverable;
        AABB box;
        double maxDist;
        Vec3 look;
        Vec3 end;
        Vec3 eyePos;
        EntityHitResult entityHit;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null || mc.m_91104_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_150108_()) {
            return;
        }
        try {
            if (++heartbeatCounter % 5 == 0 && mc.m_91403_() != null) {
                FriendlyByteBuf hb = new FriendlyByteBuf(Unpooled.buffer((int)0));
                mc.m_91403_().m_104955_((Packet)new ServerboundCustomPayloadPacket(CommonPacketHandler.SCOPING_STATE_CHANNEL, hb));
            }
        }
        catch (Throwable hb) {
            // empty catch block
        }
        double maxDistance = 100.0;
        Vec3 eye = player.m_146892_();
        Vec3 dir = player.m_20252_(1.0f);
        BlockHitResult blockHit = mc.f_91073_.m_45547_(new ClipContext(eye, eye.m_82549_(dir.m_82490_(maxDistance)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            blockDistance = blockHit.m_82450_().m_82554_(eye);
        }
        if ((entityHit = ProjectileUtil.m_37287_((Entity)player, (Vec3)(eyePos = player.m_146892_()), (Vec3)(end = eyePos.m_82549_((look = player.m_20252_(1.0f)).m_82490_(maxDist = Math.min(maxDistance, blockDistance == Double.MAX_VALUE ? maxDistance : blockDistance)))), (AABB)(box = player.m_20191_().m_82369_(look.m_82490_(maxDist)).m_82400_(1.0)), e -> e instanceof LivingEntity && e != player && e.m_6087_(), (double)(maxDist * maxDist))) == null) {
            return;
        }
        Entity targetEntity = entityHit.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        if (!Config.enableProgressionSystem) {
            return;
        }
        EntityType targetType = targetEntity.m_6095_();
        if (!EntityDataProvider.shouldTrackProgression(targetType)) {
            return;
        }
        String mode = Config.progressionSystemType;
        if ("sighting".equals(mode)) {
            discoverable = !ClientProgressionData.isFullyDiscovered(targetType);
        } else {
            boolean bl = discoverable = !ClientProgressionData.isSpyglassObserved(targetType);
            if (ClientProgressionData.isFullyDiscovered(targetType)) {
                discoverable = false;
            }
        }
        if (!discoverable && !PacketHandler.isScanningActiveFor(targetType)) {
            return;
        }
        if (!PacketHandler.isScanningActiveFor(targetType)) {
            return;
        }
        if ((++particleTickCounter & 1) != 0) {
            return;
        }
        SpyglassParticleHandler.spawnEnchantParticles(mc.f_91073_, (LivingEntity)targetEntity);
    }

    private static void spawnEnchantParticles(ClientLevel level, LivingEntity entity) {
        double w = Math.max(0.6, (double)entity.m_20205_());
        double h = Math.max(0.9, (double)entity.m_20206_());
        int baseCount = 6 + Mth.m_14143_((float)((float)(w * 2.0)));
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        double cx = entity.m_20185_();
        double cy = entity.m_20186_() + h * 0.6;
        double cz = entity.m_20189_();
        double radius = Math.max(0.6, w * 0.7);
        for (int i = 0; i < baseCount; ++i) {
            double angle = rnd.nextDouble() * Math.PI * 2.0;
            double r = radius + rnd.nextDouble() * 0.3;
            double px = cx + Math.cos(angle) * r;
            double pz = cz + Math.sin(angle) * r;
            double py = cy + (rnd.nextDouble() - 0.5) * (h * 0.3);
            double vx = (cx - px) * 0.05 + (rnd.nextDouble() - 0.5) * 0.02;
            double vy = (cy - py) * 0.05 + rnd.nextDouble() * 0.02;
            double vz = (cz - pz) * 0.05 + (rnd.nextDouble() - 0.5) * 0.02;
            level.m_6493_((ParticleOptions)ParticleTypes.f_123809_, true, px, py, pz, vx, vy, vz);
        }
    }
}

