/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.mojang.logging.LogUtils;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class BestiaryServerState
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DATA_NAME = "araxers_bestiary_server_state";
    private static final String KEY_LAST_PREWARM_VERSION = "lastPrewarmVersion";
    private String lastPrewarmVersion = "";

    public String getLastPrewarmVersion() {
        return this.lastPrewarmVersion == null ? "" : this.lastPrewarmVersion;
    }

    public void setLastPrewarmVersion(String version) {
        if (version == null) {
            version = "";
        }
        if (!version.equals(this.lastPrewarmVersion)) {
            this.lastPrewarmVersion = version;
            this.m_77762_();
            LOGGER.debug("Recorded bestiary prewarm completion for version {}", (Object)version);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128359_(KEY_LAST_PREWARM_VERSION, this.getLastPrewarmVersion());
        return tag;
    }

    public static BestiaryServerState load(CompoundTag tag) {
        BestiaryServerState state = new BestiaryServerState();
        if (tag != null && tag.m_128441_(KEY_LAST_PREWARM_VERSION)) {
            state.lastPrewarmVersion = tag.m_128461_(KEY_LAST_PREWARM_VERSION);
        }
        return state;
    }

    public static BestiaryServerState getOrCreate(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return new BestiaryServerState();
        }
        return (BestiaryServerState)serverLevel.m_8895_().m_164861_(BestiaryServerState::load, BestiaryServerState::new, DATA_NAME);
    }

    public static BestiaryServerState getOrCreate(MinecraftServer server) {
        Iterator iterator;
        if (server == null) {
            return new BestiaryServerState();
        }
        ServerLevel overworld = server.m_129783_();
        if (overworld == null && (iterator = server.m_129785_().iterator()).hasNext()) {
            ServerLevel lvl;
            overworld = lvl = (ServerLevel)iterator.next();
        }
        if (overworld == null) {
            return new BestiaryServerState();
        }
        return BestiaryServerState.getOrCreate(overworld);
    }
}

