/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class ObservedDropsData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DATA_NAME = "araxers_bestiary_observed_drops";
    private final Map<EntityType<?>, Map<Item, Integer>> observedDrops = new ConcurrentHashMap();
    private final Map<EntityType<?>, Integer> dropEventCounter = new ConcurrentHashMap();
    private final Map<EntityType<?>, Map<Item, Float>> lastComputedChances = new ConcurrentHashMap();
    private final Map<EntityType<?>, Integer> lastComputedEventMultiple = new ConcurrentHashMap();

    public ObservedDropsData() {
        LOGGER.debug("Created new ObservedDropsData instance");
    }

    public Map<Item, Float> getLastComputedChances(EntityType<?> entityType) {
        return this.lastComputedChances.getOrDefault(entityType, new HashMap());
    }

    public int getLastComputedEventMultiple(EntityType<?> entityType) {
        return this.lastComputedEventMultiple.getOrDefault(entityType, 0);
    }

    public void setLastComputedChances(EntityType<?> entityType, Map<Item, Float> chances, int eventCountMultiple) {
        if (chances == null) {
            this.lastComputedChances.remove(entityType);
            this.lastComputedEventMultiple.remove(entityType);
        } else {
            this.lastComputedChances.put(entityType, new ConcurrentHashMap<Item, Float>(chances));
            this.lastComputedEventMultiple.put(entityType, eventCountMultiple);
        }
        this.m_77762_();
    }

    public int getObservedDropFrequency(EntityType<?> entityType, Item item) {
        Map<Item, Integer> itemFrequency = this.observedDrops.get(entityType);
        if (itemFrequency == null) {
            return 0;
        }
        return itemFrequency.getOrDefault(item, 0);
    }

    public Map<Item, Integer> getObservedDrops(EntityType<?> entityType) {
        return this.observedDrops.getOrDefault(entityType, new HashMap());
    }

    public int getDropEventCount(EntityType<?> entityType) {
        return this.dropEventCounter.getOrDefault(entityType, 0);
    }

    public void recordObservedDrop(EntityType<?> entityType, Item item, int count) {
        Map itemFrequency = this.observedDrops.computeIfAbsent(entityType, k -> new ConcurrentHashMap());
        itemFrequency.put(item, itemFrequency.getOrDefault(item, 0) + count);
        LOGGER.debug("Recorded observed drop: {} x{} from {}", new Object[]{ForgeRegistries.ITEMS.getKey((Object)item), count, ForgeRegistries.ENTITY_TYPES.getKey(entityType)});
        this.m_77762_();
    }

    public int incrementDropEventCount(EntityType<?> entityType) {
        int newCount = this.dropEventCounter.getOrDefault(entityType, 0) + 1;
        this.dropEventCounter.put(entityType, newCount);
        LOGGER.debug("Incremented drop event count for {} to {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType), (Object)newCount);
        this.m_77762_();
        return newCount;
    }

    public void clearAll() {
        this.observedDrops.clear();
        this.dropEventCounter.clear();
        this.lastComputedChances.clear();
        this.lastComputedEventMultiple.clear();
        LOGGER.info("Cleared all observed drops data");
        this.m_77762_();
    }

    public void clearForEntityType(EntityType<?> entityType) {
        this.observedDrops.remove(entityType);
        this.dropEventCounter.remove(entityType);
        this.lastComputedChances.remove(entityType);
        this.lastComputedEventMultiple.remove(entityType);
        LOGGER.debug("Cleared observed drops data for {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        LOGGER.debug("Saving observed drops data for {} entity types", (Object)this.observedDrops.size());
        ListTag entityDropsListTag = new ListTag();
        for (Map.Entry<EntityType<?>, Map<Item, Integer>> entry : this.observedDrops.entrySet()) {
            EntityType<?> entityType = entry.getKey();
            Map<Item, Integer> itemFrequency = entry.getValue();
            if (itemFrequency.isEmpty()) continue;
            CompoundTag entityTag = new CompoundTag();
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            if (entityId == null) continue;
            entityTag.m_128359_("EntityId", entityId.toString());
            int eventCount = this.dropEventCounter.getOrDefault(entityType, 0);
            entityTag.m_128405_("EventCount", eventCount);
            ListTag itemDropsListTag = new ListTag();
            for (Map.Entry<Item, Integer> itemEntry : itemFrequency.entrySet()) {
                Item item = itemEntry.getKey();
                int frequency = itemEntry.getValue();
                CompoundTag itemTag = new CompoundTag();
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
                if (itemId == null) continue;
                itemTag.m_128359_("ItemId", itemId.toString());
                itemTag.m_128405_("Frequency", frequency);
                itemDropsListTag.add((Object)itemTag);
            }
            entityTag.m_128365_("ItemDrops", (Tag)itemDropsListTag);
            Map<Item, Float> lastChances = this.lastComputedChances.get(entityType);
            if (lastChances != null && !lastChances.isEmpty()) {
                CompoundTag lastComputedTag = new CompoundTag();
                int lastEventCount = this.lastComputedEventMultiple.getOrDefault(entityType, 0);
                lastComputedTag.m_128405_("EventCount", lastEventCount);
                ListTag lastItemsList = new ListTag();
                for (Map.Entry<Item, Float> chanceEntry : lastChances.entrySet()) {
                    Item cItem = chanceEntry.getKey();
                    Float chance = chanceEntry.getValue();
                    ResourceLocation cItemId = ForgeRegistries.ITEMS.getKey((Object)cItem);
                    if (cItemId == null) continue;
                    CompoundTag cItemTag = new CompoundTag();
                    cItemTag.m_128359_("ItemId", cItemId.toString());
                    cItemTag.m_128350_("Chance", chance.floatValue());
                    lastItemsList.add((Object)cItemTag);
                }
                lastComputedTag.m_128365_("Items", (Tag)lastItemsList);
                entityTag.m_128365_("LastComputed", (Tag)lastComputedTag);
            }
            entityDropsListTag.add((Object)entityTag);
        }
        tag.m_128365_("EntityDrops", (Tag)entityDropsListTag);
        LOGGER.info("Saved observed drops data for {} entity types", (Object)entityDropsListTag.size());
        return tag;
    }

    public static ObservedDropsData load(CompoundTag tag) {
        ObservedDropsData data = new ObservedDropsData();
        if (tag.m_128425_("EntityDrops", 9)) {
            ListTag entityDropsListTag = tag.m_128437_("EntityDrops", 10);
            LOGGER.debug("Loading observed drops data for {} entity types", (Object)entityDropsListTag.size());
            for (int i = 0; i < entityDropsListTag.size(); ++i) {
                EntityType entityType;
                CompoundTag entityTag = entityDropsListTag.m_128728_(i);
                String entityIdString = entityTag.m_128461_("EntityId");
                ResourceLocation entityId = ResourceLocation.m_135820_((String)entityIdString);
                if (entityId == null || (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId)) == null) continue;
                int eventCount = entityTag.m_128451_("EventCount");
                data.dropEventCounter.put(entityType, eventCount);
                ConcurrentHashMap<Item, Integer> itemFrequency = new ConcurrentHashMap<Item, Integer>();
                if (entityTag.m_128425_("ItemDrops", 9)) {
                    ListTag itemDropsListTag = entityTag.m_128437_("ItemDrops", 10);
                    for (int j = 0; j < itemDropsListTag.size(); ++j) {
                        Item item;
                        CompoundTag itemTag = itemDropsListTag.m_128728_(j);
                        String itemIdString = itemTag.m_128461_("ItemId");
                        ResourceLocation itemId = ResourceLocation.m_135820_((String)itemIdString);
                        if (itemId == null || (item = (Item)ForgeRegistries.ITEMS.getValue(itemId)) == null) continue;
                        int frequency = itemTag.m_128451_("Frequency");
                        itemFrequency.put(item, frequency);
                    }
                }
                if (entityTag.m_128425_("LastComputed", 10)) {
                    CompoundTag lastComputedTag = entityTag.m_128469_("LastComputed");
                    int lastEventCount = lastComputedTag.m_128451_("EventCount");
                    ConcurrentHashMap<Item, Float> chances = new ConcurrentHashMap<Item, Float>();
                    if (lastComputedTag.m_128425_("Items", 9)) {
                        ListTag lastItemsList = lastComputedTag.m_128437_("Items", 10);
                        for (int j = 0; j < lastItemsList.size(); ++j) {
                            Item cItem;
                            CompoundTag cItemTag = lastItemsList.m_128728_(j);
                            String cItemIdStr = cItemTag.m_128461_("ItemId");
                            ResourceLocation cItemId = ResourceLocation.m_135820_((String)cItemIdStr);
                            if (cItemId == null || (cItem = (Item)ForgeRegistries.ITEMS.getValue(cItemId)) == null) continue;
                            float chance = cItemTag.m_128457_("Chance");
                            chances.put(cItem, Float.valueOf(chance));
                        }
                    }
                    if (!chances.isEmpty()) {
                        data.lastComputedChances.put(entityType, chances);
                        data.lastComputedEventMultiple.put(entityType, lastEventCount);
                    }
                }
                data.observedDrops.put(entityType, itemFrequency);
                LOGGER.debug("Loaded {} observed drops for entity {}", (Object)itemFrequency.size(), (Object)entityId);
            }
            LOGGER.info("Loaded observed drops data for {} entity types", (Object)data.observedDrops.size());
        }
        return data;
    }

    public static ObservedDropsData getOrCreate(ServerLevel level) {
        return (ObservedDropsData)level.m_8895_().m_164861_(ObservedDropsData::load, ObservedDropsData::new, DATA_NAME);
    }
}

