/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.api.BestiaryGlobalThresholdReachedEvent;
import com.araxer.araxers_bestiary.api.BestiaryRankChangedEvent;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryAttributeManager;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.araxer.araxers_bestiary.network.ForgeNetwork;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.TradeWithVillagerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class PlayerProgressionData
extends SavedData {
    private transient GlobalPlayerProgressionData globalOwner;
    private final Map<UUID, Map<String, Integer>> playerRankXPoints = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, Map<String, Integer>>> playerRankXChallengePoints = new HashMap<UUID, Map<String, Map<String, Integer>>>();
    private final Map<UUID, Map<String, Long>> playerSReachedDay = new HashMap<UUID, Map<String, Long>>();
    private final Map<UUID, Map<String, Integer>> playerSessionsSinceS = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, Long>> playerLastSessionDay = new HashMap<UUID, Map<String, Long>>();
    private final Map<UUID, Map<String, Set<String>>> playerBiomesSeenForEntity = new HashMap<UUID, Map<String, Set<String>>>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DATA_NAME = "araxers_bestiary_progression";
    private final Map<UUID, Map<String, Integer>> playerESPoints = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, Integer>> playerKillCounts = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, String>> playerEntityRanks = new HashMap<UUID, Map<String, String>>();
    private final Map<UUID, Map<String, Boolean>> playerNewEntities = new HashMap<UUID, Map<String, Boolean>>();
    private final Map<UUID, Map<String, Boolean>> playerSpyglassObservedEntities = new HashMap<UUID, Map<String, Boolean>>();
    private final Map<UUID, Map<String, Boolean>> playerFullyDiscoveredEntities = new HashMap<UUID, Map<String, Boolean>>();
    private final Map<UUID, Map<UUID, Map<String, Integer>>> playerEntityObservationTicks = new HashMap<UUID, Map<UUID, Map<String, Integer>>>();
    private final Map<UUID, Long> playerLastRankXEvalDay = new HashMap<UUID, Long>();
    private final Map<UUID, Map<String, Integer>> playerEliteStreakCounts = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, Set<String>>> playerRankXObservedInstances = new HashMap<UUID, Map<String, Set<String>>>();
    private final transient Map<UUID, Map<String, Set<String>>> sessionUtilUniqueInteractions = new HashMap<UUID, Map<String, Set<String>>>();
    private final transient Map<UUID, Map<String, Set<String>>> sessionNonLethalInteractions = new HashMap<UUID, Map<String, Set<String>>>();
    private final transient Map<UUID, Long> playerLastDamageGameTime = new HashMap<UUID, Long>();
    private final transient Map<UUID, Map<String, Integer>> playerProximityTicks = new HashMap<UUID, Map<String, Integer>>();
    private final transient Map<UUID, Map<String, Long>> playerEncounterStartTicks = new HashMap<UUID, Map<String, Long>>();
    private final transient Map<UUID, Map<String, Long>> playerSJustReachedTick = new HashMap<UUID, Map<String, Long>>();
    private final transient Map<UUID, Map<String, Long>> playerLastCheeseUseTicks = new HashMap<UUID, Map<String, Long>>();
    private final transient Map<UUID, Map<String, Long>> playerObservedBeforeFightTick = new HashMap<UUID, Map<String, Long>>();
    private static final int RANKX_CHEESE_WINDOW_TICKS = 6000;
    private static final int RANKX_OBS_BEFORE_WINDOW_TICKS = 12000;
    private final transient Map<UUID, Long> playerLastClientScopingTick = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> playerGlobalBenefitIndex = new HashMap<UUID, Integer>();
    private final Map<UUID, Set<Integer>> playerDisabledGlobalBenefits = new HashMap<UUID, Set<Integer>>();

    void attachToGlobal(GlobalPlayerProgressionData owner) {
        this.globalOwner = owner;
    }

    public void m_77762_() {
        super.m_77762_();
        if (this.globalOwner != null) {
            this.globalOwner.m_77762_();
        }
    }

    public void mergeFrom(PlayerProgressionData other, ServerLevel contextLevel) {
        Set set;
        Map target;
        UUID player;
        if (other == null) {
            return;
        }
        for (Map.Entry<UUID, Map<String, Integer>> entry : other.playerKillCounts.entrySet()) {
            player = entry.getKey();
            target = this.playerKillCounts.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), e.getValue(), Integer::max);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerEntityRanks.entrySet()) {
            player = entry.getKey();
            target = this.playerEntityRanks.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                String cur = target.getOrDefault(e.getKey(), "");
                if (RankUtils.compareRanks((String)e.getValue(), cur) <= 0) continue;
                target.put(e.getKey(), (String)e.getValue());
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerNewEntities.entrySet()) {
            player = entry.getKey();
            target = this.playerNewEntities.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Boolean)e.getValue(), (a, b) -> a != false || b != false);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerSpyglassObservedEntities.entrySet()) {
            player = entry.getKey();
            target = this.playerSpyglassObservedEntities.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Boolean)e.getValue(), (a, b) -> a != false || b != false);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerFullyDiscoveredEntities.entrySet()) {
            player = entry.getKey();
            target = this.playerFullyDiscoveredEntities.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Boolean)e.getValue(), (a, b) -> a != false || b != false);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerRankXPoints.entrySet()) {
            player = entry.getKey();
            target = this.playerRankXPoints.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Integer)e.getValue(), Integer::max);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerESPoints.entrySet()) {
            player = entry.getKey();
            target = this.playerESPoints.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Integer)e.getValue(), Integer::max);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerRankXChallengePoints.entrySet()) {
            player = entry.getKey();
            target = this.playerRankXChallengePoints.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> perEntity : entry.getValue().entrySet()) {
                Map tEntity = target.computeIfAbsent(perEntity.getKey(), k -> new HashMap());
                for (Map.Entry ch : ((Map)perEntity.getValue()).entrySet()) {
                    tEntity.merge((String)ch.getKey(), (Integer)ch.getValue(), Integer::max);
                }
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerSReachedDay.entrySet()) {
            player = entry.getKey();
            target = this.playerSReachedDay.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Long)e.getValue(), Long::min);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerSessionsSinceS.entrySet()) {
            player = entry.getKey();
            target = this.playerSessionsSinceS.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Integer)e.getValue(), Integer::max);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerLastSessionDay.entrySet()) {
            player = entry.getKey();
            target = this.playerLastSessionDay.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                target.merge(e.getKey(), (Long)e.getValue(), Long::max);
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerBiomesSeenForEntity.entrySet()) {
            player = entry.getKey();
            target = this.playerBiomesSeenForEntity.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                set = target.computeIfAbsent(e.getKey(), k -> new HashSet());
                set.addAll((Collection)e.getValue());
            }
        }
        for (Map.Entry<UUID, Map<String, Object>> entry : other.playerRankXObservedInstances.entrySet()) {
            player = entry.getKey();
            target = this.playerRankXObservedInstances.computeIfAbsent(player, k -> new HashMap());
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                set = target.computeIfAbsent(e.getKey(), k -> new HashSet());
                set.addAll((Collection)e.getValue());
            }
        }
        this.m_77762_();
    }

    private void markCheeseUsage(ServerPlayer player, String token) {
        try {
            if (player == null || token == null || token.isEmpty()) {
                return;
            }
            long now = ((ServerLevel)player.m_9236_()).m_46467_();
            Map per = this.playerLastCheeseUseTicks.computeIfAbsent(player.m_20148_(), k -> new HashMap());
            per.put(token, now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean usedDisallowedCheeseRecently(ServerPlayer player, RankXConfig cfg) {
        if (player == null || cfg == null) {
            return false;
        }
        if (!Config.enableCheeseDetection) {
            return false;
        }
        List<String> dis = cfg.getDisallowedCheese();
        if (dis == null || dis.isEmpty()) {
            return false;
        }
        Map<String, Long> per = this.playerLastCheeseUseTicks.get(player.m_20148_());
        if (per == null || per.isEmpty()) {
            return false;
        }
        long now = ((ServerLevel)player.m_9236_()).m_46467_();
        for (String token : dis) {
            Long last = per.get(token);
            if (last == null || now - last > 6000L) continue;
            return true;
        }
        return false;
    }

    private void markObservedBeforeFight(ServerPlayer player, EntityType<?> entityType) {
        try {
            if (player == null || entityType == null) {
                return;
            }
            long now = ((ServerLevel)player.m_9236_()).m_46467_();
            String eid = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
            Map per = this.playerObservedBeforeFightTick.computeIfAbsent(player.m_20148_(), k -> new HashMap());
            per.put(eid, now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean observedRecentlyBeforeKill(ServerPlayer player, EntityType<?> entityType) {
        try {
            if (player == null || entityType == null) {
                return false;
            }
            Map<String, Long> per = this.playerObservedBeforeFightTick.get(player.m_20148_());
            if (per == null) {
                return false;
            }
            String eid = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
            Long last = per.get(eid);
            if (last == null) {
                return false;
            }
            long now = ((ServerLevel)player.m_9236_()).m_46467_();
            return now - last <= 12000L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getKillCount(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Integer> perPlayer = this.playerKillCounts.get(playerUUID);
        if (perPlayer == null) {
            return 0;
        }
        Integer val = perPlayer.get(entityId);
        return val == null ? 0 : val;
    }

    public int incrementKillCount(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map killCounts = this.playerKillCounts.computeIfAbsent(playerUUID, k -> new HashMap());
        int currentCount = killCounts.getOrDefault(entityId, 0);
        int newCount = currentCount + 1;
        killCounts.put(entityId, newCount);
        this.m_77762_();
        LOGGER.debug("Incremented kill count for player {} and entity {}: now {}", new Object[]{playerUUID, entityId, newCount});
        return newCount;
    }

    public String getRank(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, String> perPlayer = this.playerEntityRanks.get(playerUUID);
        if (perPlayer == null) {
            return "";
        }
        String val = perPlayer.get(entityId);
        return val == null ? "" : val;
    }

    public void setRank(UUID playerUUID, EntityType<?> entityType, String rank) {
        String entityId;
        block9: {
            if (!RankUtils.isValidRank(rank)) {
                LOGGER.warn("Attempted to set invalid rank {} for player {} and entity {}", new Object[]{rank, playerUUID, entityType.m_20675_()});
                return;
            }
            entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
            String oldRank = this.getRank(playerUUID, entityType);
            Map ranks = this.playerEntityRanks.computeIfAbsent(playerUUID, k -> new HashMap());
            ranks.put(entityId, rank);
            this.m_77762_();
            if (!Objects.equals(oldRank, rank)) {
                try {
                    ServerPlayer sp;
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server == null || (sp = server.m_6846_().m_11259_(playerUUID)) == null) break block9;
                    MinecraftForge.EVENT_BUS.post((Event)new BestiaryRankChangedEvent(sp, entityType, oldRank, rank));
                    try {
                        Level level;
                        boolean crossedX;
                        boolean crossedS = RankUtils.compareRanks(oldRank, "S") < 0 && RankUtils.compareRanks(rank, "S") >= 0;
                        boolean bl = crossedX = RankUtils.compareRanks(oldRank, "X") < 0 && RankUtils.compareRanks(rank, "X") >= 0;
                        if (crossedS && (level = sp.m_9236_()) instanceof ServerLevel) {
                            ServerLevel sl = (ServerLevel)level;
                            this.markSReachedIfNewAll(sl, playerUUID, entityType, oldRank, rank);
                            this.applyGlobalBenefitsIfEligible(sp);
                        } else if (crossedX && "X".equalsIgnoreCase(Config.globalRankProgressBarType)) {
                            this.applyGlobalBenefitsIfEligible(sp);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to post BestiaryRankChangedEvent for player {} entity {}: {}", new Object[]{playerUUID, entityId, t.toString()});
                }
            }
        }
        LOGGER.debug("Set rank for player {} and entity {} to {}", new Object[]{playerUUID, entityId, rank});
    }

    public void clearRankXForEntity(UUID playerUUID, EntityType<?> entityType) {
        Map<String, Integer> streak;
        Map<String, Long> lastDay;
        Map<String, Integer> sessions;
        Map<String, Set<String>> biomes;
        Map<String, Set<String>> observed;
        Map<String, Map<String, Integer>> byEntity;
        if (playerUUID == null || entityType == null) {
            return;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Integer> totalMap = this.playerRankXPoints.get(playerUUID);
        if (totalMap != null) {
            totalMap.remove(entityId);
            if (totalMap.isEmpty()) {
                this.playerRankXPoints.remove(playerUUID);
            }
        }
        if ((byEntity = this.playerRankXChallengePoints.get(playerUUID)) != null) {
            byEntity.remove(entityId);
            if (byEntity.isEmpty()) {
                this.playerRankXChallengePoints.remove(playerUUID);
            }
        }
        if ((observed = this.playerRankXObservedInstances.get(playerUUID)) != null) {
            observed.remove(entityId);
            if (observed.isEmpty()) {
                this.playerRankXObservedInstances.remove(playerUUID);
            }
        }
        if ((biomes = this.playerBiomesSeenForEntity.get(playerUUID)) != null) {
            biomes.remove(entityId);
            if (biomes.isEmpty()) {
                this.playerBiomesSeenForEntity.remove(playerUUID);
            }
        }
        if ((sessions = this.playerSessionsSinceS.get(playerUUID)) != null) {
            sessions.remove(entityId);
            if (sessions.isEmpty()) {
                this.playerSessionsSinceS.remove(playerUUID);
            }
        }
        if ((lastDay = this.playerLastSessionDay.get(playerUUID)) != null) {
            lastDay.remove(entityId);
            if (lastDay.isEmpty()) {
                this.playerLastSessionDay.remove(playerUUID);
            }
        }
        if ((streak = this.playerEliteStreakCounts.get(playerUUID)) != null) {
            streak.remove(entityId);
            if (streak.isEmpty()) {
                this.playerEliteStreakCounts.remove(playerUUID);
            }
        }
        this.m_77762_();
        LOGGER.info("Cleared Rank-X progression for player {} entity {}", (Object)playerUUID, (Object)entityId);
    }

    public String tryIncreaseRank(UUID playerUUID, EntityType<?> entityType, double chance, Entity entity) {
        boolean isPartiallyDiscovered;
        String newRank;
        String currentRank = this.getRank(playerUUID, entityType);
        if (!currentRank.equals(newRank = RankUtils.tryIncreaseRank(currentRank, chance, entity, isPartiallyDiscovered = this.isSpyglassObserved(playerUUID, entityType) && this.getKillCount(playerUUID, entityType) == 0, false))) {
            this.setRank(playerUUID, entityType, newRank);
            LOGGER.debug("Increased rank for player {} and entity {} from {} to {} (partially discovered: {})", new Object[]{playerUUID, entityType.m_20675_(), currentRank, newRank, isPartiallyDiscovered});
        }
        return newRank;
    }

    public int getRankXPoints(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        return ((Map)this.playerRankXPoints.getOrDefault(playerUUID, new HashMap())).getOrDefault(entityId, 0);
    }

    public void awardRankXChallenge(ServerPlayer player, EntityType<?> entityType, String challengeId) {
        RankXConfig cfg;
        if (player == null || entityType == null || challengeId == null) {
            return;
        }
        if (!Config.enableProgressionSystem) {
            return;
        }
        EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
        RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
        if (cfg == null) {
            return;
        }
        RankXConfig.Challenge ch = cfg.findChallenge(challengeId);
        if (ch == null) {
            return;
        }
        String currentRankForRX = this.getRank(player.m_20148_(), entityType);
        if (RankUtils.compareRanks(currentRankForRX, "S") < 0) {
            return;
        }
        if (RankUtils.compareRanks(currentRankForRX, "X") >= 0) {
            return;
        }
        ServerLevel lvlForRX = (ServerLevel)player.m_9236_();
        if (this.isSJustReachedThisTick(lvlForRX, player.m_20148_(), entityType)) {
            LOGGER.debug("[RankX] Suppressing '{}' challenge award for {} during S-transition tick", (Object)challengeId, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            return;
        }
        UUID playerUUID = player.m_20148_();
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map byEntity = this.playerRankXChallengePoints.computeIfAbsent(playerUUID, k -> new HashMap());
        Map challengePoints = byEntity.computeIfAbsent(entityId, k -> new HashMap());
        int already = challengePoints.getOrDefault(challengeId, 0);
        int remaining = Math.max(0, ch.cap() - already);
        if (remaining <= 0) {
            return;
        }
        int toAdd = Math.min(ch.points(), remaining);
        if (toAdd <= 0) {
            return;
        }
        challengePoints.put(challengeId, already + toAdd);
        Map totalMap = this.playerRankXPoints.computeIfAbsent(playerUUID, k -> new HashMap());
        int total = totalMap.getOrDefault(entityId, 0) + toAdd;
        int target = Math.max(0, cfg.getTarget());
        if (target > 0 && total > target) {
            total = target;
        }
        totalMap.put(entityId, total);
        this.m_77762_();
        LOGGER.info("Awarded Rank-X challenge '{}' +{} (cap {}) to player {} for entity {}: total={}", new Object[]{challengeId, toAdd, ch.cap(), player.m_7755_().getString(), entityId, total});
        this.evaluateRankXUnlock(player, entityType);
    }

    public void registerRankXSessionInteraction(ServerPlayer player, EntityType<?> entityType) {
        if (player == null || entityType == null) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        UUID playerUUID = player.m_20148_();
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Long sDay = (Long)this.playerSReachedDay.computeIfAbsent(playerUUID, k -> new HashMap()).get(entityId);
        if (sDay == null) {
            return;
        }
        long day = PlayerProgressionData.getCurrentDay(level);
        if (day < sDay) {
            return;
        }
        Map lastDayMap = this.playerLastSessionDay.computeIfAbsent(playerUUID, k -> new HashMap());
        Long lastDay = (Long)lastDayMap.get(entityId);
        if (lastDay == null || lastDay != day) {
            lastDayMap.put(entityId, day);
            Map sessionsMap = this.playerSessionsSinceS.computeIfAbsent(playerUUID, k -> new HashMap());
            int sessions = sessionsMap.getOrDefault(entityId, 0) + 1;
            sessionsMap.put(entityId, sessions);
            this.m_77762_();
            LOGGER.debug("Rank-X session +1 for {} on day {} (since S day {}): now {}", new Object[]{entityId, day, sDay, sessions});
        }
    }

    public void recordBiomeSeen(ServerPlayer player, EntityType<?> entityType) {
        try {
            if (player == null || entityType == null) {
                return;
            }
            if (!Config.enableProgressionSystem) {
                return;
            }
            UUID playerUUID = player.m_20148_();
            if (RankUtils.compareRanks(this.getRank(playerUUID, entityType), "S") < 0) {
                return;
            }
            if (this.isSJustReachedThisTick((ServerLevel)player.m_9236_(), playerUUID, entityType)) {
                LOGGER.debug("[RankX] Suppressing biome_diversity record/award during S-transition tick for {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
                return;
            }
            String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
            Holder holder = player.m_9236_().m_204166_(player.m_20183_());
            String biomeId = holder.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
            Map byEntity = this.playerBiomesSeenForEntity.computeIfAbsent(playerUUID, k -> new HashMap());
            Set set = byEntity.computeIfAbsent(entityId, k -> new HashSet());
            if (set.add(biomeId)) {
                this.m_77762_();
                if (BestiaryAttributeManager.getAttributesForEntity(entityType) != null) {
                    this.awardRankXChallenge(player, entityType, "biome_diversity");
                }
                LOGGER.debug("Recorded new biome {} for player {} entity {} ({} total biomes)", new Object[]{biomeId, player.m_7755_().getString(), entityId, set.size()});
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to record biome seen: {}", (Object)ex.getMessage());
        }
    }

    public void markSReachedIfNewAll(ServerLevel currentLevel, UUID playerUUID, EntityType<?> entityType, String previousRank, String newRank) {
        if (!"S".equals(newRank)) {
            return;
        }
        if (RankUtils.compareRanks(previousRank, "S") >= 0) {
            return;
        }
        long day = PlayerProgressionData.getCurrentDay(currentLevel);
        PlayerProgressionData data = GlobalPlayerProgressionData.get(currentLevel.m_7654_()).data();
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map sMap = data.playerSReachedDay.computeIfAbsent(playerUUID, k -> new HashMap());
        if (!sMap.containsKey(entityId)) {
            sMap.put(entityId, day);
        }
        data.playerSessionsSinceS.computeIfAbsent(playerUUID, k -> new HashMap()).put(entityId, 0);
        data.playerLastSessionDay.computeIfAbsent(playerUUID, k -> new HashMap()).remove(entityId);
        try {
            long nowTick = currentLevel.m_46467_();
            Map byEntity = data.playerSJustReachedTick.computeIfAbsent(playerUUID, k -> new HashMap());
            byEntity.put(entityId, nowTick);
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.m_77762_();
        LOGGER.info("Recorded S-rank day {} for player {} entity {} (global)", new Object[]{day, playerUUID, entityId});
        try {
            ServerPlayer sp = currentLevel.m_7654_().m_6846_().m_11259_(playerUUID);
            if (sp != null) {
                this.applyGlobalBenefitsIfEligible(sp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static long getCurrentDay(ServerLevel level) {
        return level.m_46468_() / 24000L;
    }

    private int countSOrAbove(UUID playerUUID) {
        try {
            Map<String, String> ranks = this.playerEntityRanks.get(playerUUID);
            if (ranks == null || ranks.isEmpty()) {
                return 0;
            }
            int cnt = 0;
            for (String r : ranks.values()) {
                if (RankUtils.compareRanks(r, "S") < 0) continue;
                ++cnt;
            }
            return cnt;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int countX(UUID playerUUID) {
        try {
            Map<String, String> ranks = this.playerEntityRanks.get(playerUUID);
            if (ranks == null || ranks.isEmpty()) {
                return 0;
            }
            int cnt = 0;
            for (String r : ranks.values()) {
                if (RankUtils.compareRanks(r, "X") < 0) continue;
                ++cnt;
            }
            return cnt;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int computeCurrentGlobalBenefitIndex(int count) {
        List<Integer> thresholds = Config.globalSRankThresholds != null && !Config.globalSRankThresholds.isEmpty() ? Config.globalSRankThresholds : List.of(Integer.valueOf(50));
        int idx = -1;
        int i = 0;
        while (i < thresholds.size() && count >= thresholds.get(i)) {
            idx = i++;
        }
        return idx;
    }

    private boolean isBenefitDisabledForPlayer(UUID playerUUID, int index) {
        Set<Integer> set = this.playerDisabledGlobalBenefits.get(playerUUID);
        return set != null && set.contains(index);
    }

    public void setBenefitDisabled(ServerPlayer player, int index, boolean disabled) {
        if (player == null || index < 0) {
            return;
        }
        Set set = this.playerDisabledGlobalBenefits.computeIfAbsent(player.m_20148_(), k -> new HashSet());
        boolean changed = disabled ? set.add(index) : set.remove(index);
        if (!changed) {
            return;
        }
        this.reconcileGlobalBenefitsForPlayer(player);
        this.m_77762_();
    }

    private void applyBenefitByIndex(ServerPlayer player, int index) {
        if (player == null) {
            return;
        }
        List<String> defs = Config.globalBenefits;
        if (defs == null || index < 0 || index >= defs.size()) {
            return;
        }
        String def = defs.get(index);
        if (def == null) {
            return;
        }
        String trimmed = def.trim();
        if (trimmed.isEmpty() || "-".equals(trimmed) || "skip".equalsIgnoreCase(trimmed) || "none".equalsIgnoreCase(trimmed)) {
            LOGGER.debug("[GlobalBenefits] Skipping benefit at index {} by config entry '{}'", (Object)index, (Object)trimmed);
            return;
        }
        int lastColon = trimmed.lastIndexOf(58);
        if (lastColon <= 0 || lastColon >= trimmed.length() - 1) {
            LOGGER.warn("[GlobalBenefits] Invalid definition '{}': expected 'namespace:id:value'", (Object)trimmed);
            return;
        }
        String idStr = trimmed.substring(0, lastColon);
        String valueStr = trimmed.substring(lastColon + 1);
        ResourceLocation id = ResourceLocation.m_135820_((String)idStr);
        if (id == null) {
            LOGGER.warn("[GlobalBenefits] Invalid id in '{}': not a valid ResourceLocation", (Object)trimmed);
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(("araxers_bestiary:global_benefit:" + index).getBytes(StandardCharsets.UTF_8));
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id);
        if (effect != null) {
            int level;
            try {
                level = Integer.parseInt(valueStr.trim());
            }
            catch (Exception ex) {
                level = 1;
            }
            if (level < 1) {
                level = 1;
            }
            int amplifier = level - 1;
            int duration = 630720000;
            MobEffectInstance inst = new MobEffectInstance(effect, duration, amplifier, true, false);
            player.m_7292_(inst);
            LOGGER.info("[GlobalBenefits] Applied effect {} level {} (amp {}) to {} for threshold index {}", new Object[]{id, level, amplifier, player.m_36316_().getName(), index});
            return;
        }
        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id);
        if (attr != null) {
            double amount;
            try {
                amount = Double.parseDouble(valueStr.trim());
            }
            catch (Exception ex) {
                amount = 0.0;
            }
            AttributeInstance inst = player.m_21051_(attr);
            if (inst == null) {
                return;
            }
            AttributeModifier.Operation op = AttributeModifier.Operation.ADDITION;
            AttributeModifier mod = new AttributeModifier(uuid, "BestiaryGlobalBenefit[" + index + "]", amount, op);
            try {
                inst.m_22125_(mod);
            }
            catch (Throwable t) {
                inst.m_22118_(mod);
            }
            if (attr.equals(Attributes.f_22276_)) {
                try {
                    player.m_21153_(player.m_21233_());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LOGGER.info("[GlobalBenefits] Applied attribute {} +{} to {} for threshold index {}", new Object[]{id, amount, player.m_36316_().getName(), index});
            return;
        }
        LOGGER.warn("[GlobalBenefits] Unknown id '{}' (neither MobEffect nor Attribute)", (Object)idStr);
    }

    public void applyGlobalBenefitsIfEligible(ServerPlayer player) {
        this.reconcileGlobalBenefitsForPlayer(player, true);
    }

    private void removeBenefitByIndex(ServerPlayer player, int index) {
        if (player == null) {
            return;
        }
        List<String> defs = Config.globalBenefits;
        if (defs == null || index < 0 || index >= defs.size()) {
            return;
        }
        String def = defs.get(index);
        if (def == null) {
            return;
        }
        String trimmed = def.trim();
        if (trimmed.isEmpty() || "-".equals(trimmed) || "skip".equalsIgnoreCase(trimmed) || "none".equalsIgnoreCase(trimmed)) {
            return;
        }
        int lastColon = trimmed.lastIndexOf(58);
        if (lastColon <= 0 || lastColon >= trimmed.length() - 1) {
            return;
        }
        String idStr = trimmed.substring(0, lastColon);
        ResourceLocation id = ResourceLocation.m_135820_((String)idStr);
        if (id == null) {
            return;
        }
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id);
        if (effect != null) {
            try {
                if (player.m_21023_(effect)) {
                    player.m_21195_(effect);
                    LOGGER.info("[GlobalBenefits] Removed effect {} from {} for threshold index {}", new Object[]{id, player.m_36316_().getName(), index});
                } else {
                    LOGGER.debug("[GlobalBenefits] Effect {} not present on {} for index {} (no-op)", new Object[]{id, player.m_36316_().getName(), index});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id);
        if (attr != null) {
            AttributeInstance inst = player.m_21051_(attr);
            if (inst == null) {
                return;
            }
            UUID uuid = UUID.nameUUIDFromBytes(("araxers_bestiary:global_benefit:" + index).getBytes(StandardCharsets.UTF_8));
            boolean had = false;
            try {
                had = inst.m_22111_(uuid) != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                inst.m_22120_(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (attr.equals(Attributes.f_22276_)) {
                try {
                    player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (had) {
                LOGGER.info("[GlobalBenefits] Removed attribute modifier {} from {} for threshold index {}", new Object[]{id, player.m_36316_().getName(), index});
            } else {
                LOGGER.debug("[GlobalBenefits] Attribute modifier {} for index {} not present on {} (no-op)", new Object[]{id, index, player.m_36316_().getName()});
            }
        }
    }

    private void removeAttributeModifierByIndexAnyAttr(ServerPlayer player, int index) {
        if (player == null || index < 0) {
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(("araxers_bestiary:global_benefit:" + index).getBytes(StandardCharsets.UTF_8));
        try {
            for (Attribute attr : ForgeRegistries.ATTRIBUTES) {
                AttributeInstance inst;
                if (attr == null || (inst = player.m_21051_(attr)) == null) continue;
                try {
                    inst.m_22120_(uuid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!attr.equals(Attributes.f_22276_)) continue;
                try {
                    player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reconcileGlobalBenefitsForPlayer(ServerPlayer player) {
        this.reconcileGlobalBenefitsForPlayer(player, false);
    }

    public void reconcileGlobalBenefitsForPlayer(ServerPlayer player, boolean emitEvents) {
        AttributeModifier existing;
        Config.ParsedBenefit pb;
        int i;
        if (player == null) {
            return;
        }
        if (Config.globalSRankThresholds == null || Config.globalSRankThresholds.isEmpty()) {
            return;
        }
        boolean useX = "X".equalsIgnoreCase(Config.globalRankProgressBarType);
        int count = useX ? this.countX(player.m_20148_()) : this.countSOrAbove(player.m_20148_());
        int desiredIdx = this.computeCurrentGlobalBenefitIndex(count);
        int lastApplied = this.playerGlobalBenefitIndex.getOrDefault(player.m_20148_(), -1);
        List<String> defsEarly = Config.globalBenefits;
        int maxConfiguredIdx = -1;
        if (Config.globalSRankThresholds != null && !Config.globalSRankThresholds.isEmpty()) {
            maxConfiguredIdx = Config.globalSRankThresholds.size() - 1;
        }
        if (defsEarly != null && !defsEarly.isEmpty()) {
            int bMax = defsEarly.size() - 1;
            int n = maxConfiguredIdx = maxConfiguredIdx < 0 ? bMax : Math.min(maxConfiguredIdx, bMax);
        }
        if (maxConfiguredIdx >= 0 && lastApplied > maxConfiguredIdx) {
            lastApplied = maxConfiguredIdx;
        }
        if (emitEvents && desiredIdx > lastApplied) {
            try {
                List<Integer> thresholds = Config.globalSRankThresholds;
                List<String> defs = Config.globalBenefits;
                String barType = useX ? "X" : "S";
                for (int i2 = lastApplied + 1; i2 <= desiredIdx && i2 < thresholds.size(); ++i2) {
                    String trimmed;
                    int value = thresholds.get(i2);
                    String def = defs != null && i2 < defs.size() ? defs.get(i2) : null;
                    String string = trimmed = def == null ? null : def.trim();
                    if (trimmed != null && (trimmed.isEmpty() || "-".equals(trimmed) || "skip".equalsIgnoreCase(trimmed) || "none".equalsIgnoreCase(trimmed))) {
                        trimmed = null;
                    }
                    try {
                        MinecraftForge.EVENT_BUS.post((Event)new BestiaryGlobalThresholdReachedEvent(player, i2, value, barType, trimmed));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable thresholds) {
                // empty catch block
            }
        }
        for (int i3 = Math.max(0, lastApplied); i3 > desiredIdx; --i3) {
            boolean removedViaConfigId = false;
            try {
                List<String> defsTry = Config.globalBenefits;
                if (defsTry != null && i3 < defsTry.size()) {
                    this.removeBenefitByIndex(player, i3);
                    removedViaConfigId = true;
                }
            }
            catch (Exception defsTry) {
                // empty catch block
            }
            if (removedViaConfigId) continue;
            this.removeAttributeModifierByIndexAnyAttr(player, i3);
        }
        List<Config.ParsedBenefit> parsed = Config.parsedGlobalBenefits;
        UUID puid = player.m_20148_();
        Set disabledIdx = this.playerDisabledGlobalBenefits.getOrDefault(puid, Collections.emptySet());
        HashMap<MobEffect, Integer> effectLevelSums = new HashMap<MobEffect, Integer>();
        int upTo = desiredIdx;
        for (i = 0; parsed != null && i <= upTo && i < parsed.size(); ++i) {
            pb = parsed.get(i);
            if (pb != null && !pb.skip && pb.effect == null) continue;
            this.removeAttributeModifierByIndexAnyAttr(player, i);
        }
        for (i = 0; parsed != null && i <= upTo && i < parsed.size(); ++i) {
            boolean needsUpdate;
            AttributeInstance attributeInstance;
            if (disabledIdx.contains(i) || (pb = parsed.get(i)) == null || pb.skip) continue;
            if (pb.effect != null) {
                effectLevelSums.merge(pb.effect, Math.max(1, pb.effectLevel), Integer::sum);
                continue;
            }
            if (pb.attribute == null || (attributeInstance = player.m_21051_(pb.attribute)) == null) continue;
            existing = null;
            try {
                existing = attributeInstance.m_22111_(pb.uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            double desiredAmount = pb.attributeAmount;
            boolean bl = needsUpdate = existing == null || Math.abs(existing.m_22218_() - desiredAmount) > 1.0E-9;
            if (!needsUpdate) continue;
            try {
                if (existing != null) {
                    attributeInstance.m_22120_(pb.uuid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            AttributeModifier.Operation op = AttributeModifier.Operation.ADDITION;
            AttributeModifier mod = new AttributeModifier(pb.uuid, "BestiaryGlobalBenefit[" + i + "]", desiredAmount, op);
            try {
                attributeInstance.m_22125_(mod);
            }
            catch (Throwable t) {
                attributeInstance.m_22118_(mod);
            }
            if (!pb.attribute.equals(Attributes.f_22276_)) continue;
            try {
                player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                continue;
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        HashSet desiredEffects = new HashSet(effectLevelSums.keySet());
        try {
            ArrayList active = new ArrayList(player.m_21220_());
            int n = 1728000;
            existing = active.iterator();
            while (existing.hasNext()) {
                boolean looksLikeBestiary;
                MobEffect eff;
                MobEffectInstance inst = (MobEffectInstance)existing.next();
                if (inst == null || (eff = inst.m_19544_()) == null || !(looksLikeBestiary = inst.m_19571_() && !inst.m_19572_() && inst.m_19557_() >= n) || desiredEffects.contains(eff)) continue;
                try {
                    player.m_21195_(eff);
                }
                catch (Exception op) {}
            }
        }
        catch (Exception active) {
            // empty catch block
        }
        for (Map.Entry entry : effectLevelSums.entrySet()) {
            MobEffect eff = (MobEffect)entry.getKey();
            int level = Math.max(1, (Integer)entry.getValue());
            int amp = level - 1;
            MobEffectInstance cur = player.m_21124_(eff);
            boolean same = false;
            if (cur != null) {
                int longDurationThreshold = 1728000;
                boolean bl = same = cur.m_19564_() == amp && cur.m_19571_() && !cur.m_19572_() && cur.m_19557_() >= longDurationThreshold;
            }
            if (same) continue;
            int duration = 630720000;
            MobEffectInstance inst = new MobEffectInstance(eff, duration, amp, true, false);
            try {
                player.m_21195_(eff);
            }
            catch (Exception exception) {
                // empty catch block
            }
            player.m_7292_(inst);
        }
        Set<Integer> disabled = this.playerDisabledGlobalBenefits.get(player.m_20148_());
        if (disabled != null && !disabled.isEmpty()) {
            for (Integer di : disabled) {
                Config.ParsedBenefit pb2;
                if (di == null || parsed == null || di < 0 || di >= parsed.size() || (pb2 = parsed.get(di)) == null || pb2.skip || pb2.effect != null || pb2.attribute == null) continue;
                this.removeBenefitByIndex(player, di);
            }
        }
        this.playerGlobalBenefitIndex.put(player.m_20148_(), desiredIdx);
        this.m_77762_();
    }

    public void recordClientScopingHeartbeat(ServerPlayer player) {
        try {
            if (player == null) {
                return;
            }
            long now = ((ServerLevel)player.m_9236_()).m_46467_();
            this.playerLastClientScopingTick.put(player.m_20148_(), now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClientScopingActive(ServerPlayer player, int ttlTicks) {
        try {
            if (player == null) {
                return false;
            }
            Long last = this.playerLastClientScopingTick.get(player.m_20148_());
            if (last == null) {
                return false;
            }
            long now = ((ServerLevel)player.m_9236_()).m_46467_();
            int ttl = Math.max(1, ttlTicks);
            return now - last <= (long)ttl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isSJustReachedThisTick(ServerLevel level, UUID playerUUID, EntityType<?> entityType) {
        try {
            if (level == null || playerUUID == null || entityType == null) {
                return false;
            }
            String eid = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
            Map<String, Long> perEntity = this.playerSJustReachedTick.get(playerUUID);
            if (perEntity == null) {
                return false;
            }
            Long tick = perEntity.get(eid);
            if (tick == null) {
                return false;
            }
            return tick.longValue() == level.m_46467_();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void backfillSReachedDayIfMissing(ServerPlayer player) {
        try {
            if (player == null) {
                return;
            }
            ServerLevel current = (ServerLevel)player.m_9236_();
            if (current.m_7654_() == null) {
                return;
            }
            UUID puid = player.m_20148_();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(current);
            Map ranks = data.playerEntityRanks.getOrDefault(puid, new HashMap());
            if (ranks.isEmpty()) {
                return;
            }
            Map sMap = data.playerSReachedDay.computeIfAbsent(puid, k -> new HashMap());
            long day = PlayerProgressionData.getCurrentDay(current);
            boolean changed = false;
            for (Map.Entry e : ranks.entrySet()) {
                if (RankUtils.compareRanks((String)e.getValue(), "S") < 0 || sMap.containsKey(e.getKey())) continue;
                sMap.put((String)e.getKey(), day);
                data.playerSessionsSinceS.computeIfAbsent(puid, k -> new HashMap()).putIfAbsent((String)e.getKey(), 0);
                data.playerLastSessionDay.computeIfAbsent(puid, k -> new HashMap()).remove(e.getKey());
                changed = true;
                LOGGER.debug("Backfilled S-day {} for player {} entity {} (global)", new Object[]{day, puid, e.getKey()});
            }
            if (changed) {
                data.m_77762_();
            }
        }
        catch (Exception ex) {
            LOGGER.debug("S-day backfill failed: {}", (Object)ex.getMessage());
        }
    }

    public void evaluateRankXUnlock(ServerPlayer player, EntityType<?> entityType) {
        int needDays;
        RankXConfig cfg;
        if (player == null || entityType == null) {
            return;
        }
        if (!Config.enableProgressionSystem || !"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
        RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
        if (cfg == null) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        int total = this.getRankXPoints(playerUUID, entityType);
        if (total < cfg.getTarget()) {
            return;
        }
        Map sMap = this.playerSReachedDay.getOrDefault(playerUUID, new HashMap());
        Long sDay = (Long)sMap.get(entityId);
        String curRankForGate = this.getRank(playerUUID, entityType);
        if (sDay == null && RankUtils.compareRanks(curRankForGate, "S") >= 0) {
            long today = PlayerProgressionData.getCurrentDay((ServerLevel)player.m_9236_());
            sMap.put(entityId, today);
            this.playerSReachedDay.put(playerUUID, sMap);
            this.m_77762_();
            sDay = today;
        }
        if (sDay == null) {
            return;
        }
        long daysSinceS = PlayerProgressionData.getCurrentDay((ServerLevel)player.m_9236_()) - sDay;
        RankXConfig.GateConfig gates = cfg.getGates();
        int n = needDays = gates != null ? gates.getMinDaysSinceS() : 0;
        if (daysSinceS < (long)needDays) {
            return;
        }
        String oldRank = curRankForGate;
        if (RankUtils.compareRanks(oldRank, "X") >= 0) {
            return;
        }
        this.setRank(playerUUID, entityType, "X");
        PlayerProgressionData.sendRankIncreaseToastNotification(player, entityType, oldRank, "X");
        this.sendProgressionUpdatePacket(player, entityType, this.getKillCount(playerUUID, entityType), "X");
        try {
            if ("X".equalsIgnoreCase(Config.globalRankProgressBarType)) {
                this.applyGlobalBenefitsIfEligible(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.info("Rank-X unlocked for player {} on entity {} (points={}, daysSinceS={})", new Object[]{player.m_7755_().getString(), entityId, total, daysSinceS});
    }

    public String tryIncreaseRank(UUID playerUUID, EntityType<?> entityType, double chance, Entity entity, boolean rollAssignedRank) {
        boolean isPartiallyDiscovered;
        String newRank;
        String currentRank = this.getRank(playerUUID, entityType);
        if (!currentRank.equals(newRank = RankUtils.tryIncreaseRank(currentRank, chance, entity, isPartiallyDiscovered = this.isSpyglassObserved(playerUUID, entityType) && this.getKillCount(playerUUID, entityType) == 0, rollAssignedRank))) {
            this.setRank(playerUUID, entityType, newRank);
            LOGGER.debug("Increased rank for player {} and entity {} from {} to {} (partially discovered: {})", new Object[]{playerUUID, entityType.m_20675_(), currentRank, newRank, isPartiallyDiscovered});
        }
        return newRank;
    }

    public String tryIncreaseRank(UUID playerUUID, EntityType<?> entityType, double chance) {
        return this.tryIncreaseRank(playerUUID, entityType, chance, null);
    }

    public boolean meetsRankThreshold(UUID playerUUID, EntityType<?> entityType, String thresholdRank) {
        String rank = this.getRank(playerUUID, entityType);
        return RankUtils.meetsRankThreshold(rank, thresholdRank);
    }

    public int getESPoints(UUID playerUUID, EntityType<?> entityType) {
        if (playerUUID == null || entityType == null) {
            return 0;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        return this.playerESPoints.getOrDefault(playerUUID, Collections.emptyMap()).getOrDefault(entityId, 0);
    }

    private void setESPoints(UUID playerUUID, EntityType<?> entityType, int value) {
        if (playerUUID == null || entityType == null) {
            return;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map map = this.playerESPoints.computeIfAbsent(playerUUID, k -> new HashMap());
        map.put(entityId, Math.max(0, value));
        this.m_77762_();
    }

    private int getESThresholdForCurrentStep(EntityType<?> entityType, String currentRank) {
        return BestiaryAttributeManager.getEffectiveESThreshold(entityType, currentRank);
    }

    public void addESPoints(ServerPlayer player, EntityType<?> entityType, int basePoints, Entity contextEntity, String source) {
        int threshold;
        if (player == null || entityType == null) {
            return;
        }
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        if (!"points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType))) {
            return;
        }
        if (!EntityDataProvider.shouldTrackProgression(entityType)) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        String currentRank = this.getRank(playerUUID, entityType);
        if (RankUtils.compareRanks(currentRank, "S") >= 0) {
            return;
        }
        boolean fromObservation = "observe".equalsIgnoreCase(source);
        if (currentRank.equals("")) {
            if (fromObservation && !Config.allowObservationChanceRolls) {
                assigned = "E";
                this.setRank(playerUUID, entityType, assigned);
                if (this.getKillCount(playerUUID, entityType) == 0) {
                    this.markAsNewlyDiscovered(playerUUID, entityType);
                    PlayerProgressionData.sendDiscoveryToastNotification(player, entityType);
                }
                currentRank = assigned;
            } else {
                assigned = this.tryIncreaseRank(playerUUID, entityType, Config.rankKillChance, contextEntity, false);
                if (!assigned.equals("")) {
                    this.setRank(playerUUID, entityType, assigned);
                    if (this.getKillCount(playerUUID, entityType) == 0) {
                        this.markAsNewlyDiscovered(playerUUID, entityType);
                        PlayerProgressionData.sendDiscoveryToastNotification(player, entityType);
                    }
                    currentRank = assigned;
                }
            }
        }
        if ((threshold = this.getESThresholdForCurrentStep(entityType, currentRank)) <= 0) {
            return;
        }
        int toAdd = Math.max(0, basePoints);
        if (contextEntity != null && RankUtils.isBossEntity(contextEntity)) {
            double scaled = (double)toAdd * BestiaryAttributeManager.getEffectiveESBossMultiplier(entityType);
            toAdd = (int)Math.max(0L, Math.round(scaled));
        }
        int before = this.getESPoints(playerUUID, entityType);
        if (Config.debugMode) {
            LOGGER.debug("[ES] addESPoints: player={}, entity={}, rank={}, base={}, toAdd={}, before={}, threshold={}", new Object[]{player.m_7755_().getString(), ForgeRegistries.ENTITY_TYPES.getKey(entityType), currentRank, basePoints, toAdd, before, threshold});
        }
        int after = Math.min(threshold, before + toAdd);
        this.setESPoints(playerUUID, entityType, after);
        if (after >= threshold) {
            String newRank = RankUtils.getNextRank(currentRank);
            this.setRank(playerUUID, entityType, newRank);
            if (Config.debugMode) {
                LOGGER.debug("[ES] threshold reached: player={}, entity={}, fromRank={} -> newRank={}, pointsAfter={}/{} (reset)", new Object[]{player.m_7755_().getString(), ForgeRegistries.ENTITY_TYPES.getKey(entityType), currentRank, newRank, after, threshold});
            }
            this.setESPoints(playerUUID, entityType, 0);
            PlayerProgressionData.sendRankIncreaseToastNotification(player, entityType, currentRank, newRank);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.markSReachedIfNewAll(sl, playerUUID, entityType, currentRank, newRank);
            }
        }
        this.sendProgressionUpdatePacket(player, entityType, this.getKillCount(playerUUID, entityType), this.getRank(playerUUID, entityType));
    }

    public void sendProgressionUpdatePacket(ServerPlayer player, EntityType<?> entityType, int killCount, String rank) {
        boolean hasESPointsBlock;
        try {
            if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                this.evaluateRankXUnlock(player, entityType);
                rank = this.getRank(player.m_20148_(), entityType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(killCount);
        buf.m_130070_(Config.progressionSystemType);
        if ("ranks".equals(Config.progressionSystemType)) {
            buf.m_130070_(rank != null ? rank : "");
        }
        boolean isNew = this.isNewlyDiscovered(player.m_20148_(), entityType);
        buf.writeBoolean(isNew);
        boolean isSpyglassObserved = this.isSpyglassObserved(player.m_20148_(), entityType);
        buf.writeBoolean(isSpyglassObserved);
        if (Config.enableProgressionSystem) {
            EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
            RankXConfig rxCfg = attrs != null ? attrs.rankX() : null;
            boolean hasRankX = rxCfg != null;
            buf.writeBoolean(hasRankX);
            if (hasRankX) {
                Level level;
                int totalPts = this.getRankXPoints(player.m_20148_(), entityType);
                buf.writeInt(totalPts);
                Long sDay = (Long)((Map)this.playerSReachedDay.getOrDefault(player.m_20148_(), new HashMap())).get(ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString());
                int daysSinceS = -1;
                if (sDay != null && (level = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    daysSinceS = (int)(PlayerProgressionData.getCurrentDay(sl) - sDay);
                }
                buf.writeInt(daysSinceS);
                int sessions = ((Map)this.playerSessionsSinceS.getOrDefault(player.m_20148_(), new HashMap())).getOrDefault(ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString(), 0);
                buf.writeInt(sessions);
                Map byEntity = this.playerRankXChallengePoints.getOrDefault(player.m_20148_(), new HashMap());
                Map perChallenge = byEntity.getOrDefault(ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString(), Collections.emptyMap());
                buf.writeInt(perChallenge.size());
                for (Map.Entry e : perChallenge.entrySet()) {
                    buf.m_130070_((String)e.getKey());
                    buf.writeInt(((Integer)e.getValue()).intValue());
                }
            }
        }
        boolean bl = hasESPointsBlock = "ranks".equals(Config.progressionSystemType) && "points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType));
        if (hasESPointsBlock) {
            String cur = this.getRank(player.m_20148_(), entityType);
            boolean showES = RankUtils.compareRanks(cur, "S") < 0;
            buf.writeBoolean(showES);
            if (showES) {
                int curPts = this.getESPoints(player.m_20148_(), entityType);
                int threshold = this.getESThresholdForCurrentStep(entityType, cur);
                buf.writeInt(curPts);
                buf.writeInt(threshold);
            }
        }
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_UPDATE_CHANNEL, buf);
        if ("kills".equals(Config.progressionSystemType)) {
            LOGGER.debug("Sent progression update packet to player {} for entity {} with kill count {}, new status {}, spyglass observed {}", new Object[]{player.m_7755_().getString(), entityType.m_20675_(), killCount, isNew, isSpyglassObserved});
        } else {
            LOGGER.debug("Sent progression update packet to player {} for entity {} with rank {}, new status {}, spyglass observed {}", new Object[]{player.m_7755_().getString(), entityType.m_20675_(), rank, isNew, isSpyglassObserved});
        }
    }

    public void sendProgressionUpdatePacket(ServerPlayer player, EntityType<?> entityType, int killCount) {
        String rank = this.getRank(player.m_20148_(), entityType);
        this.sendProgressionUpdatePacket(player, entityType, killCount, rank);
    }

    public void sendScanningProgressPacket(ServerPlayer player, EntityType<?> entityType, int currentTicks, int maxTicks) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(currentTicks);
        buf.writeInt(maxTicks);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.SCANNING_PROGRESS_CHANNEL, buf);
        if (currentTicks % 10 == 0 || currentTicks == 1) {
            LOGGER.debug("Sent scanning progress packet to player {} for entity {}: {}/{} ticks", new Object[]{player.m_7755_().getString(), entityType.m_20675_(), currentTicks, maxTicks});
        }
    }

    public void sendScanningProgressPacket(ServerPlayer player, EntityType<?> entityType, int currentTicks, int maxTicks, boolean completionPing) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(currentTicks);
        buf.writeInt(maxTicks);
        buf.writeBoolean(completionPing);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.SCANNING_PROGRESS_CHANNEL, buf);
        LOGGER.debug("Sent scanning progress packet{} to player {} for entity {}: {}/{} ticks", new Object[]{completionPing ? " (completion)" : "", player.m_7755_().getString(), entityType.m_20675_(), currentTicks, maxTicks});
    }

    /*
     * WARNING - void declaration
     */
    public void sendProgressionSyncPacket(ServerPlayer player) {
        ResourceLocation entityTypeId;
        void var10_29;
        UUID playerUUID = player.m_20148_();
        Map killCounts = this.playerKillCounts.getOrDefault(playerUUID, new HashMap());
        Map ranks = this.playerEntityRanks.getOrDefault(playerUUID, new HashMap());
        Map newEntities = this.playerNewEntities.getOrDefault(playerUUID, new HashMap());
        Map spyglassObserved = this.playerSpyglassObservedEntities.getOrDefault(playerUUID, new HashMap());
        try {
            Map totalRx;
            if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType) && !(totalRx = (Map)this.playerRankXPoints.getOrDefault(playerUUID, new HashMap())).isEmpty()) {
                for (Map.Entry entry : totalRx.entrySet()) {
                    EntityType et;
                    String string = (String)entry.getKey();
                    ResourceLocation rl = ResourceLocation.m_135820_((String)string);
                    if (rl == null || (et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl)) == null) continue;
                    try {
                        this.evaluateRankXUnlock(player, et);
                    }
                    catch (Exception exception) {}
                }
                ranks = this.playerEntityRanks.getOrDefault(playerUUID, new HashMap());
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Rank-X retroactive unlock during sync failed: {}", (Object)ex.getMessage());
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(Config.progressionSystemType);
        buf.writeInt(killCounts.size());
        for (Map.Entry entry : killCounts.entrySet()) {
            String string = (String)entry.getKey();
            int killCount = (Integer)entry.getValue();
            ResourceLocation entityTypeId2 = ResourceLocation.m_135820_((String)string);
            if (entityTypeId2 == null) continue;
            buf.m_130085_(entityTypeId2);
            buf.writeInt(killCount);
            boolean isNew = newEntities.getOrDefault(string, false);
            buf.writeBoolean(isNew);
        }
        if ("ranks".equals(Config.progressionSystemType)) {
            buf.writeInt(ranks.size());
            for (Map.Entry entry : ranks.entrySet()) {
                String string = (String)entry.getKey();
                String rank = (String)entry.getValue();
                ResourceLocation entityTypeId2 = ResourceLocation.m_135820_((String)string);
                if (entityTypeId2 == null) continue;
                buf.m_130085_(entityTypeId2);
                buf.m_130070_(rank);
            }
        }
        int observedCount = 0;
        for (Map.Entry entry : spyglassObserved.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            ++observedCount;
        }
        buf.writeInt(observedCount);
        for (Map.Entry entry : spyglassObserved.entrySet()) {
            ResourceLocation entityTypeId3;
            String entityId2 = (String)entry.getKey();
            boolean observed = (Boolean)entry.getValue();
            if (!observed || (entityTypeId3 = ResourceLocation.m_135820_((String)entityId2)) == null) continue;
            buf.m_130085_(entityTypeId3);
        }
        Map map = this.playerFullyDiscoveredEntities.getOrDefault(playerUUID, new HashMap());
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            ++var10_29;
        }
        buf.writeInt((int)var10_29);
        for (Map.Entry entry : map.entrySet()) {
            String entityId3 = (String)entry.getKey();
            boolean bl2 = (Boolean)entry.getValue();
            if (!bl2 || (entityTypeId = ResourceLocation.m_135820_((String)entityId3)) == null) continue;
            buf.m_130085_(entityTypeId);
        }
        if (Config.enableProgressionSystem) {
            Map dimPts = this.playerRankXPoints.getOrDefault(playerUUID, new HashMap());
            buf.writeInt(dimPts.size());
            for (Map.Entry e : dimPts.entrySet()) {
                Level level;
                String string = (String)e.getKey();
                entityTypeId = ResourceLocation.m_135820_((String)string);
                if (entityTypeId == null) continue;
                buf.m_130085_(entityTypeId);
                buf.writeInt(((Integer)e.getValue()).intValue());
                Long sDay = (Long)((Map)this.playerSReachedDay.getOrDefault(playerUUID, new HashMap())).get(string);
                int daysSinceS = -1;
                if (sDay != null && (level = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    daysSinceS = (int)(PlayerProgressionData.getCurrentDay(sl) - sDay);
                }
                buf.writeInt(daysSinceS);
                int sessions = ((Map)this.playerSessionsSinceS.getOrDefault(playerUUID, new HashMap())).getOrDefault(string, 0);
                buf.writeInt(sessions);
                Map byEntity = this.playerRankXChallengePoints.getOrDefault(playerUUID, new HashMap());
                Map perChallenge = byEntity.getOrDefault(string, Collections.emptyMap());
                buf.writeInt(perChallenge.size());
                for (Map.Entry ch : perChallenge.entrySet()) {
                    buf.m_130070_((String)ch.getKey());
                    buf.writeInt(((Integer)ch.getValue()).intValue());
                }
            }
        }
        Set disabled = this.playerDisabledGlobalBenefits.getOrDefault(playerUUID, Collections.emptySet());
        buf.writeInt(disabled.size());
        for (Integer idx : disabled) {
            if (idx == null) continue;
            buf.writeInt(idx.intValue());
        }
        if ("ranks".equals(Config.progressionSystemType)) {
            ArrayList entries = new ArrayList(ranks.entrySet());
            ArrayList<Map.Entry> esPointsEntries = new ArrayList<Map.Entry>();
            for (Map.Entry entry : entries) {
                EntityType et;
                ResourceLocation entityTypeId4;
                String r = (String)entry.getValue();
                if (RankUtils.compareRanks(r, "S") >= 0 || (entityTypeId4 = ResourceLocation.m_135820_((String)((String)entry.getKey()))) == null || (et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId4)) == null || !"points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(et))) continue;
                esPointsEntries.add(entry);
            }
            buf.writeInt(esPointsEntries.size());
            for (Map.Entry entry : esPointsEntries) {
                String entityId5 = (String)entry.getKey();
                String r = (String)entry.getValue();
                ResourceLocation entityTypeId5 = ResourceLocation.m_135820_((String)entityId5);
                if (entityTypeId5 == null) continue;
                buf.m_130085_(entityTypeId5);
                int curPts = this.playerESPoints.getOrDefault(playerUUID, Collections.emptyMap()).getOrDefault(entityId5, 0);
                int threshold = this.getESThresholdForCurrentStep((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId5), r);
                buf.writeInt(curPts);
                buf.writeInt(threshold);
            }
        }
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_SYNC_CHANNEL, buf);
        if ("kills".equals(Config.progressionSystemType)) {
            LOGGER.debug("Sent progression sync packet to player {} with {} kill count entries", (Object)player.m_7755_().getString(), (Object)killCounts.size());
        } else {
            LOGGER.debug("Sent progression sync packet to player {} with {} kill count entries and {} rank entries", new Object[]{player.m_7755_().getString(), killCounts.size(), ranks.size()});
        }
        LOGGER.debug("Sent progression sync packet with {} newly discovered entities", (Object)newEntities.values().stream().filter(Boolean::booleanValue).count());
    }

    private static boolean isThresholdCrossed(int previousCount, int newCount, int threshold) {
        return previousCount < threshold && newCount >= threshold;
    }

    public boolean hasReachedThreshold(UUID playerUUID, EntityType<?> entityType, int threshold) {
        return this.getKillCount(playerUUID, entityType) >= threshold;
    }

    public boolean shouldShowSpawnLocations(UUID playerUUID, EntityType<?> entityType) {
        if ("kills".equals(Config.progressionSystemType)) {
            return this.hasReachedThreshold(playerUUID, entityType, Config.spawnLocationThreshold);
        }
        return this.meetsRankThreshold(playerUUID, entityType, Config.spawnLocationRank);
    }

    public boolean shouldShowLootIcons(UUID playerUUID, EntityType<?> entityType) {
        if ("kills".equals(Config.progressionSystemType)) {
            return this.hasReachedThreshold(playerUUID, entityType, Config.lootIconThreshold);
        }
        return this.meetsRankThreshold(playerUUID, entityType, Config.lootIconRank);
    }

    public boolean shouldShowLootChances(UUID playerUUID, EntityType<?> entityType) {
        if ("kills".equals(Config.progressionSystemType)) {
            return this.hasReachedThreshold(playerUUID, entityType, Config.lootChanceThreshold);
        }
        return this.meetsRankThreshold(playerUUID, entityType, Config.lootChanceRank);
    }

    public boolean shouldShowAdvancedAttributes(UUID playerUUID, EntityType<?> entityType) {
        if ("kills".equals(Config.progressionSystemType)) {
            return this.hasReachedThreshold(playerUUID, entityType, Config.advancedAttributesThreshold);
        }
        return this.meetsRankThreshold(playerUUID, entityType, Config.advancedAttributesRank);
    }

    public boolean shouldShowDescription(UUID playerUUID, EntityType<?> entityType) {
        if ("kills".equals(Config.progressionSystemType)) {
            return this.hasReachedThreshold(playerUUID, entityType, Config.descriptionThreshold);
        }
        return this.meetsRankThreshold(playerUUID, entityType, Config.descriptionRank);
    }

    public boolean isNewlyDiscovered(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Boolean> perPlayer = this.playerNewEntities.get(playerUUID);
        if (perPlayer == null) {
            return false;
        }
        Boolean val = perPlayer.get(entityId);
        return val != null && val != false;
    }

    public void markAsNewlyDiscovered(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map newEntities = this.playerNewEntities.computeIfAbsent(playerUUID, k -> new HashMap());
        newEntities.put(entityId, true);
        this.m_77762_();
        LOGGER.debug("Marked entity {} as newly discovered for player {}", (Object)entityId, (Object)playerUUID);
    }

    public void markAsViewed(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map newEntities = this.playerNewEntities.computeIfAbsent(playerUUID, k -> new HashMap());
        newEntities.put(entityId, false);
        this.m_77762_();
        LOGGER.debug("Marked entity {} as viewed for player {}", (Object)entityId, (Object)playerUUID);
    }

    public boolean isSpyglassObserved(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Boolean> perPlayer = this.playerSpyglassObservedEntities.get(playerUUID);
        if (perPlayer == null) {
            return false;
        }
        Boolean val = perPlayer.get(entityId);
        return val != null && val != false;
    }

    public void markAsSpyglassObserved(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map spyglassObservedEntities = this.playerSpyglassObservedEntities.computeIfAbsent(playerUUID, k -> new HashMap());
        if (!spyglassObservedEntities.getOrDefault(entityId, false).booleanValue()) {
            spyglassObservedEntities.put(entityId, true);
            this.m_77762_();
            LOGGER.debug("Marked entity {} as spyglass observed for player {}", (Object)entityId, (Object)playerUUID);
        }
    }

    public boolean removeSpyglassObserved(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Boolean> spyglassObservedEntities = this.playerSpyglassObservedEntities.get(playerUUID);
        if (spyglassObservedEntities != null && spyglassObservedEntities.getOrDefault(entityId, false).booleanValue()) {
            spyglassObservedEntities.put(entityId, false);
            this.m_77762_();
            LOGGER.debug("Removed spyglass observed status for entity {} for player {}", (Object)entityId, (Object)playerUUID);
            return true;
        }
        return false;
    }

    public boolean isFullyDiscovered(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Boolean> perPlayer = this.playerFullyDiscoveredEntities.get(playerUUID);
        if (perPlayer == null) {
            return false;
        }
        Boolean val = perPlayer.get(entityId);
        return val != null && val != false;
    }

    public void markAsFullyDiscovered(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map fullyDiscoveredEntities = this.playerFullyDiscoveredEntities.computeIfAbsent(playerUUID, k -> new HashMap());
        if (!fullyDiscoveredEntities.getOrDefault(entityId, false).booleanValue()) {
            fullyDiscoveredEntities.put(entityId, true);
            this.m_77762_();
            LOGGER.debug("Marked entity {} as fully discovered for player {}", (Object)entityId, (Object)playerUUID);
            if (!this.isNewlyDiscovered(playerUUID, entityType) && this.getKillCount(playerUUID, entityType) == 0) {
                this.markAsNewlyDiscovered(playerUUID, entityType);
            }
            if (!this.isSpyglassObserved(playerUUID, entityType)) {
                this.markAsSpyglassObserved(playerUUID, entityType);
            }
        }
    }

    public boolean removeFullyDiscovered(UUID playerUUID, EntityType<?> entityType) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Boolean> fullyDiscoveredEntities = this.playerFullyDiscoveredEntities.get(playerUUID);
        if (fullyDiscoveredEntities != null && fullyDiscoveredEntities.getOrDefault(entityId, false).booleanValue()) {
            fullyDiscoveredEntities.put(entityId, false);
            this.m_77762_();
            LOGGER.debug("Removed fully discovered status for entity {} for player {}", (Object)entityId, (Object)playerUUID);
            return true;
        }
        return false;
    }

    public void resetEntityObservationTicks(UUID playerUUID, UUID entityUUID) {
        Map<UUID, Map<String, Integer>> entityObservationMap = this.playerEntityObservationTicks.get(playerUUID);
        if (entityObservationMap != null) {
            entityObservationMap.remove(entityUUID);
            LOGGER.debug("Reset observation ticks for player {} and entity {}", (Object)playerUUID, (Object)entityUUID);
        }
    }

    public void resetAllObservationTicks(UUID playerUUID) {
        if (this.playerEntityObservationTicks.containsKey(playerUUID)) {
            LOGGER.debug("Reset all observation ticks for player {}", (Object)playerUUID);
            this.playerEntityObservationTicks.remove(playerUUID);
        }
    }

    private boolean hasObservedInstance(UUID playerUUID, EntityType<?> entityType, UUID entityUUID) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map<String, Set<String>> perEntity = this.playerRankXObservedInstances.get(playerUUID);
        if (perEntity == null) {
            return false;
        }
        Set<String> set = perEntity.get(entityId);
        if (set == null) {
            return false;
        }
        return set.contains(entityUUID.toString());
    }

    private void markObservedInstance(UUID playerUUID, EntityType<?> entityType, UUID entityUUID) {
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map perEntity = this.playerRankXObservedInstances.computeIfAbsent(playerUUID, k -> new HashMap());
        Set set = perEntity.computeIfAbsent(entityId, k -> new HashSet());
        if (set.add(entityUUID.toString())) {
            this.m_77762_();
        }
    }

    private boolean isRankXObserveChallengeComplete(UUID playerUUID, EntityType<?> entityType) {
        RankXConfig cfg;
        if (playerUUID == null || entityType == null) {
            return true;
        }
        EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
        RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
        if (cfg == null) {
            return true;
        }
        RankXConfig.Challenge ch = cfg.findChallenge("observe");
        if (ch == null) {
            return true;
        }
        int cap = ch.cap();
        if (cap <= 0) {
            return false;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString();
        Map perPlayer = this.playerRankXChallengePoints.getOrDefault(playerUUID, Collections.emptyMap());
        Map perEntity = perPlayer.getOrDefault(entityId, Collections.emptyMap());
        int awarded = perEntity.getOrDefault("observe", 0);
        return awarded >= cap;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = new CompoundTag();
        CompoundTag killCountsTag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Integer>> entry : this.playerKillCounts.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, Integer> entry2 : entry.getValue().entrySet()) {
                compoundTag.m_128405_(entry2.getKey(), entry2.getValue().intValue());
            }
            killCountsTag.m_128365_(entry.getKey().toString(), (Tag)compoundTag);
        }
        tag.m_128365_("KillCounts", (Tag)killCountsTag);
        CompoundTag ranksTag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, String>> entry : this.playerEntityRanks.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, String> entry3 : entry.getValue().entrySet()) {
                compoundTag.m_128359_(entry3.getKey(), entry3.getValue());
            }
            ranksTag.m_128365_(entry.getKey().toString(), (Tag)compoundTag);
        }
        tag.m_128365_("Ranks", (Tag)ranksTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Boolean>> entry : this.playerNewEntities.entrySet()) {
            CompoundTag compoundTag2 = new CompoundTag();
            for (Map.Entry<String, Boolean> entry4 : entry.getValue().entrySet()) {
                compoundTag2.m_128379_(entry4.getKey(), entry4.getValue().booleanValue());
            }
            compoundTag.m_128365_(entry.getKey().toString(), (Tag)compoundTag2);
        }
        tag.m_128365_("NewEntities", (Tag)compoundTag);
        CompoundTag compoundTag3 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Boolean>> entry : this.playerSpyglassObservedEntities.entrySet()) {
            CompoundTag compoundTag4 = new CompoundTag();
            for (Map.Entry<String, Boolean> entry5 : entry.getValue().entrySet()) {
                compoundTag4.m_128379_(entry5.getKey(), entry5.getValue().booleanValue());
            }
            compoundTag3.m_128365_(entry.getKey().toString(), (Tag)compoundTag4);
        }
        tag.m_128365_("SpyglassObserved", (Tag)compoundTag3);
        CompoundTag compoundTag5 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Boolean>> entry : this.playerFullyDiscoveredEntities.entrySet()) {
            CompoundTag compoundTag6 = new CompoundTag();
            for (Map.Entry<String, Boolean> entry6 : entry.getValue().entrySet()) {
                compoundTag6.m_128379_(entry6.getKey(), entry6.getValue().booleanValue());
            }
            compoundTag5.m_128365_(entry.getKey().toString(), (Tag)compoundTag6);
        }
        tag.m_128365_("FullyDiscovered", (Tag)compoundTag5);
        CompoundTag compoundTag7 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Integer>> entry : this.playerRankXPoints.entrySet()) {
            CompoundTag compoundTag8 = new CompoundTag();
            for (Map.Entry<String, Integer> entry7 : entry.getValue().entrySet()) {
                compoundTag8.m_128405_(entry7.getKey(), entry7.getValue().intValue());
            }
            compoundTag7.m_128365_(entry.getKey().toString(), (Tag)compoundTag8);
        }
        tag.m_128365_("RankXPoints", (Tag)compoundTag7);
        if (!this.playerESPoints.isEmpty()) {
            CompoundTag compoundTag9 = new CompoundTag();
            for (Map.Entry<UUID, Map<String, Integer>> entry : this.playerESPoints.entrySet()) {
                CompoundTag compoundTag10 = new CompoundTag();
                for (Map.Entry<String, Integer> entry8 : entry.getValue().entrySet()) {
                    compoundTag10.m_128405_(entry8.getKey(), entry8.getValue().intValue());
                }
                compoundTag9.m_128365_(entry.getKey().toString(), (Tag)compoundTag10);
            }
            tag.m_128365_("ESPoints", (Tag)compoundTag9);
        }
        CompoundTag compoundTag11 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Map<String, Integer>>> entry : this.playerRankXChallengePoints.entrySet()) {
            CompoundTag compoundTag12 = new CompoundTag();
            for (Map.Entry<String, Map<String, Integer>> entry9 : entry.getValue().entrySet()) {
                CompoundTag compoundTag13 = new CompoundTag();
                for (Map.Entry<String, Integer> entry10 : entry9.getValue().entrySet()) {
                    compoundTag13.m_128405_(entry10.getKey(), entry10.getValue().intValue());
                }
                compoundTag12.m_128365_(entry9.getKey(), (Tag)compoundTag13);
            }
            compoundTag11.m_128365_(entry.getKey().toString(), (Tag)compoundTag12);
        }
        tag.m_128365_("RankXChallengePoints", (Tag)compoundTag11);
        CompoundTag compoundTag14 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Long>> entry : this.playerSReachedDay.entrySet()) {
            CompoundTag compoundTag15 = new CompoundTag();
            for (Map.Entry<String, Long> entry11 : entry.getValue().entrySet()) {
                compoundTag15.m_128356_(entry11.getKey(), entry11.getValue().longValue());
            }
            compoundTag14.m_128365_(entry.getKey().toString(), (Tag)compoundTag15);
        }
        tag.m_128365_("SReachedDay", (Tag)compoundTag14);
        CompoundTag compoundTag16 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Integer>> entry : this.playerSessionsSinceS.entrySet()) {
            CompoundTag compoundTag17 = new CompoundTag();
            for (Map.Entry<String, Integer> entry12 : entry.getValue().entrySet()) {
                compoundTag17.m_128405_(entry12.getKey(), entry12.getValue().intValue());
            }
            compoundTag16.m_128365_(entry.getKey().toString(), (Tag)compoundTag17);
        }
        tag.m_128365_("SessionsSinceS", (Tag)compoundTag16);
        CompoundTag compoundTag18 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Long>> entry : this.playerLastSessionDay.entrySet()) {
            CompoundTag compoundTag19 = new CompoundTag();
            for (Map.Entry<String, Long> entry13 : entry.getValue().entrySet()) {
                compoundTag19.m_128356_(entry13.getKey(), entry13.getValue().longValue());
            }
            compoundTag18.m_128365_(entry.getKey().toString(), (Tag)compoundTag19);
        }
        tag.m_128365_("LastSessionDay", (Tag)compoundTag18);
        CompoundTag compoundTag20 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Set<String>>> entry : this.playerBiomesSeenForEntity.entrySet()) {
            CompoundTag compoundTag21 = new CompoundTag();
            for (Map.Entry<String, Set<String>> entry14 : entry.getValue().entrySet()) {
                ListTag listTag = new ListTag();
                for (String biomeId : entry14.getValue()) {
                    listTag.add((Object)StringTag.m_129297_((String)biomeId));
                }
                compoundTag21.m_128365_(entry14.getKey(), (Tag)listTag);
            }
            compoundTag20.m_128365_(entry.getKey().toString(), (Tag)compoundTag21);
        }
        tag.m_128365_("BiomesSeenForEntity", (Tag)compoundTag20);
        CompoundTag compoundTag22 = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Set<String>>> entry : this.playerRankXObservedInstances.entrySet()) {
            CompoundTag compoundTag23 = new CompoundTag();
            for (Map.Entry<String, Set<String>> entry15 : entry.getValue().entrySet()) {
                ListTag list = new ListTag();
                for (String uuidStr : entry15.getValue()) {
                    list.add((Object)StringTag.m_129297_((String)uuidStr));
                }
                compoundTag23.m_128365_(entry15.getKey(), (Tag)list);
            }
            compoundTag22.m_128365_(entry.getKey().toString(), (Tag)compoundTag23);
        }
        tag.m_128365_("RankXObservedInstances", (Tag)compoundTag22);
        if (!this.playerGlobalBenefitIndex.isEmpty()) {
            CompoundTag compoundTag24 = new CompoundTag();
            for (Map.Entry<UUID, Integer> entry : this.playerGlobalBenefitIndex.entrySet()) {
                compoundTag24.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
            }
            tag.m_128365_("GlobalBenefitIndex", (Tag)compoundTag24);
        }
        if (!this.playerDisabledGlobalBenefits.isEmpty()) {
            CompoundTag compoundTag25 = new CompoundTag();
            for (Map.Entry<UUID, Set<Integer>> entry : this.playerDisabledGlobalBenefits.entrySet()) {
                ListTag listTag = new ListTag();
                for (Integer idx : entry.getValue()) {
                    if (idx == null) continue;
                    listTag.add((Object)IntTag.m_128679_((int)idx));
                }
                compoundTag25.m_128365_(entry.getKey().toString(), (Tag)listTag);
            }
            tag.m_128365_("GlobalBenefitDisabled", (Tag)compoundTag25);
        }
        return tag;
    }

    public static PlayerProgressionData load(CompoundTag tag) {
        HashSet<String> set;
        ListTag list;
        HashMap<String, Cloneable> perEntityMap;
        CompoundTag perPlayer;
        CompoundTag root;
        HashMap<String, Number> map;
        CompoundTag playerTag;
        UUID playerUUID;
        PlayerProgressionData data = new PlayerProgressionData();
        if (tag.m_128441_("KillCounts")) {
            CompoundTag killCountsTag = tag.m_128469_("KillCounts");
            for (String playerUUIDString : killCountsTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = killCountsTag.m_128469_(playerUUIDString);
                    killCounts = new HashMap<String, Integer>();
                    for (String entityId : playerTag.m_128431_()) {
                        killCounts.put(entityId, playerTag.m_128451_(entityId));
                    }
                    data.playerKillCounts.put(playerUUID, killCounts);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in player kill counts data: {}", (Object)playerUUIDString);
                }
            }
        } else if (tag.m_128441_("Players")) {
            CompoundTag playersTag = tag.m_128469_("Players");
            for (String playerUUIDString : playersTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = playersTag.m_128469_(playerUUIDString);
                    killCounts = new HashMap();
                    for (String entityId : playerTag.m_128431_()) {
                        killCounts.put(entityId, playerTag.m_128451_(entityId));
                    }
                    data.playerKillCounts.put(playerUUID, killCounts);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in legacy player progression data: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("Ranks")) {
            CompoundTag ranksTag = tag.m_128469_("Ranks");
            for (String playerUUIDString : ranksTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = ranksTag.m_128469_(playerUUIDString);
                    HashMap<String, String> ranks = new HashMap<String, String>();
                    for (String entityId : playerTag.m_128431_()) {
                        ranks.put(entityId, playerTag.m_128461_(entityId));
                    }
                    data.playerEntityRanks.put(playerUUID, ranks);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in player ranks data: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("NewEntities")) {
            CompoundTag newEntitiesTag = tag.m_128469_("NewEntities");
            for (String playerUUIDString : newEntitiesTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = newEntitiesTag.m_128469_(playerUUIDString);
                    HashMap<String, Boolean> newEntities = new HashMap<String, Boolean>();
                    for (String entityId : playerTag.m_128431_()) {
                        newEntities.put(entityId, playerTag.m_128471_(entityId));
                    }
                    data.playerNewEntities.put(playerUUID, newEntities);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in player new entities data: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("SpyglassObserved")) {
            CompoundTag spyglassObservedTag = tag.m_128469_("SpyglassObserved");
            for (String playerUUIDString : spyglassObservedTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = spyglassObservedTag.m_128469_(playerUUIDString);
                    HashMap<String, Boolean> spyglassObserved = new HashMap<String, Boolean>();
                    for (String entityId : playerTag.m_128431_()) {
                        spyglassObserved.put(entityId, playerTag.m_128471_(entityId));
                    }
                    data.playerSpyglassObservedEntities.put(playerUUID, spyglassObserved);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in player spyglass observed entities data: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("FullyDiscovered")) {
            CompoundTag fullyDiscoveredTag = tag.m_128469_("FullyDiscovered");
            for (String playerUUIDString : fullyDiscoveredTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = fullyDiscoveredTag.m_128469_(playerUUIDString);
                    HashMap<String, Boolean> fullyDiscovered = new HashMap<String, Boolean>();
                    for (String entityId : playerTag.m_128431_()) {
                        fullyDiscovered.put(entityId, playerTag.m_128471_(entityId));
                    }
                    data.playerFullyDiscoveredEntities.put(playerUUID, fullyDiscovered);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in player fully discovered entities data: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("RankXPoints")) {
            CompoundTag pointsTag = tag.m_128469_("RankXPoints");
            for (String playerUUIDString : pointsTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = pointsTag.m_128469_(playerUUIDString);
                    map = new HashMap<String, Number>();
                    for (String entityId : playerTag.m_128431_()) {
                        map.put(entityId, playerTag.m_128451_(entityId));
                    }
                    data.playerRankXPoints.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in RankXPoints: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("ESPoints")) {
            root = tag.m_128469_("ESPoints");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = root.m_128469_(playerUUIDString);
                    map = new HashMap();
                    for (String entityId : playerTag.m_128431_()) {
                        map.put(entityId, playerTag.m_128451_(entityId));
                    }
                    data.playerESPoints.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in ESPoints: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("RankXChallengePoints")) {
            root = tag.m_128469_("RankXChallengePoints");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    perPlayer = root.m_128469_(playerUUIDString);
                    perEntityMap = new HashMap<String, Cloneable>();
                    for (String entityId : perPlayer.m_128431_()) {
                        CompoundTag perEntityTag = perPlayer.m_128469_(entityId);
                        HashMap<String, Integer> perChallenge = new HashMap<String, Integer>();
                        for (String challengeId : perEntityTag.m_128431_()) {
                            perChallenge.put(challengeId, perEntityTag.m_128451_(challengeId));
                        }
                        perEntityMap.put(entityId, perChallenge);
                    }
                    data.playerRankXChallengePoints.put(playerUUID, perEntityMap);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in RankXChallengePoints: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("SReachedDay")) {
            root = tag.m_128469_("SReachedDay");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = root.m_128469_(playerUUIDString);
                    map = new HashMap();
                    for (String entityId : playerTag.m_128431_()) {
                        map.put(entityId, playerTag.m_128454_(entityId));
                    }
                    data.playerSReachedDay.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in SReachedDay: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("SessionsSinceS")) {
            root = tag.m_128469_("SessionsSinceS");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = root.m_128469_(playerUUIDString);
                    map = new HashMap();
                    for (String entityId : playerTag.m_128431_()) {
                        map.put(entityId, playerTag.m_128451_(entityId));
                    }
                    data.playerSessionsSinceS.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in SessionsSinceS: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("LastSessionDay")) {
            root = tag.m_128469_("LastSessionDay");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    playerTag = root.m_128469_(playerUUIDString);
                    map = new HashMap();
                    for (String entityId : playerTag.m_128431_()) {
                        map.put(entityId, playerTag.m_128454_(entityId));
                    }
                    data.playerLastSessionDay.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in LastSessionDay: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("BiomesSeenForEntity")) {
            root = tag.m_128469_("BiomesSeenForEntity");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    perPlayer = root.m_128469_(playerUUIDString);
                    perEntityMap = new HashMap();
                    for (String entityId : perPlayer.m_128431_()) {
                        list = perPlayer.m_128437_(entityId, 8);
                        set = new HashSet<String>();
                        for (int i = 0; i < list.size(); ++i) {
                            set.add(list.m_128778_(i));
                        }
                        perEntityMap.put(entityId, set);
                    }
                    data.playerBiomesSeenForEntity.put(playerUUID, perEntityMap);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in BiomesSeenForEntity: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("RankXObservedInstances")) {
            root = tag.m_128469_("RankXObservedInstances");
            for (String playerUUIDString : root.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    perPlayer = root.m_128469_(playerUUIDString);
                    perEntityMap = new HashMap();
                    for (String entityId : perPlayer.m_128431_()) {
                        list = perPlayer.m_128437_(entityId, 8);
                        set = new HashSet();
                        for (int i = 0; i < list.size(); ++i) {
                            set.add(list.m_128778_(i));
                        }
                        perEntityMap.put(entityId, set);
                    }
                    data.playerRankXObservedInstances.put(playerUUID, perEntityMap);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in RankXObservedInstances: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("GlobalBenefitIndex")) {
            CompoundTag gbTag = tag.m_128469_("GlobalBenefitIndex");
            for (String playerUUIDString : gbTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    int idx = gbTag.m_128451_(playerUUIDString);
                    data.playerGlobalBenefitIndex.put(playerUUID, idx);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in GlobalBenefitIndex: {}", (Object)playerUUIDString);
                }
            }
        }
        if (tag.m_128441_("GlobalBenefitDisabled")) {
            CompoundTag gbdTag = tag.m_128469_("GlobalBenefitDisabled");
            for (String playerUUIDString : gbdTag.m_128431_()) {
                try {
                    playerUUID = UUID.fromString(playerUUIDString);
                    ListTag list2 = gbdTag.m_128437_(playerUUIDString, 3);
                    HashSet<Integer> set2 = new HashSet<Integer>();
                    for (int i = 0; i < list2.size(); ++i) {
                        set2.add(list2.m_128763_(i));
                    }
                    data.playerDisabledGlobalBenefits.put(playerUUID, set2);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in GlobalBenefitDisabled: {}", (Object)playerUUIDString);
                }
            }
        }
        return data;
    }

    public static PlayerProgressionData getOrCreate(ServerLevel level) {
        return GlobalPlayerProgressionData.get(level.m_7654_()).data();
    }

    public static void sendProgressionSyncPacketFromAllDimensions(ServerPlayer player, MinecraftServer server) {
        GlobalPlayerProgressionData.get(server).data().sendProgressionSyncPacket(player);
        LOGGER.info("Sent global progression sync packet to player {}", (Object)player.m_7755_().getString());
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Entity deadLevel;
        if (!Config.enableProgressionSystem) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer deadPlayer = (ServerPlayer)livingEntity;
            deadLevel = (ServerLevel)deadPlayer.m_9236_();
            PlayerProgressionData deadData = PlayerProgressionData.getOrCreate((ServerLevel)deadLevel);
            deadData.playerEliteStreakCounts.remove(deadPlayer.m_20148_());
        }
        if ((deadLevel = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)deadLevel;
            if (event.getEntity() != null) {
                String previousRank;
                EntityType entityType = event.getEntity().m_6095_();
                ServerLevel level = (ServerLevel)player.m_9236_();
                if (!EntityDataProvider.shouldTrackProgression(entityType)) {
                    return;
                }
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                UUID playerUUID = player.m_20148_();
                int previousCount = data.getKillCount(playerUUID, entityType);
                String originalRankBeforeProgress = previousRank = data.getRank(playerUUID, entityType);
                int newCount = data.incrementKillCount(playerUUID, entityType);
                String newRank = previousRank;
                if ("ranks".equals(Config.progressionSystemType)) {
                    if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
                        int base = BestiaryAttributeManager.getEffectiveESValue(entityType, "kill");
                        data.addESPoints(player, entityType, base, (Entity)event.getEntity(), "kill");
                        newRank = data.getRank(playerUUID, entityType);
                        data.markSReachedIfNewAll(level, playerUUID, entityType, previousRank, newRank);
                        previousRank = newRank;
                    } else {
                        LOGGER.debug("Before tryIncreaseRank - Player: {}, Entity: {}, Previous Rank: {}", new Object[]{player.m_7755_().getString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType), previousRank});
                        newRank = data.tryIncreaseRank(playerUUID, entityType, Config.rankKillChance, (Entity)event.getEntity());
                        LOGGER.debug("After tryIncreaseRank - Player: {}, Entity: {}, New Rank: {}", new Object[]{player.m_7755_().getString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType), newRank});
                        data.markSReachedIfNewAll(level, playerUUID, entityType, previousRank, newRank);
                    }
                }
                LOGGER.debug("Player {} killed entity {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                data.recordBiomeSeen(player, entityType);
                LivingEntity victim = event.getEntity();
                data.evaluateRankXKillChallenges(player, victim);
                boolean isFirstKill = previousCount == 0 && newCount == 1;
                boolean rankIncreased = !previousRank.equals(newRank);
                boolean thresholdCrossed = false;
                if ("kills".equals(Config.progressionSystemType)) {
                    boolean bl = thresholdCrossed = PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.spawnLocationThreshold) || PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.lootIconThreshold) || PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.advancedAttributesThreshold) || PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.lootChanceThreshold) || PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.descriptionThreshold);
                }
                if (isFirstKill) {
                    if ("ranks".equals(Config.progressionSystemType) && originalRankBeforeProgress.equals("") || "kills".equals(Config.progressionSystemType)) {
                        data.markAsNewlyDiscovered(playerUUID, entityType);
                        LOGGER.debug("Marked entity {} as newly discovered for player {} (global)", (Object)entityType.m_20675_(), (Object)player.m_7755_().getString());
                        PlayerProgressionData.sendDiscoveryToastNotification(player, entityType);
                        data.sendProgressionUpdatePacket(player, entityType, newCount, newRank);
                    }
                } else if (thresholdCrossed) {
                    PlayerProgressionData.checkAndShowToastNotifications(player, entityType, previousCount, newCount);
                } else if (rankIncreased) {
                    PlayerProgressionData.sendRankIncreaseToastNotification(player, entityType, previousRank, newRank);
                } else {
                    data.sendProgressionUpdatePacket(player, entityType, newCount, newRank);
                }
            }
        }
    }

    private static void sendRankIncreaseToastNotification(ServerPlayer player, EntityType<?> entityType, String oldRank, String newRank) {
        LOGGER.info("Player {} increased rank for entity {} from {} to {}", new Object[]{player.m_7755_().getString(), ForgeRegistries.ENTITY_TYPES.getKey(entityType), oldRank, newRank});
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(-1);
        buf.m_130070_(oldRank);
        buf.m_130070_(newRank);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            PlayerProgressionData data;
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            MinecraftServer server = level.m_7654_();
            LOGGER.debug("Player {} logged in, sending progression sync packet with data from all dimensions", (Object)player2.m_7755_().getString());
            PlayerProgressionData.backfillSReachedDayIfMissing(player2);
            if (server != null) {
                PlayerProgressionData.sendProgressionSyncPacketFromAllDimensions(player2, server);
            } else {
                LOGGER.warn("Server not available, falling back to single dimension processing");
                data = PlayerProgressionData.getOrCreate(level);
                data.sendProgressionSyncPacket(player2);
            }
            if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                try {
                    data = PlayerProgressionData.getOrCreate(level);
                    for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                        try {
                            EntityAttributes attrs;
                            if (!BestiaryAttributeManager.hasAttributesForEntity(et) || (attrs = BestiaryAttributeManager.getAttributesForEntity(et)) == null || attrs.rankX() == null) continue;
                            data.evaluateRankXUnlock(player2, et);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Rank-X re-evaluation on login failed: {}", (Object)ex.getMessage());
                }
            }
            try {
                data = PlayerProgressionData.getOrCreate(level);
                data.reconcileGlobalBenefitsForPlayer(player2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            PlayerProgressionData data;
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            MinecraftServer server = level.m_7654_();
            LOGGER.debug("Player {} changed dimension from {} to {}, syncing progression data from all dimensions", new Object[]{player2.m_7755_().getString(), event.getFrom().m_135782_(), event.getTo().m_135782_()});
            if (server != null) {
                PlayerProgressionData.backfillSReachedDayIfMissing(player2);
                PlayerProgressionData.sendProgressionSyncPacketFromAllDimensions(player2, server);
            } else {
                LOGGER.warn("Server not available, falling back to single dimension processing");
                data = PlayerProgressionData.getOrCreate(level);
                data.sendProgressionSyncPacket(player2);
            }
            LOGGER.debug("Progression data sync completed for player {} after dimension change", (Object)player2.m_7755_().getString());
            if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                try {
                    data = PlayerProgressionData.getOrCreate(level);
                    for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                        try {
                            EntityAttributes attrs;
                            if (!BestiaryAttributeManager.hasAttributesForEntity(et) || (attrs = BestiaryAttributeManager.getAttributesForEntity(et)) == null || attrs.rankX() == null) continue;
                            data.evaluateRankXUnlock(player2, et);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Rank-X re-evaluation on dimension change failed: {}", (Object)ex.getMessage());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeGameMode(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                ServerLevel level = (ServerLevel)player2.m_9236_();
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                data.reconcileGlobalBenefitsForPlayer(player2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
            LOGGER.debug("Player {} logged out, saving progression data", (Object)player2.m_7755_().getString());
            data.m_77762_();
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)player;
                EntityType entityType = target.m_6095_();
                ServerLevel level = (ServerLevel)player2.m_9236_();
                if (!EntityDataProvider.shouldTrackProgression(entityType)) {
                    return;
                }
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                UUID playerUUID = player2.m_20148_();
                String previousRank = data.getRank(playerUUID, entityType);
                if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
                    if (!previousRank.equals("")) {
                        data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "hit"), (Entity)target, "hit");
                    }
                    data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
                } else {
                    boolean rankIncreased;
                    String newRank = data.tryIncreaseRank(playerUUID, entityType, Config.rankHitChance, (Entity)target, true);
                    data.markSReachedIfNewAll(level, playerUUID, entityType, previousRank, newRank);
                    boolean bl = rankIncreased = !previousRank.equals(newRank);
                    if (previousRank.equals("") && rankIncreased) {
                        data.markAsNewlyDiscovered(playerUUID, entityType);
                        LOGGER.debug("Marked entity {} as newly discovered for player {} (global)", (Object)entityType.m_20675_(), (Object)player2.m_7755_().getString());
                        PlayerProgressionData.sendDiscoveryToastNotification(player2, entityType);
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                    } else if (rankIncreased) {
                        PlayerProgressionData.sendRankIncreaseToastNotification(player2, entityType, previousRank, newRank);
                    } else {
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ItemStack itemStack;
            Animal animal;
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof Animal && (animal = (Animal)player).m_6898_(itemStack = event.getItemStack())) {
                EntityType entityType = animal.m_6095_();
                ServerLevel level = (ServerLevel)player2.m_9236_();
                if (!EntityDataProvider.shouldTrackProgression(entityType)) {
                    return;
                }
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                UUID playerUUID = player2.m_20148_();
                String previousRank = data.getRank(playerUUID, entityType);
                if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
                    data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "feed"), (Entity)animal, "feed");
                    data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
                } else {
                    boolean rankIncreased;
                    String newRank = data.tryIncreaseRank(playerUUID, entityType, Config.rankFeedChance, (Entity)animal);
                    data.markSReachedIfNewAll(level, playerUUID, entityType, previousRank, newRank);
                    boolean bl = rankIncreased = !previousRank.equals(newRank);
                    if (previousRank.equals("") && rankIncreased) {
                        data.markAsNewlyDiscovered(playerUUID, entityType);
                        LOGGER.debug("Marked entity {} as newly discovered for player {} (global)", (Object)entityType.m_20675_(), (Object)player2.m_7755_().getString());
                        PlayerProgressionData.sendDiscoveryToastNotification(player2, entityType);
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                    } else if (rankIncreased) {
                        PlayerProgressionData.sendRankIncreaseToastNotification(player2, entityType, previousRank, newRank);
                    } else {
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTradeWithVillager(TradeWithVillagerEvent event) {
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EntityType entityType = event.getAbstractVillager().m_6095_();
            LOGGER.debug("Player {} traded with entity {}", (Object)player2.m_7755_().getString(), (Object)event.getAbstractVillager().m_6095_());
            ServerLevel level = (ServerLevel)player2.m_9236_();
            if (!EntityDataProvider.shouldTrackProgression(entityType)) {
                return;
            }
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
            UUID playerUUID = player2.m_20148_();
            String previousRank = data.getRank(playerUUID, entityType);
            if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
                data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "trade"), (Entity)event.getAbstractVillager(), "trade");
                data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
            } else {
                boolean rankIncreased;
                String newRank = data.tryIncreaseRank(playerUUID, entityType, Config.rankTradeChance);
                data.markSReachedIfNewAll(level, playerUUID, entityType, previousRank, newRank);
                boolean bl = rankIncreased = !previousRank.equals(newRank);
                if (previousRank.equals("") && rankIncreased) {
                    data.markAsNewlyDiscovered(playerUUID, entityType);
                    LOGGER.debug("Marked entity {} as newly discovered for player {} (global)", (Object)entityType.m_20675_(), (Object)player2.m_7755_().getString());
                    PlayerProgressionData.sendDiscoveryToastNotification(player2, entityType);
                    data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                } else if (rankIncreased) {
                    PlayerProgressionData.sendRankIncreaseToastNotification(player2, entityType, previousRank, newRank);
                } else {
                    data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), newRank);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        Player player = event.getCausedByPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (event.getChild() == null) {
            return;
        }
        EntityType entityType = event.getChild().m_6095_();
        if (!EntityDataProvider.shouldTrackProgression(entityType)) {
            return;
        }
        ServerLevel level = (ServerLevel)player2.m_9236_();
        PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
        UUID playerUUID = player2.m_20148_();
        String previousRank = data.getRank(playerUUID, entityType);
        if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
            data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "breed"), (Entity)event.getChild(), "breed");
            data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
        }
    }

    @SubscribeEvent
    public static void onAnimalTame(AnimalTameEvent event) {
        if (!Config.enableProgressionSystem) {
            return;
        }
        if (!"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        Player player = event.getTamer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (event.getAnimal() == null) {
            return;
        }
        EntityType entityType = event.getAnimal().m_6095_();
        if (!EntityDataProvider.shouldTrackProgression(entityType)) {
            return;
        }
        ServerLevel level = (ServerLevel)player2.m_9236_();
        PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
        UUID playerUUID = player2.m_20148_();
        String previousRank = data.getRank(playerUUID, entityType);
        if ("points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(previousRank, "S") < 0) {
            data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "tame"), (Entity)event.getAnimal(), "tame");
            data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping, ensuring global progression data is saved");
        try {
            GlobalPlayerProgressionData global = GlobalPlayerProgressionData.get(event.getServer());
            if (global != null) {
                global.m_77762_();
                LOGGER.info("Marked global progression data as dirty for saving");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to mark global progression data dirty on server stop: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AABB searchBox;
        Vec3 end;
        EntityHitResult entityResult;
        double maxDist;
        boolean isScoping;
        Player player;
        if (event.phase != TickEvent.Phase.END || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!Config.enableProgressionSystem) {
            return;
        }
        try {
            if ("ranks".equals(Config.progressionSystemType)) {
                ServerLevel lvl = (ServerLevel)player2.m_9236_();
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(lvl);
                UUID puid = player2.m_20148_();
                long currentDay = PlayerProgressionData.getCurrentDay(lvl);
                Long lastEval = data.playerLastRankXEvalDay.get(puid);
                if (lastEval == null || lastEval != currentDay) {
                    Map<String, Integer> rx;
                    boolean hasRxProgress;
                    data.playerLastRankXEvalDay.put(puid, currentDay);
                    boolean hasSOrHigher = false;
                    Map<String, String> ranks = data.playerEntityRanks.get(puid);
                    if (ranks != null && !ranks.isEmpty()) {
                        for (String r : ranks.values()) {
                            if (RankUtils.compareRanks(r, "S") < 0) continue;
                            hasSOrHigher = true;
                            break;
                        }
                    }
                    boolean bl = hasRxProgress = (rx = data.playerRankXPoints.get(puid)) != null && !rx.isEmpty();
                    if (hasSOrHigher || hasRxProgress) {
                        for (EntityType et : ForgeRegistries.ENTITY_TYPES) {
                            try {
                                EntityAttributes attrs;
                                if (!BestiaryAttributeManager.hasAttributesForEntity(et) || (attrs = BestiaryAttributeManager.getAttributesForEntity(et)) == null || attrs.rankX() == null) continue;
                                data.evaluateRankXUnlock(player2, et);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Daily Rank-X re-evaluation failed: {}", (Object)ex.getMessage());
        }
        PlayerProgressionData dataGate = PlayerProgressionData.getOrCreate((ServerLevel)player2.m_9236_());
        boolean inferredScoping = player2.m_6117_() && player2.m_21211_().m_150930_(Items.f_151059_);
        boolean clientHeartbeatScoping = dataGate.isClientScopingActive(player2, 10);
        boolean bl = isScoping = inferredScoping || clientHeartbeatScoping;
        if (!isScoping) {
            UUID playerUUID = player2.m_20148_();
            dataGate.resetAllObservationTicks(playerUUID);
            return;
        }
        Vec3 eyePos = player2.m_146892_();
        Vec3 lookVec = player2.m_20252_(1.0f);
        Vec3 rayEnd = eyePos.m_82549_(lookVec.m_82490_(100.0));
        BlockHitResult hitResult = player2.m_9236_().m_45547_(new ClipContext(eyePos, rayEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player2));
        double blockDistance = Double.MAX_VALUE;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            blockDistance = hitResult.m_82450_().m_82554_(eyePos);
        }
        if ((maxDist = Math.min(100.0, blockDistance)) == Double.MAX_VALUE) {
            maxDist = 100.0;
        }
        if ((entityResult = ProjectileUtil.m_37287_((Entity)player2, (Vec3)eyePos, (Vec3)(end = eyePos.m_82549_(lookVec.m_82490_(maxDist))), (AABB)(searchBox = player2.m_20191_().m_82369_(lookVec.m_82490_(maxDist)).m_82400_(1.0)), e -> e instanceof LivingEntity && e != player2 && e.m_6087_(), (double)(maxDist * maxDist))) != null) {
            hitResult = entityResult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity targetEntity = entityHitResult.m_82443_();
            if (targetEntity instanceof LivingEntity) {
                boolean allowRepeatObserve;
                boolean hasRank;
                EntityType entityType = targetEntity.m_6095_();
                ServerLevel level = (ServerLevel)player2.m_9236_();
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                UUID playerUUID = player2.m_20148_();
                UUID entityUUID = targetEntity.m_20148_();
                String entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString();
                if (!EntityDataProvider.shouldTrackProgression(entityType)) {
                    data.resetEntityObservationTicks(playerUUID, entityUUID);
                    return;
                }
                boolean alreadyObserved = data.isSpyglassObserved(playerUUID, entityType);
                int killCount = data.getKillCount(playerUUID, entityType);
                String rank = data.getRank(playerUUID, entityType);
                boolean hasKills = killCount > 0;
                boolean bl2 = hasRank = !rank.equals("") && !rank.equals("");
                if ("ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(rank, "X") >= 0) {
                    data.resetEntityObservationTicks(playerUUID, entityUUID);
                    return;
                }
                boolean bl3 = allowRepeatObserve = "ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(rank, "S") >= 0 && RankUtils.compareRanks(rank, "X") < 0;
                if (!alreadyObserved || allowRepeatObserve) {
                    int maxProgressTicks;
                    Map entityObservationMap = data.playerEntityObservationTicks.computeIfAbsent(playerUUID, k -> new HashMap());
                    Map observationTicks = entityObservationMap.computeIfAbsent(entityUUID, k -> new HashMap());
                    int currentTicks = observationTicks.getOrDefault(entityId, 0);
                    observationTicks.put(entityId, ++currentTicks);
                    int observationTickThreshold = 40;
                    int fullDiscoveryTickThreshold = "sighting".equals(Config.progressionSystemType) ? observationTickThreshold : 100;
                    int n = maxProgressTicks = "sighting".equals(Config.progressionSystemType) ? 1 : fullDiscoveryTickThreshold;
                    if (!data.hasObservedInstance(playerUUID, entityType, entityUUID)) {
                        data.sendScanningProgressPacket(player2, entityType, currentTicks, maxProgressTicks);
                    }
                    if (LOGGER.isDebugEnabled() && currentTicks % 20 == 0) {
                        LOGGER.debug("Player {} has been looking at entity {} for {} ticks", new Object[]{player2.m_7755_().getString(), entityId, currentTicks});
                    }
                    if (currentTicks >= fullDiscoveryTickThreshold && "sighting".equals(Config.progressionSystemType)) {
                        data.markAsFullyDiscovered(playerUUID, entityType);
                        LOGGER.debug("Marked entity {} as fully discovered for player {} (global)", (Object)entityType.m_20675_(), (Object)player2.m_7755_().getString());
                        if (!data.hasObservedInstance(playerUUID, entityType, entityUUID)) {
                            if (!data.isSJustReachedThisTick((ServerLevel)player2.m_9236_(), playerUUID, entityType)) {
                                data.markObservedInstance(playerUUID, entityType, entityUUID);
                                data.awardRankXChallenge(player2, entityType, "observe");
                                data.recordBiomeSeen(player2, entityType);
                            } else {
                                LOGGER.debug("[RankX] Suppressing observe award/mark during S-transition tick for {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                            }
                        }
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
                        data.sendScanningProgressPacket(player2, entityType, fullDiscoveryTickThreshold, fullDiscoveryTickThreshold, true);
                        data.markObservedBeforeFight(player2, entityType);
                        PlayerProgressionData.sendFullDiscoveryToastNotification(player2, entityType);
                        observationTicks.remove(entityId);
                        LOGGER.info("Player {} successfully fully discovered entity {} with mob category {} with a spyglass", new Object[]{player2.m_7755_().getString(), entityId, entityType.m_20674_().m_21607_()});
                    } else if (currentTicks >= observationTickThreshold && !"sighting".equals(Config.progressionSystemType)) {
                        String curRankES;
                        data.markAsSpyglassObserved(playerUUID, entityType);
                        LOGGER.debug("Marked entity {} as spyglass observed for player {} (global)", (Object)entityType.m_20675_(), (Object)player2.m_7755_().getString());
                        data.markObservedBeforeFight(player2, entityType);
                        if (!data.hasObservedInstance(playerUUID, entityType, entityUUID)) {
                            if (!data.isSJustReachedThisTick((ServerLevel)player2.m_9236_(), playerUUID, entityType)) {
                                data.markObservedInstance(playerUUID, entityType, entityUUID);
                                data.awardRankXChallenge(player2, entityType, "observe");
                                data.recordBiomeSeen(player2, entityType);
                            } else {
                                LOGGER.debug("[RankX] Suppressing observe award/mark during S-transition tick for {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                            }
                        }
                        if ("ranks".equals(Config.progressionSystemType) && "points".equalsIgnoreCase(BestiaryAttributeManager.getEffectiveESMode(entityType)) && RankUtils.compareRanks(curRankES = data.getRank(playerUUID, entityType), "S") < 0) {
                            data.addESPoints(player2, entityType, BestiaryAttributeManager.getEffectiveESValue(entityType, "observe"), targetEntity, "observe");
                        }
                        data.sendProgressionUpdatePacket(player2, entityType, data.getKillCount(playerUUID, entityType), data.getRank(playerUUID, entityType));
                        data.sendScanningProgressPacket(player2, entityType, observationTickThreshold, observationTickThreshold, true);
                        PlayerProgressionData.sendObservationToastNotification(player2, entityType);
                        observationTicks.remove(entityId);
                        LOGGER.info("Player {} successfully observed entity {} with mob category {} with a spyglass", new Object[]{player2.m_7755_().getString(), entityId, entityType.m_20674_().m_21607_()});
                    }
                }
            }
        } else {
            PlayerProgressionData data = PlayerProgressionData.getOrCreate((ServerLevel)player2.m_9236_());
            UUID playerUUID = player2.m_20148_();
            data.resetAllObservationTicks(playerUUID);
        }
    }

    private static void sendDiscoveryToastNotification(ServerPlayer player, EntityType<?> entityType) {
        LOGGER.info("Player {} discovered entity {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(1);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
    }

    private static void sendObservationToastNotification(ServerPlayer player, EntityType<?> entityType) {
        LOGGER.debug("Player {} observed entity {} with a spyglass", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(-2);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
    }

    private static void sendFullDiscoveryToastNotification(ServerPlayer player, EntityType<?> entityType) {
        LOGGER.info("Player {} fully discovered entity {} with a spyglass", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        buf.writeInt(-3);
        ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
    }

    private static void checkAndShowToastNotifications(ServerPlayer player, EntityType<?> entityType, int previousCount, int newCount) {
        int highestThreshold = 0;
        if (PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.lootChanceThreshold)) {
            highestThreshold = Config.lootChanceThreshold;
            LOGGER.info("Player {} reached loot chance threshold for {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        } else if (PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.lootIconThreshold)) {
            highestThreshold = Config.lootIconThreshold;
            LOGGER.info("Player {} reached loot icon threshold for {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        } else if (PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.descriptionThreshold)) {
            highestThreshold = Config.descriptionThreshold;
            LOGGER.info("Player {} reached description threshold for {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        } else if (PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.advancedAttributesThreshold)) {
            highestThreshold = Config.advancedAttributesThreshold;
            LOGGER.info("Player {} reached advanced attributes threshold for {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        } else if (PlayerProgressionData.isThresholdCrossed(previousCount, newCount, Config.spawnLocationThreshold)) {
            highestThreshold = Config.spawnLocationThreshold;
            LOGGER.info("Player {} reached spawn location threshold for {}", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        }
        if (highestThreshold > 0) {
            if (highestThreshold == Config.descriptionThreshold) {
                LOGGER.debug("Sending DESCRIPTION threshold toast packet (threshold={}) for entity {}", (Object)highestThreshold, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            } else if (highestThreshold == Config.spawnLocationThreshold) {
                LOGGER.debug("Sending SPAWN LOCATION threshold toast packet (threshold={}) for entity {}", (Object)highestThreshold, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            } else if (highestThreshold == Config.lootIconThreshold) {
                LOGGER.debug("Sending LOOT ICON threshold toast packet (threshold={}) for entity {}", (Object)highestThreshold, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            } else if (highestThreshold == Config.advancedAttributesThreshold) {
                LOGGER.debug("Sending ADVANCED ATTRIBUTES threshold toast packet (threshold={}) for entity {}", (Object)highestThreshold, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            } else if (highestThreshold == Config.lootChanceThreshold) {
                LOGGER.debug("Sending LOOT CHANCE threshold toast packet (threshold={}) for entity {}", (Object)highestThreshold, (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            }
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            buf.writeInt(highestThreshold);
            ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
            LOGGER.debug("Sent toast packet with channel {} for entity {} with threshold {}", new Object[]{CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, ForgeRegistries.ENTITY_TYPES.getKey(entityType), highestThreshold});
        }
    }

    public void evaluateRankXKillChallenges(ServerPlayer player, LivingEntity victim) {
        block25: {
            try {
                RankXConfig cfg;
                if (player == null || victim == null) {
                    return;
                }
                if (!Config.enableProgressionSystem) {
                    return;
                }
                EntityType entityType = victim.m_6095_();
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
                RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
                if (cfg == null) {
                    return;
                }
                if (RankUtils.compareRanks(this.getRank(player.m_20148_(), entityType), "S") < 0) {
                    return;
                }
                UUID playerUUID = player.m_20148_();
                String entityIdStr = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString();
                if (cfg.findChallenge("defeat_no_hit") != null) {
                    Map<String, Long> per = this.playerEncounterStartTicks.get(playerUUID);
                    String victimUUID = victim.m_20148_().toString();
                    if (per != null && per.containsKey(victimUUID)) {
                        long startTick = per.get(victimUUID);
                        long lastHurtTick = this.playerLastDamageGameTime.getOrDefault(playerUUID, Long.MIN_VALUE);
                        if (lastHurtTick < startTick) {
                            this.awardRankXChallenge(player, entityType, "defeat_no_hit");
                        }
                        per.remove(victimUUID);
                    }
                }
                if (cfg.findChallenge("no_armor_no_shield_clear") != null) {
                    boolean noShieldEquipped;
                    boolean noArmor = player.m_6844_(EquipmentSlot.HEAD).m_41619_() && player.m_6844_(EquipmentSlot.CHEST).m_41619_() && player.m_6844_(EquipmentSlot.LEGS).m_41619_() && player.m_6844_(EquipmentSlot.FEET).m_41619_();
                    boolean bl = noShieldEquipped = !(!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == Items.f_42740_ || !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == Items.f_42740_);
                    if (noArmor && noShieldEquipped) {
                        this.awardRankXChallenge(player, entityType, "no_armor_no_shield_clear");
                    }
                }
                if (cfg.findChallenge("per_entity_count") != null) {
                    this.awardRankXChallenge(player, entityType, "per_entity_count");
                }
                List<RankXConfig.Challenge> challenges = cfg.getChallenges();
                boolean hasElite = false;
                ArrayList<RankXConfig.Challenge> eliteChallenges = new ArrayList<RankXConfig.Challenge>();
                for (RankXConfig.Challenge ch : challenges) {
                    String id = ch.id();
                    if (id == null || !id.startsWith("elite_streak_")) continue;
                    hasElite = true;
                    eliteChallenges.add(ch);
                }
                if (hasElite) {
                    Map byEntity = this.playerEliteStreakCounts.computeIfAbsent(playerUUID, k -> new HashMap());
                    int streak = byEntity.getOrDefault(entityIdStr, 0) + 1;
                    byEntity.put(entityIdStr, streak);
                    for (RankXConfig.Challenge ch : eliteChallenges) {
                        String id = ch.id();
                        try {
                            int n = Integer.parseInt(id.substring("elite_streak_".length()));
                            if (streak < n) continue;
                            this.awardRankXChallenge(player, entityType, id);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                if (cfg.findChallenge("clean_clear") != null) {
                    this.awardRankXChallenge(player, entityType, "clean_clear");
                }
                if (cfg.findChallenge("no_cheese_clear") != null && !this.usedDisallowedCheeseRecently(player, cfg)) {
                    this.awardRankXChallenge(player, entityType, "no_cheese_clear");
                }
                if (cfg.findChallenge("observe_before_fight") != null && this.observedRecentlyBeforeKill(player, entityType)) {
                    this.awardRankXChallenge(player, entityType, "observe_before_fight");
                }
                if (cfg.findChallenge("team_bonus") == null) break block25;
                try {
                    ServerLevel lvl = (ServerLevel)player.m_9236_();
                    List nearby = lvl.m_45976_(ServerPlayer.class, player.m_20191_().m_82400_(64.0));
                    int aliveCount = 0;
                    for (ServerPlayer sp : nearby) {
                        if (sp == null || !sp.m_6084_() || sp.m_5833_()) continue;
                        ++aliveCount;
                    }
                    if (aliveCount >= 2) {
                        for (ServerPlayer sp : nearby) {
                            if (sp == null || !sp.m_6084_() || sp.m_5833_()) continue;
                            this.awardRankXChallenge(sp, entityType, "team_bonus");
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Rank-X kill challenge evaluation failed: {}", (Object)ex.getMessage());
            }
        }
    }

    private void maybeAwardPacifist(ServerPlayer player, EntityType<?> entityType) {
        try {
            RankXConfig cfg;
            if (player == null || entityType == null) {
                return;
            }
            EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
            RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
            if (cfg == null || cfg.findChallenge("pacifist_bonus") == null) {
                return;
            }
            int totalKills = 0;
            Map per = this.playerKillCounts.getOrDefault(player.m_20148_(), Collections.emptyMap());
            Iterator iterator = per.values().iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                totalKills += v;
            }
            if (totalKills == 0) {
                this.awardRankXChallenge(player, entityType, "pacifist_bonus");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void utilUnique(ServerPlayer player, EntityType<?> entityType, String key) {
        String eid;
        RankXConfig cfg;
        if (player == null || entityType == null || key == null) {
            return;
        }
        EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
        RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
        if (cfg == null || cfg.findChallenge("util_unique_interaction") == null) {
            return;
        }
        Map byEntity = this.sessionUtilUniqueInteractions.computeIfAbsent(player.m_20148_(), k -> new HashMap());
        Set set = byEntity.computeIfAbsent(eid = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString(), k -> new HashSet());
        if (set.add(key)) {
            this.awardRankXChallenge(player, entityType, "util_unique_interaction");
        }
    }

    private void nonLethal(ServerPlayer player, EntityType<?> entityType, String key) {
        String eid;
        RankXConfig cfg;
        if (player == null || entityType == null || key == null) {
            return;
        }
        EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(entityType);
        RankXConfig rankXConfig = cfg = attrs != null ? attrs.rankX() : null;
        if (cfg == null || cfg.findChallenge("non_lethal_interaction") == null) {
            return;
        }
        Map byEntity = this.sessionNonLethalInteractions.computeIfAbsent(player.m_20148_(), k -> new HashMap());
        Set set = byEntity.computeIfAbsent(eid = ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString(), k -> new HashSet());
        if (set.add(key)) {
            this.awardRankXChallenge(player, entityType, "non_lethal_interaction");
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        try {
            Player player = event.getCausedByPlayer();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (!(event.getChild() instanceof LivingEntity)) {
                return;
            }
            AgeableMob child = event.getChild();
            ServerLevel level = (ServerLevel)player2.m_9236_();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
            data.awardRankXChallenge(player2, child.m_6095_(), "breed");
            data.maybeAwardPacifist(player2, child.m_6095_());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onEntityInteractRX(PlayerInteractEvent.EntityInteractSpecific event) {
        try {
            LivingEntity lg;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
            Entity target = event.getTarget();
            ItemStack stack = event.getItemStack();
            if (target == null || stack == null) {
                return;
            }
            EntityType type = target.m_6095_();
            if (type == EntityType.f_20557_ && stack.m_150930_(Items.f_42446_)) {
                data.utilUnique(player2, type, "milk");
                data.maybeAwardPacifist(player2, type);
            }
            if (type == EntityType.f_20520_ && stack.m_150930_(Items.f_42574_)) {
                data.utilUnique(player2, type, "shear");
                data.maybeAwardPacifist(player2, type);
            }
            if (stack.m_150930_(Items.f_42655_)) {
                String leadKey = "lead:" + target.m_20148_().toString();
                data.nonLethal(player2, type, leadKey);
                data.maybeAwardPacifist(player2, type);
            }
            if (target instanceof Animal && stack.m_41614_()) {
                data.nonLethal(player2, type, "feed");
                data.maybeAwardPacifist(player2, type);
            }
            if (type == EntityType.f_20460_ && stack.m_150930_(Items.f_42416_) && target instanceof LivingEntity && (lg = (LivingEntity)target).m_21223_() < lg.m_21233_()) {
                data.utilUnique(player2, type, "repair");
                data.maybeAwardPacifist(player2, type);
            }
            if (stack.m_150930_(Items.f_42447_) && target instanceof Bucketable) {
                String bucketKey = "bucket:" + target.m_20148_().toString();
                data.utilUnique(player2, type, bucketKey);
                data.maybeAwardPacifist(player2, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        try {
            boolean toolOk;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            Level level = player2.m_9236_();
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            Block blk = state.m_60734_();
            ItemStack stack = event.getItemStack();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate((ServerLevel)level);
            boolean isHive = blk == Blocks.f_50718_ || blk == Blocks.f_50717_;
            boolean bl = toolOk = stack.m_150930_(Items.f_42590_) || stack.m_150930_(Items.f_42574_);
            if (isHive && toolOk) {
                data.utilUnique(player2, EntityType.f_20550_, "honey");
                data.maybeAwardPacifist(player2, EntityType.f_20550_);
            }
            try {
                boolean isBed = blk instanceof BedBlock;
                if (isBed && !level.m_46472_().equals((Object)Level.f_46428_)) {
                    data.markCheeseUsage(player2, "beds");
                }
                if (stack != null && stack.m_150930_(Items.f_42729_)) {
                    data.markCheeseUsage(player2, "end_crystals");
                }
                if (blk == Blocks.f_50724_) {
                    data.markCheeseUsage(player2, "respawn_anchors");
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onAnimalTameRX(AnimalTameEvent event) {
        try {
            Player player = event.getTamer();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)player2.m_9236_();
            PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
            Animal animal = event.getAnimal();
            if (animal != null) {
                data.nonLethal(player2, animal.m_6095_(), "tame");
                data.awardRankXChallenge(player2, animal.m_6095_(), "tame");
                int kc = data.getKillCount(player2.m_20148_(), animal.m_6095_());
                String rk = data.getRank(player2.m_20148_(), animal.m_6095_());
                data.sendProgressionUpdatePacket(player2, animal.m_6095_(), kc, rk);
                data.maybeAwardPacifist(player2, animal.m_6095_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerProgressionData data = PlayerProgressionData.getOrCreate((ServerLevel)player.m_9236_());
            data.playerLastDamageGameTime.put(player.m_20148_(), player.m_9236_().m_46467_());
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onPlayerTickProximity(TickEvent.PlayerTickEvent event) {
        void player;
        Player player2;
        if (event.phase != TickEvent.Phase.END || !((player2 = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player22 = (ServerPlayer)player2;
        if (!Config.enableProgressionSystem || !"ranks".equals(Config.progressionSystemType)) {
            return;
        }
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        int delta = 10;
        ServerLevel level = (ServerLevel)player.m_9236_();
        PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
        try {
            List nearby = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(6.0));
            LivingEntity closest = null;
            double best = Double.MAX_VALUE;
            for (LivingEntity le : nearby) {
                double d;
                EntityType et = le.m_6095_();
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(et);
                RankXConfig rankXConfig = attrs != null ? attrs.rankX() : null;
                if (rankXConfig == null || rankXConfig.findChallenge("proximity_survival") == null || !((d = (double)le.m_20270_((Entity)player)) < best)) continue;
                best = d;
                closest = le;
            }
            String key = null;
            if (closest != null) {
                key = ForgeRegistries.ENTITY_TYPES.getKey((Object)closest.m_6095_()).toString();
                byType = data.playerProximityTicks.computeIfAbsent(player.m_20148_(), k -> new HashMap());
                int ticks = byType.getOrDefault(key, 0) + 10;
                byType.put(key, ticks);
                if (ticks >= 600) {
                    long lastHurt = data.playerLastDamageGameTime.getOrDefault(player.m_20148_(), 0L);
                    if (player.m_9236_().m_46467_() - lastHurt >= 600L) {
                        data.awardRankXChallenge((ServerPlayer)player, closest.m_6095_(), "proximity_survival");
                        int kc = data.getKillCount(player.m_20148_(), closest.m_6095_());
                        String rk = data.getRank(player.m_20148_(), closest.m_6095_());
                        data.sendProgressionUpdatePacket((ServerPlayer)player, closest.m_6095_(), kc, rk);
                        byType.put(key, 0);
                    }
                }
            } else {
                byType = data.playerProximityTicks.get(player.m_20148_());
                if (byType != null && !byType.isEmpty()) {
                    ArrayList<String> toReset = new ArrayList<String>();
                    for (Map.Entry entry : byType.entrySet()) {
                        int v = Math.max(0, (Integer)entry.getValue() - 25);
                        if (v == 0) {
                            toReset.add((String)entry.getKey());
                            continue;
                        }
                        entry.setValue(v);
                    }
                    for (String string : toReset) {
                        byType.remove(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

