/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RankXConfig {
    public static final int DEFAULT_TARGET = 100;
    private final int target;
    private final GateConfig gates;
    private final List<Challenge> challenges;
    private final List<String> disallowedCheese;

    public RankXConfig(int target, GateConfig gates, List<Challenge> challenges, List<String> disallowedCheese) {
        this.target = target;
        this.gates = gates == null ? new GateConfig(3, 3) : gates;
        this.challenges = challenges == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Challenge>(challenges));
        this.disallowedCheese = disallowedCheese == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(disallowedCheese));
    }

    public int getTarget() {
        return this.target;
    }

    public GateConfig getGates() {
        return this.gates;
    }

    public List<Challenge> getChallenges() {
        return this.challenges;
    }

    public List<String> getDisallowedCheese() {
        return this.disallowedCheese;
    }

    public Challenge findChallenge(String id) {
        if (id == null) {
            return null;
        }
        for (Challenge c : this.challenges) {
            if (!Objects.equals(c.id(), id)) continue;
            return c;
        }
        return null;
    }

    public static class GateConfig {
        private final int minDaysSinceS;
        private final int minSessions;

        public GateConfig(int minDaysSinceS, int minSessions) {
            this.minDaysSinceS = Math.max(0, minDaysSinceS);
            this.minSessions = Math.max(0, minSessions);
        }

        public int getMinDaysSinceS() {
            return this.minDaysSinceS;
        }

        public int getMinSessions() {
            return this.minSessions;
        }
    }

    public record Challenge(String id, int points, int cap) {
    }
}

