/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.integration.kubejs;

import com.araxer.araxers_bestiary.api.BestiaryCapabilities;
import com.araxer.araxers_bestiary.api.IBestiaryProgress;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.data.RankUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BestiaryJS {
    public static int rankCode(ServerPlayer player, String entityId) {
        EntityType<?> et = BestiaryJS.resolveEntity(entityId);
        if (player == null || et == null) {
            return 0;
        }
        return BestiaryJS.getProgress(player).getRankCode(et);
    }

    public static int rankCode(String playerNameOrUuid, String entityId) {
        ServerPlayer sp = BestiaryJS.resolvePlayer(playerNameOrUuid);
        return BestiaryJS.rankCode(sp, entityId);
    }

    public static boolean meets(ServerPlayer player, String entityId, String threshold) {
        EntityType<?> et = BestiaryJS.resolveEntity(entityId);
        if (player == null || et == null) {
            return false;
        }
        if (!RankUtils.isValidRank(threshold) || "".equals(threshold)) {
            return false;
        }
        return BestiaryJS.getProgress(player).meets(et, threshold);
    }

    public static boolean meets(String playerNameOrUuid, String entityId, String threshold) {
        ServerPlayer sp = BestiaryJS.resolvePlayer(playerNameOrUuid);
        return BestiaryJS.meets(sp, entityId, threshold);
    }

    public static String rank(ServerPlayer player, String entityId) {
        EntityType<?> et = BestiaryJS.resolveEntity(entityId);
        if (player == null || et == null) {
            return "";
        }
        return BestiaryJS.getProgress(player).getRank(et);
    }

    public static String rank(String playerNameOrUuid, String entityId) {
        ServerPlayer sp = BestiaryJS.resolvePlayer(playerNameOrUuid);
        return BestiaryJS.rank(sp, entityId);
    }

    public static String rankName(ServerPlayer player, String entityId) {
        return BestiaryJS.rank(player, entityId);
    }

    public static String rankName(String playerNameOrUuid, String entityId) {
        return BestiaryJS.rank(playerNameOrUuid, entityId);
    }

    public static boolean isObserved(ServerPlayer player, String entityId) {
        EntityType<?> et = BestiaryJS.resolveEntity(entityId);
        if (player == null || et == null) {
            return false;
        }
        return BestiaryJS.getProgress(player).isObserved(et);
    }

    public static boolean isObserved(String playerNameOrUuid, String entityId) {
        ServerPlayer sp = BestiaryJS.resolvePlayer(playerNameOrUuid);
        return BestiaryJS.isObserved(sp, entityId);
    }

    public static boolean isDiscovered(ServerPlayer player, String entityId) {
        EntityType<?> et = BestiaryJS.resolveEntity(entityId);
        if (player == null || et == null) {
            return false;
        }
        return BestiaryJS.getProgress(player).isDiscovered(et);
    }

    public static boolean isDiscovered(String playerNameOrUuid, String entityId) {
        ServerPlayer sp = BestiaryJS.resolvePlayer(playerNameOrUuid);
        return BestiaryJS.isDiscovered(sp, entityId);
    }

    private static EntityType<?> resolveEntity(String entityId) {
        if (entityId == null) {
            return null;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)entityId);
        if (rl == null) {
            return null;
        }
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
    }

    private static ServerPlayer resolvePlayer(String playerNameOrUuid) {
        if (playerNameOrUuid == null || playerNameOrUuid.isEmpty()) {
            return null;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(playerNameOrUuid);
            return server.m_6846_().m_11259_(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return server.m_6846_().m_11255_(playerNameOrUuid);
        }
    }

    private static IBestiaryProgress getProgress(final ServerPlayer player) {
        Optional cap = player.getCapability(BestiaryCapabilities.BESTIARY).resolve();
        if (cap.isPresent()) {
            return (IBestiaryProgress)cap.get();
        }
        final PlayerProgressionData data = GlobalPlayerProgressionData.get(player.m_20194_()).data();
        return new IBestiaryProgress(){

            @Override
            public String getRank(EntityType<?> entityType) {
                return data.getRank(player.m_20148_(), entityType);
            }

            @Override
            public int getRankCode(EntityType<?> entityType) {
                String r = this.getRank(entityType);
                if (r == null || r.equals("")) {
                    return 0;
                }
                int idx = RankUtils.getRankIndex(r);
                return idx < 0 ? 0 : idx + 1;
            }

            @Override
            public boolean meets(EntityType<?> entityType, String threshold) {
                String r = this.getRank(entityType);
                if (!RankUtils.isValidRank(threshold) || "".equals(threshold)) {
                    return false;
                }
                return RankUtils.meetsRankThreshold(r, threshold);
            }

            @Override
            public boolean isObserved(EntityType<?> entityType) {
                return data.isSpyglassObserved(player.m_20148_(), entityType);
            }

            @Override
            public boolean isDiscovered(EntityType<?> entityType) {
                return data.isNewlyDiscovered(player.m_20148_(), entityType);
            }
        };
    }
}

