/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.mixin.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.sashakyotoz.variousworld.common.blocks.BlockUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockRenderDispatcher.class})
public abstract class BlockRenderDispatcherMixin {
    @Shadow
    public abstract void renderBreakingTexture(BlockState var1, BlockPos var2, BlockAndTintGetter var3, PoseStack var4, VertexConsumer var5);

    @Shadow
    public abstract void renderBatched(BlockState var1, BlockPos var2, BlockAndTintGetter var3, PoseStack var4, Function<ChunkSectionLayer, VertexConsumer> var5, boolean var6, List<BlockModelPart> var7);

    @Inject(method={"renderBreakingTexture(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderReclamiteDamage(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack stack, VertexConsumer vertexConsumer, CallbackInfo ci) {
        if (BlockUtils.isReclamited(state)) {
            this.renderBreakingTexture(BlockUtils.getReclamiteEquivalent(state), pos, world, stack, vertexConsumer);
            ci.cancel();
        }
    }

    @Inject(method={"renderBatched(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/mojang/blaze3d/vertex/PoseStack;Ljava/util/function/Function;ZLjava/util/List;)V"}, at={@At(value="HEAD")})
    private void renderReclamite(BlockState state, BlockPos pos, BlockAndTintGetter getter, PoseStack poseStack, Function<ChunkSectionLayer, VertexConsumer> bufferLookup, boolean flag, List<BlockModelPart> list, CallbackInfo ci) {
        if (BlockUtils.isReclamited(state)) {
            this.renderBatched(BlockUtils.getReclamiteEquivalent(state), pos, getter, poseStack, bufferLookup, flag, list);
        }
    }
}

