/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.entities.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.sashakyotoz.variousworld.common.entities.SquealingSpiderEntity;
import net.sashakyotoz.variousworld.common.entities.brain.behavior.Echoing;
import net.sashakyotoz.variousworld.common.entities.brain.behavior.EchoingWhenStuck;
import net.sashakyotoz.variousworld.common.entities.brain.behavior.Leaping;
import net.sashakyotoz.variousworld.common.entities.brain.behavior.LongLeaping;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;

public class SquealingSpiderAi {
    public static final List<SensorType<? extends Sensor<? super SquealingSpiderEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, VWMiscRegistries.SQUEALING_SPIDER_ATTACK_SENSOR.get());
    public static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryModuleType.BREEZE_JUMP_COOLDOWN, (Object)MemoryModuleType.BREEZE_JUMP_INHALING, (Object)MemoryModuleType.BREEZE_SHOOT, (Object)MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object[])new MemoryModuleType[]{MemoryModuleType.BREEZE_SHOOT_COOLDOWN, MemoryModuleType.BREEZE_JUMP_TARGET, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.PATH});
    private static final UniformInt TIME_BETWEEN_LEAPING = UniformInt.of((int)400, (int)4000);

    public static Brain<?> makeBrain(SquealingSpiderEntity entity, Brain<SquealingSpiderEntity> brain) {
        SquealingSpiderAi.initCoreActivity(brain);
        SquealingSpiderAi.initIdleActivity(brain);
        SquealingSpiderAi.initFightActivity(entity, brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.FIGHT);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initMemories(SquealingSpiderEntity entity, RandomSource random) {
        entity.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)TIME_BETWEEN_LEAPING.sample(random));
    }

    private static void initCoreActivity(Brain<SquealingSpiderEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new CountDownCooldownTicks(MemoryModuleType.RAM_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<SquealingSpiderEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create((serverLevel, mob) -> mob.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)1, (Object)StartAttacking.create((serverLevel, mob) -> mob.getHurtBy())), (Object)Pair.of((Object)2, (Object)((Object)new SlideToTargetSink(20, 40))), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(100, 200), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.8f), (Object)2))))));
    }

    private static void initFightActivity(SquealingSpiderEntity entity, Brain<SquealingSpiderEntity> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create(Sensor.wasEntityAttackableLastNTicks((LivingEntity)entity, (int)100).negate()::test)), (Object)Pair.of((Object)1, (Object)((Object)new Echoing())), (Object)Pair.of((Object)2, (Object)((Object)new LongLeaping())), (Object)Pair.of((Object)3, (Object)((Object)new EchoingWhenStuck())), (Object)Pair.of((Object)4, (Object)((Object)new Leaping()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(SquealingSpiderEntity spider) {
        spider.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static class SlideToTargetSink
    extends MoveToTargetSink {
        public SlideToTargetSink(int i, int i1) {
            super(i, i1);
        }

        protected void start(ServerLevel level, Mob mob, long gameTime) {
            super.start(level, mob, gameTime);
            mob.playSound(SoundEvents.SPIDER_STEP);
            mob.setPose(Pose.SLIDING);
        }

        protected void stop(ServerLevel level, Mob mob, long gameTime) {
            super.stop(level, mob, gameTime);
            mob.setPose(Pose.STANDING);
            if (mob.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                mob.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, (Object)Unit.INSTANCE, 60L);
            }
        }
    }
}

