/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.entities.brain.behavior;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.entities.SquealingSpiderEntity;
import net.sashakyotoz.variousworld.common.entities.brain.behavior.LongLeaping;

public class Echoing
extends Behavior<SquealingSpiderEntity> {
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{30, 60, 90, 100, 110}));
    private static final int SHOOT_INITIAL_DELAY_TICKS = Math.round(45.0f);
    private static final int SHOOT_RECOVER_DELAY_TICKS = Math.round(12.0f);
    private static final int SHOOT_COOLDOWN_TICKS = Math.round(60.0f);

    @VisibleForTesting
    public Echoing() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_JUMP_TARGET, (Object)MemoryStatus.VALUE_ABSENT), SHOOT_INITIAL_DELAY_TICKS + 1 + SHOOT_RECOVER_DELAY_TICKS);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, SquealingSpiderEntity owner) {
        return owner.getPose() == Pose.STANDING && !OnActionsTrigger.findBlocksInRegion((Level)level, owner.getOnPos().offset(-16, -8, -16), owner.getOnPos().offset(16, 8, 16), (Predicate<BlockState>)((Predicate)state -> state != null && state.is(Blocks.COBWEB)), 6).isEmpty() && owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).map(living -> Echoing.isTargetWithinRange(owner, living)).map(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                owner.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
            }
            return aBoolean;
        }).orElse(false) != false;
    }

    static Vec3 randomPointBehindSpider(SquealingSpiderEntity spider, RandomSource random) {
        float f = spider.yHeadRot + 180.0f + (float)random.nextGaussian() * 90.0f / 2.0f;
        float f1 = Mth.lerp((float)random.nextFloat(), (float)3.0f, (float)8.0f);
        Vec3 vec3 = Vec3.directionFromRotation((float)0.0f, (float)f).scale((double)f1);
        return spider.position().add(vec3);
    }

    protected boolean canStillUse(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && entity.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_SHOOT);
    }

    protected void start(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(p_312833_ -> entity.setPose(Pose.SHOOTING));
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)Unit.INSTANCE, (long)SHOOT_INITIAL_DELAY_TICKS);
        entity.playSound(SoundEvents.BREEZE_INHALE, 1.2f, 0.1f);
        entity.getNavigation().stop();
    }

    protected void stop(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        if (entity.getPose() == Pose.SHOOTING) {
            entity.setPose(Pose.STANDING);
        }
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)Unit.INSTANCE, (long)SHOOT_COOLDOWN_TICKS);
        entity.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
        BlockPos blockpos = LongLeaping.snapToSurface((LivingEntity)entity, Echoing.randomPointBehindSpider(entity, entity.getRandom()));
        if (blockpos != null) {
            entity.setPose(Pose.INHALING);
            entity.setPose(Pose.LONG_JUMPING);
            entity.setYRot(entity.yBodyRot);
            entity.setDiscardFriction(true);
            Optional<Vec3> vec3 = this.calculateOptimalJumpVector(entity, entity.getRandom(), blockpos.getCenter());
            vec3.ifPresent(arg_0 -> ((SquealingSpiderEntity)entity).setDeltaMovement(arg_0));
        }
    }

    private Optional<Vec3> calculateOptimalJumpVector(SquealingSpiderEntity spider, RandomSource random, Vec3 target) {
        Iterator iterator = Util.shuffledCopy(ALLOWED_ANGLES, (RandomSource)random).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional optional = LongJumpUtil.calculateJumpVectorForAngle((Mob)spider, (Vec3)target, (float)1.5f, (int)i, (boolean)false);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    protected void tick(ServerLevel level, SquealingSpiderEntity spider, long gameTime) {
        Brain<SquealingSpiderEntity> brain = spider.getBrain();
        LivingEntity livingentity = brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (livingentity != null) {
            spider.lookAt(EntityAnchorArgument.Anchor.EYES, livingentity.position());
            if (brain.getMemory(MemoryModuleType.BREEZE_SHOOT_CHARGING).isEmpty() && brain.getMemory(MemoryModuleType.BREEZE_SHOOT_RECOVERING).isEmpty()) {
                brain.setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)Unit.INSTANCE, (long)SHOOT_RECOVER_DELAY_TICKS);
                if (Echoing.isFacingTarget(spider, livingentity)) {
                    level.playSound((Entity)spider, spider.getOnPos().above(), SoundEvents.WARDEN_SONIC_CHARGE, SoundSource.HOSTILE, 1.0f, 1.0f);
                    ArrayList<BlockPos> cobwebs = OnActionsTrigger.findBlocksInRegion((Level)level, spider.getOnPos().offset(-16, -8, -16), spider.getOnPos().offset(16, 8, 16), (Predicate<BlockState>)((Predicate)state -> state != null && state.is(Blocks.COBWEB)), 6);
                    if (!cobwebs.isEmpty() && Optional.ofNullable(cobwebs.getFirst()).isPresent()) {
                        BlockPos cobweb = cobwebs.getFirst();
                        if (!level.isClientSide()) {
                            level.destroyBlock(cobweb, false);
                            level.setBlockAndUpdate(livingentity.getOnPos().above(), Blocks.COBWEB.defaultBlockState());
                            level.playSound(null, (double)cobweb.getX(), (double)cobweb.getY(), (double)cobweb.getZ(), SoundEvents.COBWEB_BREAK, SoundSource.NEUTRAL, 0.7f, 0.4f + level.getRandom().nextFloat() * 1.2f);
                        } else {
                            level.playLocalSound(cobweb, SoundEvents.COBWEB_BREAK, SoundSource.BLOCKS, 1.0f, 0.3f, true);
                            level.addParticle((ParticleOptions)ParticleTypes.VAULT_CONNECTION, (double)((float)cobweb.getX() + 0.5f), (double)((float)cobweb.getY() + 0.5f), (double)((float)cobweb.getZ() + 0.5f), 0.0, 1.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public static boolean isFacingTarget(SquealingSpiderEntity spider, LivingEntity target) {
        Vec3 vec31;
        Vec3 vec3 = spider.getViewVector(1.0f);
        return vec3.dot(vec31 = target.position().subtract(spider.position()).normalize()) > 0.5;
    }

    private static boolean isTargetWithinRange(SquealingSpiderEntity spider, LivingEntity target) {
        double d0 = spider.position().distanceToSqr(target.position());
        return d0 > 4.0 && d0 < 256.0;
    }
}

