/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common;

import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.sashakyotoz.variousworld.common.blocks.BlockUtils;
import net.sashakyotoz.variousworld.common.blocks.custom.CrystallineGrassBlock;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWBiomes;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import net.sashakyotoz.variousworld.init.VWVillagers;

@EventBusSubscriber
public class OnActionsTrigger {
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    public static boolean isMovingOnLand(LivingEntity entity) {
        return entity.onGround() && entity.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
    }

    public static void returnDefaultStack(ItemStack stack, LivingEntity entity) {
        ItemStack tmpStack = stack.getItem().getDefaultInstance();
        tmpStack.setCount(stack.getCount());
        tmpStack.setDamageValue(stack.getDamageValue());
        for (EquipmentSlot value : EquipmentSlot.values()) {
            if (!entity.getItemBySlot(value).equals(stack)) continue;
            entity.setItemSlot(value, tmpStack);
        }
    }

    public static ItemStack returnStackWithGem(ItemStack stack, ItemStack gem) {
        ItemStack supplyGemStack = VWItems.SUPPLY_CRYSTAL.toStack();
        String toolName = OnActionsTrigger.getToolName(stack);
        if (stack.getItem() instanceof TieredItem && stack.has((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get())) {
            for (ModConfigController.GemsmithingSetting setting : ModConfigController.CRYSTALING_CONFIG_VALUES) {
                if (!gem.getItem().equals(setting.item().build())) continue;
                supplyGemStack.set((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get(), (Object)new SupplyCrystalData(gem, toolName));
                stack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(supplyGemStack, setting.durability()));
                break;
            }
        }
        return stack;
    }

    public static String getToolName(ItemStack stack) {
        String toolName;
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TieredItem.class, TieredItem.class, TieredItem.class, TieredItem.class, TieredItem.class}, (Object)item2, n)) {
                case 0: {
                    TieredItem item3 = (TieredItem)item2;
                    if (!(item3 instanceof SwordItem)) {
                        n = 1;
                        continue block7;
                    }
                    toolName = "sword";
                    break block7;
                }
                case 1: {
                    TieredItem item4 = (TieredItem)item2;
                    if (!(item4 instanceof PickaxeItem)) {
                        n = 2;
                        continue block7;
                    }
                    toolName = "pickaxe";
                    break block7;
                }
                case 2: {
                    TieredItem item5 = (TieredItem)item2;
                    if (!(item5 instanceof AxeItem)) {
                        n = 3;
                        continue block7;
                    }
                    toolName = "axe";
                    break block7;
                }
                case 3: {
                    TieredItem item6 = (TieredItem)item2;
                    if (!(item6 instanceof HoeItem)) {
                        n = 4;
                        continue block7;
                    }
                    toolName = "hoe";
                    break block7;
                }
                case 4: {
                    TieredItem item7 = (TieredItem)item2;
                    if (!(item7 instanceof ShovelItem)) {
                        n = 5;
                        continue block7;
                    }
                    toolName = "shovel";
                    break block7;
                }
                default: {
                    toolName = "";
                    break block7;
                }
            }
            break;
        }
        return toolName;
    }

    public static void spawnParticle(ParticleOptions type, Level level, double x, double y, double z, float modifier) {
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            level.addParticle(type, x + 0.5, y, z + 0.5, Math.cos(i) * 0.25 * (double)modifier, 0.2, Math.sin(i) * 0.25 * (double)modifier);
        }
    }

    public static ArrayList<BlockPos> findBlocksInRegion(Level level, BlockPos min, BlockPos max, Predicate<BlockState> matcher, int maxResults) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        int minX = Math.min(min.getX(), max.getX());
        int maxX = Math.max(min.getX(), max.getX());
        int columnMinY = Math.max(-63, Math.min(min.getY(), max.getY()));
        int maxY = Math.max(min.getY(), max.getY());
        int minZ = Math.min(min.getZ(), max.getZ());
        int maxZ = Math.max(min.getZ(), max.getZ());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int topY = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                int columnMaxY = Math.min(maxY, topY);
                if (columnMinY > columnMaxY) continue;
                for (int y = columnMaxY; y >= columnMinY; --y) {
                    mpos.set(x, y, z);
                    BlockState state = level.getBlockState((BlockPos)mpos);
                    if (!matcher.test((Object)state)) continue;
                    found.add(mpos.immutable());
                    if (maxResults <= 0 || found.size() < maxResults) continue;
                    return found;
                }
            }
        }
        return found;
    }

    public static BlockPos findNearest(List<BlockPos> candidates, LivingEntity entity, Level level) {
        if (candidates.isEmpty()) {
            return null;
        }
        double bestDistSq = Double.POSITIVE_INFINITY;
        BlockPos best = null;
        double ex = entity.getX();
        double ey = entity.getY();
        double ez = entity.getZ();
        for (BlockPos pos : candidates) {
            double dz;
            double dy;
            double dx = (double)pos.getX() + 0.5 - ex;
            double distSq = dx * dx + (dy = (double)pos.getY() + 0.5 - ey) * dy + (dz = (double)pos.getZ() + 0.5 - ez) * dz;
            if (distSq >= bestDistSq || level.getFluidState(pos).isSource() && level.getFluidState(pos).is((Fluid)Fluids.LAVA) || !level.isAreaLoaded(pos, 1)) continue;
            bestDistSq = distSq;
            best = pos;
        }
        return best;
    }

    @SubscribeEvent
    public static void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        workQueue.removeAll(actions);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        BlockState state = event.getLevel().getBlockState(event.getPos());
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (BlockUtils.isReclamited(state) && stack.getItem() instanceof PickaxeItem) {
            if (level.isClientSide()) {
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((AmethystClusterBlock)VWBlocks.RECLAIMITE_CRYSTAL.get()).defaultBlockState()), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0);
                level.playLocalSound(pos, SoundEvents.MEDIUM_AMETHYST_BUD_BREAK, SoundSource.BLOCKS, 1.0f, 0.4f, true);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockUtils.RECLAMITE_SHARDED, (Comparable)Boolean.valueOf(false)));
            event.getEntity().drop(VWItems.RECLAIMITE_SHARD.toStack(), false);
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.OVERWORLD)) continue;
            ChunkGenerator chunkGenerator = levelStem.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.parameters().values());
                if (ModConfigController.MOD_CONFIG_VALUES != null && ModConfigController.MOD_CONFIG_VALUES.do_crystalline_forest()) {
                    parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.35f, (float)0.7f), Climate.Parameter.span((float)-0.25f, (float)0.35f), Climate.Parameter.span((float)0.1f, (float)0.5f), Climate.Parameter.span((float)-0.125f, (float)0.35f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.64f, (float)0.28f), 0L), (Object)biomeRegistry.getHolderOrThrow(VWBiomes.CRYSTALLINE_FOREST)));
                    parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.35f, (float)0.7f), Climate.Parameter.span((float)-0.25f, (float)0.35f), Climate.Parameter.span((float)0.1f, (float)0.5f), Climate.Parameter.span((float)-0.125f, (float)0.35f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.64f, (float)0.28f), 0L), (Object)biomeRegistry.getHolderOrThrow(VWBiomes.CRYSTALLINE_FOREST)));
                }
                if (ModConfigController.MOD_CONFIG_VALUES != null && ModConfigController.MOD_CONFIG_VALUES.do_blue_jacaranda_meadow()) {
                    parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.45f, (float)0.9f), Climate.Parameter.span((float)-0.125f, (float)0.65f), Climate.Parameter.span((float)0.2f, (float)0.7f), Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.56f, (float)0.46f), 0L), (Object)biomeRegistry.getHolderOrThrow(VWBiomes.BLUE_JACARANDA_MEADOW)));
                    parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.45f, (float)0.9f), Climate.Parameter.span((float)-0.125f, (float)0.65f), Climate.Parameter.span((float)0.2f, (float)0.7f), Climate.Parameter.span((float)-0.25f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.56f, (float)0.46f), 0L), (Object)biomeRegistry.getHolderOrThrow(VWBiomes.BLUE_JACARANDA_MEADOW)));
                }
                if (ModConfigController.MOD_CONFIG_VALUES != null && ModConfigController.MOD_CONFIG_VALUES.do_reclamite_caves()) {
                    parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.span((float)0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.0f, (float)0.75f), Climate.Parameter.span((float)0.6f, (float)1.1f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(VWBiomes.RECLAIMITE_CAVES)));
                }
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.sequence());
            surfaceRules.add(0, VWBiomes.preliminarySurfaceRule(VWBiomes.CRYSTALLINE_FOREST, ((CrystallineGrassBlock)((Object)VWBlocks.CRYSTALIC_GRASS_BLOCK.get())).defaultBlockState(), ((Block)VWBlocks.DIRT_WITH_CRYSTALS.get()).defaultBlockState(), ((Block)VWBlocks.DIRT_WITH_CRYSTALS.get()).defaultBlockState()));
            surfaceRules.add(1, VWBiomes.preliminarySurfaceRule(VWBiomes.BLUE_JACARANDA_MEADOW, Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.COARSE_DIRT.defaultBlockState(), Blocks.CLAY.defaultBlockState()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
            noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType().equals(VWVillagers.GEMSMITHER.value())) {
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.AMETHYST_SHARD, 4), new ItemStack((ItemLike)Items.EMERALD), 10, 3, 0.1f));
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)VWItems.CRYSTALLINE_SLIME_BALL.get(), 2), new ItemStack((ItemLike)Items.EMERALD), 10, 6, 0.1f));
            ((List)event.getTrades().get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)VWItems.SODALITE_SHARD.get()), 10, 5, 0.05f));
            ((List)event.getTrades().get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)Items.IRON_AXE), OnActionsTrigger.returnStackWithGem(Items.IRON_AXE.getDefaultInstance(), Items.AMETHYST_SHARD.getDefaultInstance()), 1, 8, 0.25f));
            ((List)event.getTrades().get(3)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.AMETHYST_SHARD, 2), 10, 5, 0.05f));
            ((List)event.getTrades().get(4)).add(new BasicItemListing(new ItemStack((ItemLike)VWItems.CRYSTALLINE_SLIME_BALL.get()), new ItemStack((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SLIME_BALL, 2), 10, 10, 0.25f));
            ((List)event.getTrades().get(5)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 11), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), OnActionsTrigger.returnStackWithGem(Items.DIAMOND_PICKAXE.getDefaultInstance(), VWItems.SODALITE_SHARD.toStack()), 1, 3, 0.15f));
        }
        if (event.getType().equals(VWVillagers.ARTIFACTOLOGIST.value())) {
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)VWItems.CRYSTALLINE_STRENGTH.get()), 8, 5, 0.1f));
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.REDSTONE, 2), 8, 5, 0.1f));
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SUGAR, 2), 8, 5, 0.1f));
            ((List)event.getTrades().get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLOWSTONE, 2), 8, 5, 0.1f));
            ((List)event.getTrades().get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.REDSTONE, 3), new ItemStack((ItemLike)Items.EMERALD), 8, 5, 0.1f));
            ((List)event.getTrades().get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.GLOWSTONE, 3), new ItemStack((ItemLike)Items.EMERALD), 8, 5, 0.1f));
            ((List)event.getTrades().get(3)).add(new BasicItemListing(new ItemStack((ItemLike)VWItems.CRYSTALLINE_STRENGTH.get()), new ItemStack((ItemLike)Items.ECHO_SHARD), new ItemStack((ItemLike)Items.RECOVERY_COMPASS), 2, 5, 0.1f));
            ((List)event.getTrades().get(4)).add(new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)VWBlocks.ARTIFACT_TABLE.get()), 1, 5, 0.1f));
        }
    }
}

