/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.ArtifactTableMenu;

public class ArtifactTableScreen
extends AbstractContainerScreen<ArtifactTableMenu> {
    private final Level level;
    private final Player player;
    public static final ResourceLocation BACKGROUND_LOCATION = VariousWorld.createVWLocation("textures/gui/artifact_table.png");

    public ArtifactTableScreen(ArtifactTableMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.level = inventory.player.level();
        this.player = inventory.player;
        this.imageWidth = 174;
        this.imageHeight = 164;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(BACKGROUND_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderIconsProgress(guiGraphics);
        RenderSystem.disableBlend();
    }

    private void renderIconsProgress(GuiGraphics graphics) {
        if (((ArtifactTableMenu)this.getMenu()).isRefreshing()) {
            graphics.blit(BACKGROUND_LOCATION, this.leftPos + 80, this.topPos + 16, 176, 16, 16, ((ArtifactTableMenu)this.getMenu()).getScaledProgress());
        }
        if (((ArtifactTableMenu)this.getMenu()).isPowered()) {
            graphics.blit(BACKGROUND_LOCATION, this.leftPos + 32, this.topPos + 48, 176, 48, 16, 16);
        }
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (Minecraft.getInstance().getLanguageManager().getSelected().equals("en_us")) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"block.various_world.artifact_table"), 56, 4, MapColor.COLOR_GRAY.col, false);
        }
    }
}

