/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithRecipe;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithRecipeInput;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;

public class GemsmithTransformRecipe
implements GemsmithRecipe {
    public final Ingredient tool;
    public final Ingredient gem;
    final ItemStack result;

    public GemsmithTransformRecipe(Ingredient tool, Ingredient gem, ItemStack result) {
        this.tool = tool;
        this.gem = gem;
        this.result = result;
    }

    @Override
    public boolean isToolIngredient(ItemStack tool) {
        return this.tool.test(tool);
    }

    @Override
    public boolean isGemIngredient(ItemStack gem) {
        return this.gem.test(gem);
    }

    public boolean matches(GemsmithRecipeInput input, Level level) {
        return this.tool.test(input.tool()) && this.gem.test(input.gem());
    }

    public ItemStack assemble(GemsmithRecipeInput input, HolderLookup.Provider provider) {
        List<ModConfigController.GemsmithingSetting> setting = ModConfigController.CRYSTALING_CONFIG_VALUES;
        if (input.tool().getItem() instanceof TieredItem && setting != null) {
            ItemStack itemstack = input.tool().copy();
            ItemStack supplyGemStack = VWItems.SUPPLY_CRYSTAL.toStack();
            for (ModConfigController.GemsmithingSetting crystalingSetting : setting) {
                if (!input.gem().is(crystalingSetting.item().build())) continue;
                String toolName = OnActionsTrigger.getToolName(itemstack);
                supplyGemStack.set((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get(), (Object)new SupplyCrystalData(input.gem(), toolName));
                itemstack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(supplyGemStack, crystalingSetting.durability()));
            }
            return itemstack;
        }
        return input.tool();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList completeInput = NonNullList.create();
        completeInput.add((Object)this.tool);
        completeInput.add((Object)this.gem);
        return completeInput;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<GemsmithTransformRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<GemsmithTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("tool").forGetter(recipe -> recipe.tool), (App)Ingredient.CODEC.fieldOf("gem").forGetter(recipe -> recipe.gem), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, GemsmithTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GemsmithTransformRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<GemsmithTransformRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GemsmithTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static GemsmithTransformRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new GemsmithTransformRecipe(ingredient, ingredient1, itemstack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, GemsmithTransformRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tool);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.gem);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }

    public static class Type
    implements RecipeType<GemsmithTransformRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

