/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.config.IResourceExistence;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import org.jetbrains.annotations.Nullable;

public class ConfiguredData {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String[] toolNames = new String[]{"sword", "pickaxe", "axe", "shovel", "hoe"};
    public final ResourceLocation target;
    public Function<JsonElement, String> provider;
    public final Supplier<Boolean> enabled;
    public static Map<Integer, MultiPackResourceManager> MANAGER_KEEPER = new HashMap<Integer, MultiPackResourceManager>();
    public static List<ConfiguredData> INSTANCES = new LinkedList<ConfiguredData>();
    private static final List<PendingRecipe> pendingRecipes = new ArrayList<PendingRecipe>();

    public ConfiguredData(ResourceLocation target, Supplier<Boolean> enabled, Function<JsonElement, String> provider) {
        this.target = target;
        this.provider = provider;
        this.enabled = enabled;
    }

    public String apply(@Nullable String original) {
        return ((JsonElement)gson.fromJson(this.provider.apply((JsonElement)gson.fromJson(original == null ? "" : original, JsonElement.class)), JsonElement.class)).toString();
    }

    @Nullable
    public static ConfiguredData get(ResourceLocation id) {
        return INSTANCES.stream().filter(data -> data.target.equals((Object)id)).findAny().orElse(null);
    }

    protected static void register(ResourceLocation target, Supplier<Boolean> enabled, Function<JsonElement, String> provider) {
        INSTANCES.add(new ConfiguredData(target, enabled, provider));
    }

    public static void register() {
        ConfiguredData.register(ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)"models/item/supply_crystal.json"), () -> true, json -> gson.toJson((JsonElement)ConfiguredData.supplyCrystalJson()));
        ConfiguredData.registerMissingRecipes();
    }

    private static JsonObject supplyCrystalJson() {
        JsonObject root = new JsonObject();
        root.addProperty("parent", "item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", "various_world:item/crystals/null");
        root.add("textures", (JsonElement)textures);
        JsonArray overrides = ConfiguredData.getOverrides();
        root.add("overrides", (JsonElement)overrides);
        return root;
    }

    private static JsonArray getOverrides() {
        JsonArray overrides = new JsonArray();
        for (int i = 0; i < ModConfigController.CRYSTALING_CONFIG_VALUES.size(); ++i) {
            ModConfigController.GemsmithingSetting setting = ModConfigController.CRYSTALING_CONFIG_VALUES.get(i);
            int crystalValue = i + 1;
            for (int j = 0; j < toolNames.length; ++j) {
                int toolValue = j + 1;
                String toolName = toolNames[j];
                JsonObject overrideEntry = new JsonObject();
                JsonObject predicate = new JsonObject();
                predicate.addProperty("crystal", (Number)crystalValue);
                predicate.addProperty("tool", (Number)toolValue);
                overrideEntry.add("predicate", (JsonElement)predicate);
                overrideEntry.addProperty("model", "various_world:item/" + setting.prefix() + "_" + toolName);
                overrides.add((JsonElement)overrideEntry);
            }
        }
        return overrides;
    }

    public static JsonObject missingCrystalJson(String tool, Item item) {
        JsonObject root = new JsonObject();
        root.addProperty("parent", "various_world:item/missing/crystal_" + tool);
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", String.format("%s:%s", BuiltInRegistries.ITEM.getKey((Object)item).getNamespace(), BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/").getPath()));
        root.add("textures", (JsonElement)textures);
        return root;
    }

    public static void registerMissingRecipes() {
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof TieredItem).forEach(item -> {
            if (ModConfigController.CRYSTALING_CONFIG_VALUES != null) {
                for (ModConfigController.GemsmithingSetting setting : ModConfigController.CRYSTALING_CONFIG_VALUES) {
                    ResourceLocation tool = BuiltInRegistries.ITEM.getKey(item);
                    ResourceLocation gem = BuiltInRegistries.ITEM.getKey((Object)setting.item().build());
                    if (setting.item().build().equals(Items.AIR) && !gem.getNamespace().equals("various_world")) {
                        pendingRecipes.add(new PendingRecipe(setting.item().getId(), setting.item(), setting.prefix()));
                        continue;
                    }
                    String keyS = String.format("recipe/%s_%s_gemsmithing.json", tool.getPath(), gem.getPath());
                    ResourceLocation key = gem.getNamespace().equals("various_world") ? ResourceLocation.parse((String)keyS) : ResourceLocation.fromNamespaceAndPath((String)tool.getNamespace(), (String)keyS);
                    if (MANAGER_KEEPER.get(0) == null || ((IResourceExistence)MANAGER_KEEPER.get(0)).resourceExists(key)) continue;
                    ConfiguredData.register(key, () -> true, json -> gson.toJson((JsonElement)ConfiguredData.missingRecipeJson(tool.getPath(), gem.getPath())));
                }
            }
        });
    }

    public static void processPendingRecipes() {
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof TieredItem) {
                ResourceLocation toolRL = BuiltInRegistries.ITEM.getKey(item);
                for (PendingRecipe pending : pendingRecipes) {
                    if (pending.lazyGem.getId().getNamespace().equals("minecraft")) continue;
                    Item gemItem = pending.lazyGem.build();
                    if (gemItem.equals(Items.AIR)) {
                        VariousWorld.LOGGER.info("Pending recipe: gem item {} still not found.", (Object)pending.lazyGem.getId());
                        continue;
                    }
                    ResourceLocation gemRL = pending.lazyGem.getId();
                    ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)toolRL.getNamespace(), (String)String.format("recipe/%s_%s_gemsmithing.json", toolRL.getPath(), gemRL.getPath()));
                    if (MANAGER_KEEPER.get(0) == null || ((IResourceExistence)MANAGER_KEEPER.get(0)).resourceExists(key)) continue;
                    ConfiguredData.register(key, () -> true, json -> gson.toJson((JsonElement)ConfiguredData.missingRecipeJson(String.format("%s:%s", toolRL.getNamespace(), toolRL.getPath()), gemRL.toString())));
                }
            }
        });
    }

    private static JsonObject missingRecipeJson(String toolName, String gemName) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "various_world:gemsmith_transform");
        JsonObject tool = new JsonObject();
        tool.addProperty("item", toolName);
        root.add("tool", (JsonElement)tool);
        JsonObject gem = new JsonObject();
        gem.addProperty("item", gemName);
        root.add("gem", (JsonElement)gem);
        JsonObject result = new JsonObject();
        result.addProperty("id", toolName);
        result.addProperty("count", (Number)1);
        root.add("result", (JsonElement)result);
        return root;
    }

    private record PendingRecipe(ResourceLocation key, ModConfigController.LazyItem lazyGem, String prefix) {
    }
}

