/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.entities;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWEntities;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import net.sashakyotoz.variousworld.init.VWSounds;

public class WanderingZombieEntity
extends Zombie {
    public WanderingZombieEntity(EntityType<Entity> entityEntityType, Level level) {
        super((EntityType)VWEntities.WANDERING_ZOMBIE.get(), level);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        float f = random.nextFloat();
        float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            ItemStack gem = VWItems.SUPPLY_CRYSTAL.toStack();
            ItemStack stack = random.nextInt(3) == 0 ? new ItemStack((ItemLike)Items.IRON_SWORD) : new ItemStack((ItemLike)Items.IRON_SHOVEL);
            gem.set((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get(), (Object)new SupplyCrystalData(VWItems.SODALITE_SHARD.toStack(), stack.getItem() instanceof AxeItem ? "axe" : "sword"));
            stack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(gem, 16));
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)VWSounds.WANDERING_ZOMBIE_AMBIENT.value();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 22.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
        return builder;
    }
}

