/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.entities.brain.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.variousworld.common.entities.SquealingSpiderEntity;
import net.sashakyotoz.variousworld.init.VWEntities;

public class Leaping
extends Behavior<SquealingSpiderEntity> {
    private final Function<SquealingSpiderEntity, UniformInt> getTimeBetweenLeaping;
    private final TargetingConditions ramTargeting = TargetingConditions.forCombat().selector(living -> !living.getType().equals(VWEntities.SQUEALING_SPIDER.get()) && living.level().getWorldBorder().isWithinBounds(living.getBoundingBox()));
    private final float speed;
    private final ToDoubleFunction<SquealingSpiderEntity> getKnockbackForce;
    private Vec3 ramDirection;
    private final Function<SquealingSpiderEntity, SoundEvent> getImpactSound;

    public Leaping() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 200);
        this.getTimeBetweenLeaping = spider -> spider.getHealth() < 9.0f ? UniformInt.of((int)200, (int)2000) : UniformInt.of((int)400, (int)4000);
        this.speed = 3.0f;
        this.getKnockbackForce = entity -> 2.0;
        this.getImpactSound = spider -> SoundEvents.SPIDER_AMBIENT;
        this.ramDirection = Vec3.ZERO;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, SquealingSpiderEntity owner) {
        return owner.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected boolean canStillUse(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected void start(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        BlockPos blockpos = entity.blockPosition();
        Brain<SquealingSpiderEntity> brain = entity.getBrain();
        Vec3 vec3 = (Vec3)brain.getMemory(MemoryModuleType.RAM_TARGET).get();
        entity.getMoveControl().strafe(-1.0f, 0.0f);
        this.ramDirection = new Vec3((double)blockpos.getX() - vec3.x(), (double)0.2f, (double)blockpos.getZ() - vec3.z()).normalize();
        brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(vec3, this.speed, 0));
    }

    protected void tick(ServerLevel level, SquealingSpiderEntity owner, long gameTime) {
        List list = level.getNearbyEntities(LivingEntity.class, this.ramTargeting, (LivingEntity)owner, owner.getBoundingBox());
        Brain<SquealingSpiderEntity> brain = owner.getBrain();
        if (!list.isEmpty()) {
            DamageSource damagesource;
            LivingEntity livingentity = (LivingEntity)list.getFirst();
            if (livingentity.hurt(damagesource = level.damageSources().noAggroMobAttack((LivingEntity)owner), (float)owner.getAttributeValue(Attributes.ATTACK_DAMAGE))) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)level, (Entity)livingentity, (DamageSource)damagesource);
            }
            int i = owner.hasEffect(MobEffects.MOVEMENT_SPEED) ? owner.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1 : 0;
            int j = owner.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) ? owner.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1 : 0;
            float f = 0.25f * (float)(i - j);
            float f1 = Mth.clamp((float)(owner.getSpeed() * 1.65f), (float)0.2f, (float)3.0f) + f;
            float f2 = livingentity.isDamageSourceBlocked(level.damageSources().mobAttack((LivingEntity)owner)) ? 0.5f : 1.0f;
            owner.addDeltaMovement(this.ramDirection);
            livingentity.knockback((double)(f2 * f1) * this.getKnockbackForce.applyAsDouble(owner), this.ramDirection.x(), this.ramDirection.z());
            this.finishRam(level, owner);
            level.playSound(null, (Entity)owner, this.getImpactSound.apply(owner), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (this.hasRammedHornBreakingBlock(level, owner)) {
            level.playSound(null, (Entity)owner, this.getImpactSound.apply(owner), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.finishRam(level, owner);
        } else {
            boolean flag1;
            Optional optional = brain.getMemory(MemoryModuleType.WALK_TARGET);
            Optional optional1 = brain.getMemory(MemoryModuleType.RAM_TARGET);
            boolean bl = flag1 = optional.isEmpty() || optional1.isEmpty() || ((WalkTarget)optional.get()).getTarget().currentPosition().closerThan((Position)optional1.get(), 0.25);
            if (flag1) {
                this.finishRam(level, owner);
            }
        }
    }

    private boolean hasRammedHornBreakingBlock(ServerLevel level, SquealingSpiderEntity owner) {
        Vec3 vec3 = owner.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        BlockPos blockpos = BlockPos.containing((Position)owner.position().add(vec3));
        return level.getBlockState(blockpos).is(BlockTags.SNAPS_GOAT_HORN) || level.getBlockState(blockpos.above()).is(BlockTags.SNAPS_GOAT_HORN);
    }

    protected void finishRam(ServerLevel level, SquealingSpiderEntity owner) {
        level.broadcastEntityEvent((Entity)owner, (byte)59);
        owner.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)this.getTimeBetweenLeaping.apply(owner).sample(level.random));
        owner.getBrain().eraseMemory(MemoryModuleType.RAM_TARGET);
    }
}

