/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.world.features.ModConfiguredFeatures;
import net.sashakyotoz.variousworld.init.VWBlocks;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> CRYSTALIC_TREE = ModPlacedFeatures.registerKey("crystalic_tree");
    public static final ResourceKey<PlacedFeature> SMALL_CRYSTALIC_TREE = ModPlacedFeatures.registerKey("small_crystalic_tree");
    public static final ResourceKey<PlacedFeature> BLUE_JACARANDA_TREE = ModPlacedFeatures.registerKey("blue_jacaranda_tree");
    public static final ResourceKey<PlacedFeature> JACARANDA_PETALS_PATCH = ModPlacedFeatures.registerKey("jacaranda_petals_patch");
    public static final ResourceKey<PlacedFeature> SODALITE_WART_PATCH = ModPlacedFeatures.registerKey("sodalite_wart_patch");
    public static final ResourceKey<PlacedFeature> SODALITE_GEODE = ModPlacedFeatures.registerKey("sodalite_geode");
    public static final ResourceKey<PlacedFeature> RECLAIMITE_POINTED_DRIPSTONE = ModPlacedFeatures.registerKey("reclaimite_pointed_dripstone");
    public static final ResourceKey<PlacedFeature> GLOW_LICHEN_VEIN = ModPlacedFeatures.registerKey("glow_lichen_vein");
    public static final ResourceKey<PlacedFeature> COBWEB_BLOCKS_CHAIN = ModPlacedFeatures.registerKey("cobweb_blocks_chain");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, CRYSTALIC_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.CRYSTALIC_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.25f, (int)2), (Block)((Block)VWBlocks.CRYSTALIC_OAK_SAPLING.get())));
        ModPlacedFeatures.register(context, SMALL_CRYSTALIC_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.CRYSTALIC_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.125f, (int)2), (Block)((Block)VWBlocks.CRYSTALIC_OAK_SAPLING.get())));
        ModPlacedFeatures.register(context, BLUE_JACARANDA_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUE_JACARANDA_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.25f, (int)2), (Block)((Block)VWBlocks.BLUE_JACARANDA_SAPLING.get())));
        ModPlacedFeatures.register(context, SODALITE_WART_PATCH, configuredFeatures.getOrThrow(ModConfiguredFeatures.SODALITE_WART_PATCH), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, JACARANDA_PETALS_PATCH, configuredFeatures.getOrThrow(ModConfiguredFeatures.JACARANDA_PETALS_PATCH), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, SODALITE_GEODE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SODALITE_GEODE), List.of(RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)12), (VerticalAnchor)VerticalAnchor.absolute((int)48)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, RECLAIMITE_POINTED_DRIPSTONE, configuredFeatures.getOrThrow(ModConfiguredFeatures.RECLAIMITE_POINTED_DRIPSTONE), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)128, (int)192)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)5)), RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, GLOW_LICHEN_VEIN, configuredFeatures.getOrThrow(ModConfiguredFeatures.GLOW_LICHEN_VEIN), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)128, (int)192)), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, COBWEB_BLOCKS_CHAIN, configuredFeatures.getOrThrow(ModConfiguredFeatures.COBWEB_BLOCKS_CHAIN), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)32, (int)64)), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)VariousWorld.createVWLocation(name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

