/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features.custom;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;
import net.sashakyotoz.variousworld.common.blocks.BlockUtils;

public class ReclaimitePointedDripstoneFeature
extends Feature<PointedDripstoneConfiguration> {
    public ReclaimitePointedDripstoneFeature(Codec<PointedDripstoneConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<PointedDripstoneConfiguration> context) {
        WorldGenLevel levelaccessor = context.level();
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        PointedDripstoneConfiguration pointeddripstoneconfiguration = (PointedDripstoneConfiguration)context.config();
        Optional<Direction> optional = ReclaimitePointedDripstoneFeature.getTipDirection((LevelAccessor)levelaccessor, blockpos, randomsource);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.relative(optional.get().getOpposite());
        ReclaimitePointedDripstoneFeature.createPatchOfDripstoneBlocks((LevelAccessor)levelaccessor, randomsource, blockpos1, pointeddripstoneconfiguration);
        int i = randomsource.nextFloat() < pointeddripstoneconfiguration.chanceOfTallerDripstone && ReclaimitePointedDripstoneFeature.isEmptyOrWater(levelaccessor.getBlockState(blockpos.relative(optional.get()))) ? 2 : 1;
        ReclaimitePointedDripstoneFeature.growPointedDripstone((LevelAccessor)levelaccessor, blockpos, optional.get(), randomsource, i);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor level, BlockPos pos, RandomSource random) {
        boolean flag = ReclaimitePointedDripstoneFeature.isDripstoneBase(level.getBlockState(pos.above()));
        boolean flag1 = ReclaimitePointedDripstoneFeature.isDripstoneBase(level.getBlockState(pos.below()));
        if (flag && flag1) {
            return Optional.of(random.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(LevelAccessor level, RandomSource random, BlockPos pos, PointedDripstoneConfiguration config) {
        ReclaimitePointedDripstoneFeature.placeDripstoneBlockIfPossible(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (random.nextFloat() > config.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = pos.relative(direction);
            ReclaimitePointedDripstoneFeature.placeDripstoneBlockIfPossible(level, blockpos);
            if (random.nextFloat() > config.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.relative(Direction.getRandom((RandomSource)random));
            ReclaimitePointedDripstoneFeature.placeDripstoneBlockIfPossible(level, blockpos1);
            if (random.nextFloat() > config.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.relative(Direction.getRandom((RandomSource)random));
            ReclaimitePointedDripstoneFeature.placeDripstoneBlockIfPossible(level, blockpos2);
        }
    }

    protected static void buildBaseToTipColumn(Direction direction, int height, RandomSource random, Consumer<BlockState> blockSetter) {
        if (height >= 3) {
            blockSetter.accept(ReclaimitePointedDripstoneFeature.createPointedDripstone(direction, DripstoneThickness.BASE, false));
            for (int i = 0; i < height - 3; ++i) {
                blockSetter.accept(ReclaimitePointedDripstoneFeature.createPointedDripstone(direction, DripstoneThickness.MIDDLE, false));
            }
        }
        if (height >= 2) {
            blockSetter.accept(ReclaimitePointedDripstoneFeature.createPointedDripstone(direction, DripstoneThickness.FRUSTUM, false));
        }
        if (height >= 1) {
            blockSetter.accept(ReclaimitePointedDripstoneFeature.createPointedDripstone(direction, DripstoneThickness.TIP, (double)random.nextFloat() > 0.2));
        }
    }

    protected static void growPointedDripstone(LevelAccessor level, BlockPos pos, Direction direction, RandomSource random, int height) {
        if (ReclaimitePointedDripstoneFeature.isDripstoneBase(level.getBlockState(pos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
            ReclaimitePointedDripstoneFeature.buildBaseToTipColumn(direction, height, random, state -> {
                if (state.is(Blocks.POINTED_DRIPSTONE)) {
                    state = (BlockState)state.setValue((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt((BlockPos)blockpos$mutableblockpos)));
                }
                level.setBlock((BlockPos)blockpos$mutableblockpos, state, 2);
                blockpos$mutableblockpos.move(direction);
            });
        }
    }

    protected static void placeDripstoneBlockIfPossible(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(BlockTags.DRIPSTONE_REPLACEABLE)) {
            level.setBlock(pos, Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 2);
        }
    }

    private static BlockState createPointedDripstone(Direction direction, DripstoneThickness dripstoneThickness, boolean reclaimite) {
        return (BlockState)((BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)direction)).setValue((Property)PointedDripstoneBlock.THICKNESS, (Comparable)dripstoneThickness)).setValue((Property)BlockUtils.RECLAMITE_SHARDED, (Comparable)Boolean.valueOf(reclaimite));
    }

    public static boolean isDripstoneBase(BlockState state) {
        return state.is(Blocks.DRIPSTONE_BLOCK) || state.is(BlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }
}

