/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.sashakyotoz.variousworld.datagen.ModAdvancementProvider;
import net.sashakyotoz.variousworld.datagen.ModBlockStateProvider;
import net.sashakyotoz.variousworld.datagen.ModDataMapProvider;
import net.sashakyotoz.variousworld.datagen.ModDatapackProvider;
import net.sashakyotoz.variousworld.datagen.ModItemModelProvider;
import net.sashakyotoz.variousworld.datagen.ModLanguageProvider;
import net.sashakyotoz.variousworld.datagen.ModRecipeProvider;
import net.sashakyotoz.variousworld.datagen.loot.ModBlockLootTableProvider;
import net.sashakyotoz.variousworld.datagen.loot.ModEntityLootTableProvider;
import net.sashakyotoz.variousworld.datagen.loot.ModGlobalLootModifierProvider;
import net.sashakyotoz.variousworld.datagen.tags.ModBlockTagProvider;
import net.sashakyotoz.variousworld.datagen.tags.ModEntityTagProvider;
import net.sashakyotoz.variousworld.datagen.tags.ModItemTagProvider;

@EventBusSubscriber(modid="various_world", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        CompletableFuture newLookup = ((ModDatapackProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModDatapackProvider(packOutput, lookupProvider))).getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModLanguageProvider(packOutput, "en_us", false));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ModEntityLootTableProvider::new, LootContextParamSets.ENTITY)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, newLookup));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, newLookup, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, newLookup, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTagProvider(packOutput, newLookup, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(packOutput, newLookup));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, newLookup));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, newLookup, existingFileHelper));
    }
}

