/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.blocks.custom.SodaliteWartBlock;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "various_world", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.CUBE)) {
            this.simpleBlockWithItem((Block)block.get(), this.cubeAll((Block)block.get()));
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.PILLAR)) {
            this.logBlockWithItem(block);
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.CROSS)) {
            this.crossBlock(block);
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.DIRECTIONAL_CROSS)) {
            this.directionalCrossBlock(block);
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.GRASS)) {
            this.grassBlock(block);
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.CROSS_POTTED)) {
            this.pottedCrossBlock(block);
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.TRAPDOOR)) {
            this.trapdoorBlock((TrapDoorBlock)block.get(), this.blockTexture((Block)block.get()), true);
            this.blockItem(block, "_bottom");
        }
        for (DeferredBlock<?> block : VWRegistryHelper.getModelList(VWRegistryHelper.Models.DOOR)) {
            this.doorBlock((DoorBlock)block.get(), this.extend(this.blockTexture((Block)block.get()), "_top"), this.extend(this.blockTexture((Block)block.get()), "_bottom"));
            this.itemModels().basicItem(block.asItem());
        }
        for (DeferredBlock<?> block : VWRegistryHelper.BLOCK_SETS.keySet()) {
            this.blockWithItem(block);
            for (Map.Entry<VWRegistryHelper.Models, DeferredBlock<?>> entry : VWRegistryHelper.BLOCK_SETS.get(block).entrySet()) {
                if (entry.getKey() == VWRegistryHelper.Models.STAIRS) {
                    this.stairsBlock((StairBlock)entry.getValue().get(), this.blockTexture((Block)block.get()));
                    this.simpleBlockItem((Block)entry.getValue().get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + entry.getValue().getId().getPath()));
                }
                if (entry.getKey() == VWRegistryHelper.Models.SLAB) {
                    this.slabBlock((SlabBlock)entry.getValue().get(), this.blockTexture((Block)block.get()), this.blockTexture((Block)block.get()));
                    this.simpleBlockItem((Block)entry.getValue().get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + entry.getValue().getId().getPath()));
                }
                if (entry.getKey() == VWRegistryHelper.Models.BUTTON) {
                    this.buttonBlock((ButtonBlock)entry.getValue().get(), this.blockTexture((Block)block.get()));
                    this.buttonItem(entry.getValue(), block);
                }
                if (entry.getKey() == VWRegistryHelper.Models.PRESSURE_PLATE) {
                    this.pressurePlateBlock((PressurePlateBlock)entry.getValue().get(), this.blockTexture((Block)block.get()));
                    this.simpleBlockItem((Block)entry.getValue().get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + entry.getValue().getId().getPath()));
                }
                if (entry.getKey() == VWRegistryHelper.Models.FENCE) {
                    this.fenceBlock((FenceBlock)entry.getValue().get(), this.blockTexture((Block)block.get()));
                    this.fenceItem(entry.getValue(), block);
                }
                if (entry.getKey() == VWRegistryHelper.Models.FENCE_GATE) {
                    this.fenceGateBlock((FenceGateBlock)entry.getValue().get(), this.blockTexture((Block)block.get()));
                    this.blockItem(entry.getValue());
                }
                if (entry.getKey() == VWRegistryHelper.Models.SIGN) {
                    this.signBlock((StandingSignBlock)entry.getValue().get(), (WallSignBlock)VWRegistryHelper.BLOCK_SETS.get(block).get((Object)VWRegistryHelper.Models.WALL_SIGN).get(), this.blockTexture((Block)block.get()));
                }
                if (entry.getKey() != VWRegistryHelper.Models.HANGING_SIGN) continue;
                this.hangingSignBlock((CeilingHangingSignBlock)entry.getValue().get(), (WallHangingSignBlock)VWRegistryHelper.BLOCK_SETS.get(block).get((Object)VWRegistryHelper.Models.WALL_HANGING_SIGN).get(), this.blockTexture((Block)block.get()));
            }
        }
        this.crossWithPropertyBlock(VWBlocks.SODALITE_WART);
        this.stateFromBlockModel(VWBlocks.GEMSMITH_TABLE);
        this.stateFromBlockModel(VWBlocks.ARTIFACT_TABLE);
        this.stateFromBlockModel(VWBlocks.DISASSEMBLY_TABLE);
        this.furnaceFromBlockModels(VWBlocks.GEMSMITH_FURNACE);
        this.petalsBlock(VWBlocks.BLUE_JACARANDA_PETALS);
    }

    private void buttonItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void fenceItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void fenceGateItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_gate_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void wallItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void grassBlock(DeferredBlock<?> block) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture((Block)((Block)VWBlocks.DIRT_WITH_CRYSTALS.get()));
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeBottomTop(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side"), resourcelocation, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_top")));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath()));
    }

    private void stateFromBlockModel(DeferredBlock<?> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath()));
    }

    private void furnaceFromBlockModels(DeferredBlock<?> block) {
        Function<BlockState, ModelFile> furnaceFired = state -> new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath() + "_fired");
        Function<BlockState, ModelFile> furnace = state -> new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath());
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int rotationX = 0;
            int rotationY = 0;
            switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
                case DOWN: {
                    rotationX = 90;
                    break;
                }
                case EAST: {
                    rotationY = 90;
                    break;
                }
                case SOUTH: {
                    rotationY = 180;
                    break;
                }
                case WEST: {
                    rotationY = 270;
                }
            }
            ModelFile selectedModel = (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? (ModelFile)furnaceFired.apply((BlockState)state) : (ModelFile)furnace.apply((BlockState)state);
            return ConfiguredModel.builder().modelFile(selectedModel).rotationX(rotationX).rotationY(rotationY).build();
        });
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + block.getId().getPath()));
    }

    private void crossBlock(DeferredBlock<?> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.blockTexture((Block)block.get())));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private void pottedCrossBlock(DeferredBlock<?> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/flower_pot_cross"))).texture("plant", this.blockBVWTexture(((FlowerPotBlock)block.get()).getPotted())));
        this.itemModels().simpleBlockItem((Block)block.get());
    }

    private void directionalCrossBlock(DeferredBlock<?> block) {
        Function<BlockState, ModelFile> modelFunc = state -> this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.blockTexture((Block)block.get()));
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        });
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private ResourceLocation blockBVWTexture(Block block) {
        return VariousWorld.createVWLocation("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath());
    }

    private void crossWithPropertyBlock(DeferredBlock<?> block) {
        if (block.get() instanceof SodaliteWartBlock) {
            ((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)SodaliteWartBlock.CLOSED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath() + "_closed", this.extend(this.blockTexture((Block)block.get()), "_closed"))).addModel()).partialState().with((Property)SodaliteWartBlock.CLOSED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.blockTexture((Block)block.get()))).addModel();
        } else {
            this.simpleBlock((Block)block.get(), (ModelFile)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.blockTexture((Block)block.get())));
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private void petalsBlock(DeferredBlock<?> block) {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "minecraft:block/flowerbed_1")).texture("flowerbed", this.modLoc("block/" + this.name(block)))).texture("stem", this.modLoc("block/" + this.name(block) + "_stem"));
        for (int i = 1; i < 5; ++i) {
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + i, "minecraft:block/flowerbed_" + i)).texture("flowerbed", this.modLoc("block/" + this.name(block)))).texture("stem", this.modLoc("block/" + this.name(block) + "_stem"));
        }
        MultiPartBlockStateBuilder multipart = this.getMultipartBuilder((Block)block.get());
        for (int amount = 1; amount < 5; ++amount) {
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + this.name(block) + "_" + amount));
            block12: for (Direction dir : Direction.Plane.HORIZONTAL) {
                int yRot = switch (dir) {
                    case Direction.EAST -> 90;
                    case Direction.SOUTH -> 180;
                    case Direction.WEST -> 270;
                    default -> 0;
                };
                switch (amount) {
                    case 2: {
                        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)model).rotationY(yRot).addModel()).condition((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable[])new Integer[]{2, 3, 4}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dir}).end();
                        continue block12;
                    }
                    case 3: {
                        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)model).rotationY(yRot).addModel()).condition((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable[])new Integer[]{3, 4}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dir}).end();
                        continue block12;
                    }
                    case 4: {
                        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)model).rotationY(yRot).addModel()).condition((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable[])new Integer[]{4}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dir}).end();
                        continue block12;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)model).rotationY(yRot).addModel()).condition((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable[])new Integer[]{1, 2, 3, 4}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dir}).end();
            }
        }
        this.itemModels().basicItem(block.asItem());
    }

    public String name(DeferredBlock<?> block) {
        return this.key((Block)block.get()).getPath();
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private void logBlockWithItem(DeferredBlock<?> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().cubeColumn(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), this.blockTexture((Block)block.get()), this.extend(this.blockTexture((Block)block.get()), "_top")));
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        String var10000 = rl.getNamespace();
        String var10001 = rl.getPath();
        return ResourceLocation.fromNamespaceAndPath((String)var10000, (String)(var10001 + suffix));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("various_world:block/" + deferredBlock.getId().getPath() + appendix));
    }
}

