/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "various_world", existingFileHelper);
    }

    protected void registerModels() {
        for (Map.Entry<DeferredItem<?>, ModelTemplate> entry : VWRegistryHelper.ITEM_MODELS.entrySet()) {
            if (entry.getValue() != ModelTemplates.FLAT_ITEM) continue;
            this.simpleItem(entry.getKey());
        }
        for (DeferredHolder deferredHolder : VWRegistryHelper.ITEMS.getEntries()) {
            if (!(deferredHolder.get() instanceof DeferredSpawnEggItem)) continue;
            this.simpleEggItem((DeferredHolder<Item, ? extends Item>)deferredHolder);
        }
        this.simpleItemlessModel("sodalite_sword");
        this.simpleItemlessModel("sodalite_pickaxe");
        this.simpleItemlessModel("sodalite_axe");
        this.simpleItemlessModel("sodalite_shovel");
        this.simpleItemlessModel("sodalite_hoe");
        this.simpleItemlessModel("amethyst_sword");
        this.simpleItemlessModel("amethyst_pickaxe");
        this.simpleItemlessModel("amethyst_axe");
        this.simpleItemlessModel("amethyst_shovel");
        this.simpleItemlessModel("amethyst_hoe");
        this.simpleGlowItemlessModel("reclaimite_sword");
        this.simpleGlowItemlessModel("reclaimite_pickaxe");
        this.simpleGlowItemlessModel("reclaimite_axe");
        this.simpleGlowItemlessModel("reclaimite_shovel");
        this.simpleGlowItemlessModel("reclaimite_hoe");
    }

    private ItemModelBuilder simpleItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder simpleItemlessModel(String path) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(VariousWorld.createVWLocation("item/" + path).getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", VariousWorld.createVWLocation("item/crystals/" + path));
    }

    private ItemModelBuilder simpleGlowItemlessModel(String path) {
        String modelName = VariousWorld.createVWLocation("item/" + path).getPath();
        ItemModelBuilder base = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(modelName, ResourceLocation.parse((String)"item/generated"))).texture("layer0", VariousWorld.createVWLocation("item/crystals/" + path));
        base.customLoader((parent, existingFileHelper) -> new CustomLoaderBuilder<ItemModelBuilder>(this, ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item_layers"), parent, existingFileHelper, true){

            public JsonObject toJson(JsonObject json) {
                JsonObject neoforgeData = new JsonObject();
                JsonObject layers = new JsonObject();
                JsonObject layer0 = new JsonObject();
                layer0.addProperty("block_light", (Number)15);
                layer0.addProperty("sky_light", (Number)15);
                layers.add("0", (JsonElement)layer0);
                neoforgeData.add("layers", (JsonElement)layers);
                json.add("neoforge_data", (JsonElement)neoforgeData);
                JsonObject renderTypes = new JsonObject();
                JsonArray arr = new JsonArray();
                arr.add((Number)0);
                renderTypes.add("minecraft:translucent", (JsonElement)arr);
                json.add("render_types", (JsonElement)renderTypes);
                return super.toJson(json);
            }
        });
        return base;
    }

    private ItemModelBuilder simpleEggItem(DeferredHolder<Item, ? extends Item> item) {
        return (ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/template_spawn_egg"));
    }

    private ItemModelBuilder handheldItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"various_world", (String)("item/" + item.getId().getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

