/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;
import net.sashakyotoz.variousworld.init.VWVillagers;

public class ModLanguageProvider
extends LanguageProvider {
    private static final String NORMAL_CHARS = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = " \u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";
    private final boolean upsideDown;

    public ModLanguageProvider(PackOutput output, String locale, boolean upsideDown) {
        super(output, "various_world", locale);
        this.upsideDown = upsideDown;
    }

    protected void addTranslations() {
        VWRegistryHelper.ITEMS.getEntries().stream().filter(item -> !(item.get() instanceof BlockItem)).forEach(this::addItem);
        VWRegistryHelper.BLOCKS.getEntries().forEach(this::addBlock);
        VWRegistryHelper.ENTITIES.getEntries().forEach(this::addEntityType);
        VWVillagers.VILLAGER_PROFESSIONS.getEntries().forEach(this::addVillagerType);
        this.add("creativetab.various_world_tab", "Various World");
        this.add("biome.various_world.crystalline_forest", "Crystalline Forest");
        this.add("biome.various_world.blue_jacaranda_meadow", "Blue Jacaranda Meadow");
        this.add("biome.various_world.reclaimite_caves", "Reclaimite Caves");
        this.add("jei.various_world.disassembly_table", "Disassembly Table \n table block that allows to gather part of crafting ingredients of item. Only 3x3 recipes are detectable");
        this.add("jei.various_world.artifact_table", "Artifact Table \n table block that allows to spread effect of potion in small area. \n Requires redstone power, potion, dragon breath and some valuable item to work.");
        this.add("jei.various_world.gemsmith_table", "Gemsmithing Table \n table block that allows to modify tools adding materials. \n Recipes and models are registering dynamically, only config changes are required");
        this.add("advancement.various_world.across_the_world", "Across The Various World");
        this.add("advancement.various_world.across_the_world.desc", "Get into any biome of Various World");
        this.add("advancement.various_world.master_of_various_world", "Master of Various World");
        this.add("advancement.various_world.master_of_various_world.desc", "Get a curiosity from a each of foreign biome");
        this.add("advancement.various_world.tabled", "Tabled");
        this.add("advancement.various_world.tabled.desc", "Acquire each of mod's working table");
    }

    private void addEntityType(DeferredHolder<EntityType<?>, ?> entity) {
        String key = entity.getId().getPath();
        super.add("entity.various_world." + key, this.convertToName(key));
    }

    private void addVillagerType(DeferredHolder<VillagerProfession, ?> entity) {
        String key = entity.getId().getPath();
        super.add("entity.minecraft.villager.various_world." + key, this.convertToName(key));
    }

    public void add(String key, String value) {
        if (this.upsideDown) {
            super.add(key, ModLanguageProvider.toUpsideDown(value));
        } else {
            super.add(key, value);
        }
    }

    private void addBlock(DeferredHolder<Block, ?> block) {
        String key = block.getId().getPath();
        super.add("block.various_world." + key, this.convertToName(key));
    }

    private void addItem(DeferredHolder<Item, ?> item) {
        String key = item.getId().getPath();
        super.add("item.various_world." + key, this.convertToName(key));
    }

    private String convertToName(String key) {
        StringBuilder builder = new StringBuilder(key.substring(0, 1).toUpperCase() + key.substring(1));
        for (int i = 1; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.deleteCharAt(i);
            builder.replace(i, i + 1, " " + Character.toUpperCase(builder.charAt(i)));
        }
        String name = builder.toString();
        return this.upsideDown ? ModLanguageProvider.toUpsideDown(name) : name;
    }

    private static String toUpsideDown(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = name.length() - 1; i >= 0; --i) {
            if (i > 2 && name.substring(i - 3, i + 1).equals("%1$s")) {
                builder.append(name, i - 3, i + 1);
                i -= 4;
                continue;
            }
            char upsideDown = UPSIDE_DOWN_CHARS.charAt(NORMAL_CHARS.indexOf(name.charAt(i)));
            builder.append(upsideDown);
        }
        return builder.toString();
    }
}

