/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.sashakyotoz.variousworld.datagen.builders.GemsmithRecipeBuilder;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;
import net.sashakyotoz.variousworld.init.VWTags;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        for (DeferredBlock<?> block : VWRegistryHelper.BLOCK_SETS.keySet()) {
            for (Map.Entry<VWRegistryHelper.Models, DeferredBlock<?>> entry : VWRegistryHelper.BLOCK_SETS.get(block).entrySet()) {
                switch (entry.getKey()) {
                    case STAIRS: {
                        this.stairs(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case SLAB: {
                        ModRecipeProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)entry.getValue().get()), (ItemLike)((ItemLike)block.get()));
                        break;
                    }
                    case DOOR: {
                        this.door(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case TRAPDOOR: {
                        this.trapdoor(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case BUTTON: {
                        this.button(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case PRESSURE_PLATE: {
                        ModRecipeProvider.pressurePlate((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)entry.getValue().get()), (ItemLike)((ItemLike)block.get()));
                        break;
                    }
                    case FENCE: {
                        this.fence(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case FENCE_GATE: {
                        this.fenceGate(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case SIGN: {
                        this.sign(recipeOutput, (ItemLike)entry.getValue().get(), (ItemLike)block.get());
                        break;
                    }
                    case HANGING_SIGN: {
                        ModRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)entry.getValue().get()), (ItemLike)((ItemLike)block.get()));
                    }
                }
            }
        }
        ModRecipeProvider.woodFromLogs((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.CRYSTALIC_OAK_WOOD.get()), (ItemLike)((ItemLike)VWBlocks.CRYSTALIC_OAK_LOG.get()));
        ModRecipeProvider.woodFromLogs((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.STRIPPED_CRYSTALIC_OAK_WOOD.get()), (ItemLike)((ItemLike)VWBlocks.STRIPPED_CRYSTALIC_OAK_LOG.get()));
        ModRecipeProvider.planksFromLog((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.CRYSTALIC_OAK_PLANKS.get()), VWTags.Items.CRYSTALIC_OAK_LOGS, (int)4);
        ModRecipeProvider.woodFromLogs((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.BLUE_JACARANDA_WOOD.get()), (ItemLike)((ItemLike)VWBlocks.BLUE_JACARANDA_LOG.get()));
        ModRecipeProvider.woodFromLogs((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.STRIPPED_BLUE_JACARANDA_WOOD.get()), (ItemLike)((ItemLike)VWBlocks.STRIPPED_BLUE_JACARANDA_LOG.get()));
        ModRecipeProvider.planksFromLog((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)VWBlocks.BLUE_JACARANDA_PLANKS.get()), VWTags.Items.BLUE_JACARANDA_LOGS, (int)4);
        ModRecipeProvider.twoByTwoPacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VWBlocks.SODALITE_BLOCK.get()), (ItemLike)((ItemLike)VWItems.SODALITE_SHARD.get()));
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof TieredItem) {
                this.gemsmith(recipeOutput, (ItemLike)item, (ItemLike)VWItems.SODALITE_SHARD.get());
                this.gemsmith(recipeOutput, (ItemLike)item, (ItemLike)VWItems.CRYSTALLINE_SLIME_BALL.get());
                this.gemsmith(recipeOutput, (ItemLike)item, (ItemLike)Items.AMETHYST_SHARD);
            }
        });
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.MAGENTA_DYE).unlockedBy("has_block", ModRecipeProvider.has((ItemLike)((ItemLike)VWBlocks.BLUE_JACARANDA_PETALS.get()))).requires((ItemLike)VWBlocks.BLUE_JACARANDA_PETALS.get()).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VWBlocks.GEMSMITH_TABLE.get())).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('d'), (ItemLike)Items.DEEPSLATE_BRICKS).pattern("is ").pattern("dd ").pattern("dd ").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)Items.DEEPSLATE_BRICKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VWBlocks.GEMSMITH_FURNACE.get())).define(Character.valueOf('f'), (ItemLike)Items.FURNACE).define(Character.valueOf('d'), (ItemLike)Items.DEEPSLATE_BRICKS).pattern("ddd").pattern("dfd").pattern("ddd").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)Items.DEEPSLATE_BRICKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VWBlocks.ARTIFACT_TABLE.get())).define(Character.valueOf('g'), (ItemLike)Items.GLASS).define(Character.valueOf('p'), (ItemLike)Items.PURPLE_CARPET).define(Character.valueOf('s'), (ItemLike)VWItems.SODALITE_SHARD.get()).define(Character.valueOf('b'), (ItemLike)VWBlocks.BLUE_JACARANDA_PLANKS.get()).pattern("sgs").pattern("bpb").pattern("bbb").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)((ItemLike)VWBlocks.BLUE_JACARANDA_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VWBlocks.DISASSEMBLY_TABLE.get())).define(Character.valueOf('g'), (ItemLike)Items.GLASS).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('s'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('d'), (ItemLike)Items.DRIPSTONE_BLOCK).pattern("igi").pattern("sds").pattern("sds").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)Items.DRIPSTONE_BLOCK)).save(recipeOutput);
    }

    private void sign(RecipeOutput recipeOutput, ItemLike sign, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)3).group("sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("###").pattern("###").pattern(" X ").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void stairs(RecipeOutput recipeOutput, ItemLike stairs, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), material).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void door(RecipeOutput recipeOutput, ItemLike door, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)door, (int)3).define(Character.valueOf('#'), material).pattern("##").pattern("##").pattern("##").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void trapdoor(RecipeOutput recipeOutput, ItemLike trapdoor, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trapdoor, (int)2).define(Character.valueOf('#'), material).pattern("###").pattern("###").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void button(RecipeOutput recipeOutput, ItemLike button, ItemLike material) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button).requires(material).unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void fence(RecipeOutput recipeOutput, ItemLike fence, ItemLike material) {
        Item item = fence == Blocks.NETHER_BRICK_FENCE ? Items.NETHER_BRICK : Items.STICK;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).define(Character.valueOf('W'), material).define(Character.valueOf('#'), (ItemLike)item).pattern("W#W").pattern("W#W").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void fenceGate(RecipeOutput recipeOutput, ItemLike fenceGate, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), material).pattern("#W#").pattern("#W#").unlockedBy("has_block", ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    private void gemsmith(RecipeOutput recipeOutput, ItemLike tool, ItemLike gem) {
        GemsmithRecipeBuilder.smithing(Ingredient.of((ItemLike[])new ItemLike[]{tool}), Ingredient.of((ItemLike[])new ItemLike[]{gem}), RecipeCategory.COMBAT, tool.asItem()).unlocks("has_gem", ModRecipeProvider.has((ItemLike)gem)).save(recipeOutput, String.format("%s_%s_gemsmithing", ModRecipeProvider.getItemName((ItemLike)tool), ModRecipeProvider.getItemName((ItemLike)gem)));
    }
}

